/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class ServiceInterfaceMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -447051823681281236L;
/*     */   private JavaWsdlMapping javaWsdlMapping;
/*     */   private String serviceInterface;
/*     */   private QName wsdlServiceName;
/*  51 */   private List portMappings = new ArrayList();
/*     */ 
/*     */   public ServiceInterfaceMapping(JavaWsdlMapping javaWsdlMapping)
/*     */   {
/*  55 */     this.javaWsdlMapping = javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/*  60 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public String getServiceInterface()
/*     */   {
/*  65 */     return this.serviceInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceInterface(String serviceInterface)
/*     */   {
/*  70 */     this.serviceInterface = serviceInterface;
/*     */   }
/*     */ 
/*     */   public QName getWsdlServiceName()
/*     */   {
/*  75 */     return this.wsdlServiceName;
/*     */   }
/*     */ 
/*     */   public void setWsdlServiceName(QName wsdlServiceName)
/*     */   {
/*  80 */     this.wsdlServiceName = wsdlServiceName;
/*     */   }
/*     */ 
/*     */   public PortMapping[] getPortMappings()
/*     */   {
/*  85 */     PortMapping[] arr = new PortMapping[this.portMappings.size()];
/*  86 */     this.portMappings.toArray(arr);
/*  87 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addPortMapping(PortMapping portMapping)
/*     */   {
/*  92 */     this.portMappings.add(portMapping);
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/*  97 */     StringBuffer sb = new StringBuffer();
/*  98 */     sb.append("<service-interface-mapping>");
/*  99 */     sb.append("<service-interface>").append(this.serviceInterface).append("</service-interface>");
/* 100 */     sb.append("<wsdl-service-name xmlns:").append(this.wsdlServiceName.getPrefix()).append("='");
/* 101 */     sb.append(this.wsdlServiceName.getNamespaceURI()).append("'>");
/* 102 */     sb.append(this.wsdlServiceName.getPrefix()).append(":").append(this.wsdlServiceName.getLocalPart());
/* 103 */     sb.append("</wsdl-service-name>");
/*     */ 
/* 105 */     Iterator iter = this.portMappings.iterator();
/* 106 */     while ((iter != null) && (iter.hasNext()))
/* 107 */       sb.append(((PortMapping)iter.next()).serialize());
/* 108 */     sb.append("</service-interface-mapping>");
/* 109 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping
 * JD-Core Version:    0.6.0
 */