/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ 
/*     */ public class ServiceEndpointMethodMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 7857267872017006227L;
/*     */   private ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping;
/*     */   private String javaMethodName;
/*     */   private String wsdlOperation;
/*     */   private boolean wrappedElement;
/*  51 */   private List methodParamPartsMappings = new ArrayList();
/*     */   private WsdlReturnValueMapping wsdlReturnValueMapping;
/*     */ 
/*     */   public ServiceEndpointMethodMapping(ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping)
/*     */   {
/*  57 */     this.serviceEndpointInterfaceMapping = serviceEndpointInterfaceMapping;
/*     */   }
/*     */ 
/*     */   public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMapping()
/*     */   {
/*  62 */     return this.serviceEndpointInterfaceMapping;
/*     */   }
/*     */ 
/*     */   public String getJavaMethodName()
/*     */   {
/*  67 */     return this.javaMethodName;
/*     */   }
/*     */ 
/*     */   public void setJavaMethodName(String javaMethodName)
/*     */   {
/*  72 */     this.javaMethodName = javaMethodName;
/*     */   }
/*     */ 
/*     */   public MethodParamPartsMapping[] getMethodParamPartsMappings()
/*     */   {
/*  77 */     MethodParamPartsMapping[] arr = new MethodParamPartsMapping[this.methodParamPartsMappings.size()];
/*  78 */     this.methodParamPartsMappings.toArray(arr);
/*  79 */     return arr;
/*     */   }
/*     */ 
/*     */   public MethodParamPartsMapping getMethodParamPartsMappingByPartName(String partName)
/*     */   {
/*  84 */     MethodParamPartsMapping paramMapping = null;
/*  85 */     for (int i = 0; (paramMapping == null) && (i < this.methodParamPartsMappings.size()); i++)
/*     */     {
/*  87 */       MethodParamPartsMapping aux = (MethodParamPartsMapping)this.methodParamPartsMappings.get(i);
/*  88 */       if (aux.getWsdlMessageMapping().getWsdlMessagePartName().equals(partName))
/*  89 */         paramMapping = aux;
/*     */     }
/*  91 */     return paramMapping;
/*     */   }
/*     */ 
/*     */   public MethodParamPartsMapping getMethodParamPartsMappingByPosition(int pos)
/*     */   {
/*  96 */     MethodParamPartsMapping paramMapping = null;
/*  97 */     for (int i = 0; (paramMapping == null) && (i < this.methodParamPartsMappings.size()); i++)
/*     */     {
/*  99 */       MethodParamPartsMapping aux = (MethodParamPartsMapping)this.methodParamPartsMappings.get(i);
/* 100 */       if (aux.getParamPosition() == pos)
/* 101 */         paramMapping = aux;
/*     */     }
/* 103 */     return paramMapping;
/*     */   }
/*     */ 
/*     */   public void addMethodParamPartsMapping(MethodParamPartsMapping methodParamPartsMapping)
/*     */   {
/* 108 */     this.methodParamPartsMappings.add(methodParamPartsMapping);
/*     */   }
/*     */ 
/*     */   public boolean isWrappedElement()
/*     */   {
/* 113 */     return this.wrappedElement;
/*     */   }
/*     */ 
/*     */   public void setWrappedElement(boolean wrappedElement)
/*     */   {
/* 118 */     this.wrappedElement = wrappedElement;
/*     */   }
/*     */ 
/*     */   public String getWsdlOperation()
/*     */   {
/* 123 */     return this.wsdlOperation;
/*     */   }
/*     */ 
/*     */   public void setWsdlOperation(String wsdlOperation)
/*     */   {
/* 128 */     this.wsdlOperation = wsdlOperation;
/*     */   }
/*     */ 
/*     */   public WsdlReturnValueMapping getWsdlReturnValueMapping()
/*     */   {
/* 133 */     return this.wsdlReturnValueMapping;
/*     */   }
/*     */ 
/*     */   public void setWsdlReturnValueMapping(WsdlReturnValueMapping wsdlReturnValueMapping)
/*     */   {
/* 138 */     this.wsdlReturnValueMapping = wsdlReturnValueMapping;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 143 */     StringBuffer sb = new StringBuffer();
/* 144 */     sb.append("<service-endpoint-method-mapping><java-method-name>").append(this.javaMethodName).append("</java-method-name>");
/* 145 */     sb.append("<wsdl-operation>").append(this.wsdlOperation).append("</wsdl-operation>");
/* 146 */     if (this.wrappedElement)
/* 147 */       sb.append("<wrapped-element/>");
/* 148 */     Iterator iter = this.methodParamPartsMappings.iterator();
/* 149 */     while ((iter != null) && (iter.hasNext()))
/* 150 */       sb.append(((MethodParamPartsMapping)iter.next()).serialize());
/* 151 */     if (this.wsdlReturnValueMapping != null)
/* 152 */       sb.append(this.wsdlReturnValueMapping.serialize());
/* 153 */     sb.append("</service-endpoint-method-mapping>");
/* 154 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping
 * JD-Core Version:    0.6.0
 */