/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class JavaXmlTypeMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7671078579082015103L;
/*     */   private JavaWsdlMapping javaWsdlMapping;
/*     */   private String javaType;
/*     */   private QName rootTypeQName;
/*     */   private QName anonymousTypeQName;
/*     */   private String qnameScope;
/*  60 */   private ArrayList variableMappings = new ArrayList();
/*     */ 
/*     */   public JavaXmlTypeMapping(JavaWsdlMapping javaWsdlMapping)
/*     */   {
/*  64 */     this.javaWsdlMapping = javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/*  69 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public String getJavaType()
/*     */   {
/*  74 */     return this.javaType;
/*     */   }
/*     */ 
/*     */   public void setJavaType(String javaType)
/*     */   {
/*  79 */     this.javaType = javaType;
/*     */   }
/*     */ 
/*     */   public String getQnameScope()
/*     */   {
/*  84 */     return this.qnameScope;
/*     */   }
/*     */ 
/*     */   public void setQNameScope(String qnameScope)
/*     */   {
/*  89 */     this.qnameScope = qnameScope;
/*     */   }
/*     */ 
/*     */   public QName getRootTypeQName()
/*     */   {
/*  94 */     return this.rootTypeQName;
/*     */   }
/*     */ 
/*     */   public void setRootTypeQName(QName rootTypeQName)
/*     */   {
/*  99 */     this.rootTypeQName = rootTypeQName;
/*     */   }
/*     */ 
/*     */   public QName getAnonymousTypeQName()
/*     */   {
/* 104 */     return this.anonymousTypeQName;
/*     */   }
/*     */ 
/*     */   public void setAnonymousTypeQName(QName anonymousTypeQName)
/*     */   {
/* 109 */     this.anonymousTypeQName = anonymousTypeQName;
/*     */   }
/*     */ 
/*     */   public VariableMapping[] getVariableMappings()
/*     */   {
/* 114 */     VariableMapping[] arr = new VariableMapping[this.variableMappings.size()];
/* 115 */     this.variableMappings.toArray(arr);
/* 116 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addVariableMapping(VariableMapping variableMapping)
/*     */   {
/* 121 */     this.variableMappings.add(variableMapping);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 126 */     return "[qname=" + this.rootTypeQName + ",javaType=" + this.javaType + ",scope=" + this.qnameScope + "]";
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 131 */     StringBuffer sb = new StringBuffer();
/* 132 */     sb.append("<java-xml-type-mapping>");
/* 133 */     sb.append("<java-type>").append(this.javaType).append("</java-type>");
/*     */ 
/* 135 */     if (this.rootTypeQName != null)
/*     */     {
/* 137 */       sb.append("<root-type-qname xmlns:typeNS='").append(this.rootTypeQName.getNamespaceURI()).append("'>");
/* 138 */       sb.append(this.rootTypeQName.getPrefix()).append(":").append(this.rootTypeQName.getLocalPart());
/* 139 */       sb.append("</root-type-qname>");
/*     */     }
/*     */ 
/* 142 */     if (this.anonymousTypeQName != null)
/*     */     {
/* 144 */       sb.append("<anonymous-type-qname xmlns:typeNS='").append(this.anonymousTypeQName.getNamespaceURI()).append("'>");
/* 145 */       sb.append(this.anonymousTypeQName.getPrefix()).append(":").append(this.anonymousTypeQName.getLocalPart());
/* 146 */       sb.append("</anonymous-type-qname>");
/*     */     }
/*     */ 
/* 149 */     sb.append("<qname-scope>").append(this.qnameScope).append("</qname-scope>");
/*     */ 
/* 151 */     int len = this.variableMappings.size();
/* 152 */     for (int i = 0; i < len; i++) {
/* 153 */       sb.append(((VariableMapping)this.variableMappings.get(i)).serialize());
/*     */     }
/* 155 */     sb.append("</java-xml-type-mapping>");
/* 156 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping
 * JD-Core Version:    0.6.0
 */