/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class JavaWsdlMappingFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*  50 */   private static Logger log = Logger.getLogger(JavaWsdlMappingFactory.class);
/*     */ 
/*     */   public static JavaWsdlMappingFactory newInstance()
/*     */   {
/*  62 */     return new JavaWsdlMappingFactory();
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping parse(URL mappingURL)
/*     */     throws IOException
/*     */   {
/*  70 */     if (mappingURL == null)
/*     */     {
/*  72 */       throw new IllegalArgumentException("JAXRPC mapping URL cannot be null");
/*     */     }
/*     */ 
/*  76 */     InputStream is = new ResourceURL(mappingURL).openStream();
/*     */     try
/*     */     {
/*  79 */       Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  80 */       JavaWsdlMapping javaWsdlMapping = (JavaWsdlMapping)unmarshaller.unmarshal(is, this, null);
/*  81 */       JavaWsdlMapping localJavaWsdlMapping1 = javaWsdlMapping;
/*     */       return localJavaWsdlMapping1;
/*     */     }
/*     */     catch (JBossXBException e)
/*     */     {
/*  85 */       IOException ioex = new IOException("Cannot parse: " + mappingURL);
/*  86 */       Throwable cause = e.getCause();
/*  87 */       if (cause != null)
/*  88 */         ioex.initCause(cause);
/*  89 */       throw ioex;
/*     */     }
/*     */     finally
/*     */     {
/*  93 */       is.close(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 103 */     return new JavaWsdlMapping();
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/* 108 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(JavaWsdlMapping javaWsdlMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 116 */     log.trace("newChild: " + localName);
/* 117 */     if ("package-mapping".equals(localName))
/*     */     {
/* 119 */       return new PackageMapping(javaWsdlMapping);
/*     */     }
/* 121 */     if ("java-xml-type-mapping".equals(localName))
/*     */     {
/* 123 */       return new JavaXmlTypeMapping(javaWsdlMapping);
/*     */     }
/* 125 */     if ("exception-mapping".equals(localName))
/*     */     {
/* 127 */       return new ExceptionMapping(javaWsdlMapping);
/*     */     }
/* 129 */     if ("service-interface-mapping".equals(localName))
/*     */     {
/* 131 */       return new ServiceInterfaceMapping(javaWsdlMapping);
/*     */     }
/* 133 */     if ("service-endpoint-interface-mapping".equals(localName))
/*     */     {
/* 135 */       return new ServiceEndpointInterfaceMapping(javaWsdlMapping);
/*     */     }
/* 137 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(JavaWsdlMapping javaWsdlMapping, PackageMapping packageMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 145 */     log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + packageMapping + "]");
/* 146 */     javaWsdlMapping.addPackageMapping(packageMapping);
/*     */   }
/*     */ 
/*     */   public void addChild(JavaWsdlMapping javaWsdlMapping, JavaXmlTypeMapping typeMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 154 */     log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + typeMapping + "]");
/* 155 */     javaWsdlMapping.addJavaXmlTypeMappings(typeMapping);
/*     */   }
/*     */ 
/*     */   public void addChild(JavaWsdlMapping javaWsdlMapping, ExceptionMapping exceptionMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 163 */     log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + exceptionMapping + "]");
/* 164 */     javaWsdlMapping.addExceptionMappings(exceptionMapping);
/*     */   }
/*     */ 
/*     */   public void addChild(JavaWsdlMapping javaWsdlMapping, ServiceInterfaceMapping siMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 172 */     log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + siMapping + "]");
/* 173 */     javaWsdlMapping.addServiceInterfaceMappings(siMapping);
/*     */   }
/*     */ 
/*     */   public void addChild(JavaWsdlMapping javaWsdlMapping, ServiceEndpointInterfaceMapping seiMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 182 */     log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + seiMapping + "]");
/* 183 */     javaWsdlMapping.addServiceEndpointInterfaceMappings(seiMapping);
/*     */   }
/*     */ 
/*     */   public void setValue(PackageMapping packageMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 191 */     log.trace("setValue: [obj=" + packageMapping + ",localName=" + localName + ",value=" + value + "]");
/* 192 */     if ("package-type".equals(localName))
/*     */     {
/* 194 */       packageMapping.setPackageType(value);
/*     */     }
/* 196 */     else if ("namespaceURI".equals(localName))
/*     */     {
/* 198 */       packageMapping.setNamespaceURI(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(JavaXmlTypeMapping typeMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 207 */     log.trace("newChild: " + localName);
/* 208 */     if ("variable-mapping".equals(localName))
/*     */     {
/* 210 */       return new VariableMapping(typeMapping);
/*     */     }
/* 212 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(JavaXmlTypeMapping typeMapping, VariableMapping variableMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 220 */     log.trace("addChild: [obj=" + typeMapping + ",child=" + variableMapping + "]");
/* 221 */     typeMapping.addVariableMapping(variableMapping);
/*     */   }
/*     */ 
/*     */   public void setValue(JavaXmlTypeMapping typeMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 229 */     log.trace("setValue: [obj=" + typeMapping + ",localName=" + localName + ",value=" + value + "]");
/* 230 */     if ("java-type".equals(localName))
/*     */     {
/* 232 */       typeMapping.setJavaType(value);
/*     */     }
/* 234 */     else if ("root-type-qname".equals(localName))
/*     */     {
/* 236 */       QName qname = navigator.resolveQName(value);
/* 237 */       typeMapping.setRootTypeQName(qname);
/*     */     }
/* 239 */     else if ("anonymous-type-qname".equals(localName))
/*     */     {
/* 241 */       QName qname = null;
/*     */       try
/*     */       {
/* 245 */         qname = navigator.resolveQName(value);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/* 252 */       if (qname == null)
/*     */       {
/* 255 */         int index = value.lastIndexOf(':');
/* 256 */         if (index > 0)
/*     */         {
/* 258 */           String nsURI = value.substring(0, index);
/* 259 */           String localPart = value.substring(index + 1);
/* 260 */           qname = new QName(nsURI, localPart);
/*     */         }
/*     */       }
/*     */ 
/* 264 */       if (qname == null) {
/* 265 */         throw new IllegalArgumentException("Invalid anonymous qname: " + value);
/*     */       }
/* 267 */       typeMapping.setAnonymousTypeQName(qname);
/*     */     }
/* 269 */     else if ("qname-scope".equals(localName))
/*     */     {
/* 271 */       typeMapping.setQNameScope(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(ExceptionMapping exceptionMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 280 */     log.trace("setValue: [obj=" + exceptionMapping + ",localName=" + localName + ",value=" + value + "]");
/* 281 */     if ("exception-type".equals(localName))
/*     */     {
/* 283 */       exceptionMapping.setExceptionType(value);
/*     */     }
/* 285 */     else if ("wsdl-message".equals(localName))
/*     */     {
/* 287 */       exceptionMapping.setWsdlMessage(navigator.resolveQName(value));
/*     */     }
/* 289 */     else if ("constructor-parameter-order".equals(localName))
/*     */     {
/* 291 */       exceptionMapping.addConstructorParameter(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(ServiceInterfaceMapping siMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 300 */     log.trace("newChild: " + localName);
/* 301 */     if ("port-mapping".equals(localName))
/*     */     {
/* 303 */       return new PortMapping(siMapping);
/*     */     }
/* 305 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(ServiceInterfaceMapping siMapping, PortMapping portMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 313 */     log.trace("addChild: [obj=" + siMapping + ",child=" + portMapping + "]");
/* 314 */     siMapping.addPortMapping(portMapping);
/*     */   }
/*     */ 
/*     */   public void setValue(ServiceInterfaceMapping siMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 322 */     log.trace("setValue: [obj=" + siMapping + ",localName=" + localName + ",value=" + value + "]");
/* 323 */     if ("service-interface".equals(localName))
/*     */     {
/* 325 */       siMapping.setServiceInterface(value);
/*     */     }
/* 327 */     else if ("wsdl-service-name".equals(localName))
/*     */     {
/* 329 */       siMapping.setWsdlServiceName(navigator.resolveQName(value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(ServiceEndpointInterfaceMapping seiMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 338 */     log.trace("newChild: " + localName);
/* 339 */     if ("service-endpoint-method-mapping".equals(localName))
/*     */     {
/* 341 */       return new ServiceEndpointMethodMapping(seiMapping);
/*     */     }
/* 343 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(ServiceEndpointInterfaceMapping seiMapping, ServiceEndpointMethodMapping seiMethodMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 352 */     log.trace("addChild: [obj=" + seiMapping + ",child=" + seiMapping + "]");
/* 353 */     seiMapping.addServiceEndpointMethodMapping(seiMethodMapping);
/*     */   }
/*     */ 
/*     */   public void setValue(ServiceEndpointInterfaceMapping seiMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 361 */     log.trace("setValue: [obj=" + seiMapping + ",localName=" + localName + ",value=" + value + "]");
/* 362 */     if ("service-endpoint-interface".equals(localName))
/*     */     {
/* 364 */       seiMapping.setServiceEndpointInterface(value);
/*     */     }
/* 366 */     else if ("wsdl-port-type".equals(localName))
/*     */     {
/* 368 */       seiMapping.setWsdlPortType(navigator.resolveQName(value));
/*     */     }
/* 370 */     else if ("wsdl-binding".equals(localName))
/*     */     {
/* 372 */       seiMapping.setWsdlBinding(navigator.resolveQName(value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(VariableMapping variableMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 381 */     log.trace("setValue: [obj=" + variableMapping + ",localName=" + localName + ",value=" + value + "]");
/* 382 */     if ("java-variable-name".equals(localName))
/*     */     {
/* 384 */       variableMapping.setJavaVariableName(value);
/*     */     }
/* 386 */     else if ("data-member".equals(localName))
/*     */     {
/* 388 */       variableMapping.setDataMember(true);
/*     */     }
/* 390 */     else if ("xml-attribute-name".equals(localName))
/*     */     {
/* 392 */       variableMapping.setXmlAttributeName(value);
/*     */     }
/* 394 */     else if ("xml-element-name".equals(localName))
/*     */     {
/* 396 */       variableMapping.setXmlElementName(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(VariableMapping variableMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 405 */     log.trace("newChild: " + localName);
/* 406 */     if ("data-member".equals(localName))
/*     */     {
/* 408 */       variableMapping.setDataMember(true);
/*     */     }
/* 410 */     else if ("xml-wildcard".equals(localName))
/*     */     {
/* 412 */       variableMapping.setXmlWildcard(true);
/*     */     }
/* 414 */     return null;
/*     */   }
/*     */ 
/*     */   public void setValue(PortMapping portMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 422 */     log.trace("setValue: [obj=" + portMapping + ",localName=" + localName + ",value=" + value + "]");
/* 423 */     if ("port-name".equals(localName))
/*     */     {
/* 425 */       portMapping.setPortName(value);
/*     */     }
/* 427 */     else if ("java-port-name".equals(localName))
/*     */     {
/* 429 */       portMapping.setJavaPortName(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(ServiceEndpointMethodMapping methodMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 438 */     log.trace("newChild: " + localName);
/* 439 */     if ("method-param-parts-mapping".equals(localName))
/*     */     {
/* 441 */       return new MethodParamPartsMapping(methodMapping);
/*     */     }
/* 443 */     if ("wsdl-return-value-mapping".equals(localName))
/*     */     {
/* 445 */       return new WsdlReturnValueMapping(methodMapping);
/*     */     }
/* 447 */     if ("wrapped-element".equals(localName))
/*     */     {
/* 449 */       methodMapping.setWrappedElement(true);
/*     */     }
/* 451 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(ServiceEndpointMethodMapping methodMapping, MethodParamPartsMapping partsMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 460 */     log.trace("addChild: [obj=" + methodMapping + ",child=" + partsMapping + "]");
/* 461 */     methodMapping.addMethodParamPartsMapping(partsMapping);
/*     */   }
/*     */ 
/*     */   public void addChild(ServiceEndpointMethodMapping methodMapping, WsdlReturnValueMapping returnValueMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 470 */     log.trace("addChild: [obj=" + methodMapping + ",child=" + returnValueMapping + "]");
/* 471 */     methodMapping.setWsdlReturnValueMapping(returnValueMapping);
/*     */   }
/*     */ 
/*     */   public void setValue(ServiceEndpointMethodMapping methodMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 479 */     log.trace("setValue: [obj=" + methodMapping + ",localName=" + localName + ",value=" + value + "]");
/* 480 */     if ("java-method-name".equals(localName))
/*     */     {
/* 482 */       methodMapping.setJavaMethodName(value);
/*     */     }
/* 484 */     else if ("wsdl-operation".equals(localName))
/*     */     {
/* 486 */       methodMapping.setWsdlOperation(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(MethodParamPartsMapping partsMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 495 */     log.trace("newChild: " + localName);
/* 496 */     if ("wsdl-message-mapping".equals(localName))
/*     */     {
/* 498 */       return new WsdlMessageMapping(partsMapping);
/*     */     }
/* 500 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(MethodParamPartsMapping partsMapping, WsdlMessageMapping msgMapping, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 508 */     log.trace("addChild: [obj=" + partsMapping + ",child=" + msgMapping + "]");
/* 509 */     partsMapping.setWsdlMessageMapping(msgMapping);
/*     */   }
/*     */ 
/*     */   public void setValue(MethodParamPartsMapping partsMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 517 */     log.trace("setValue: [obj=" + partsMapping + ",localName=" + localName + ",value=" + value + "]");
/* 518 */     if ("param-position".equals(localName))
/*     */     {
/* 520 */       partsMapping.setParamPosition(new Integer(value).intValue());
/*     */     }
/* 522 */     else if ("param-type".equals(localName))
/*     */     {
/* 524 */       partsMapping.setParamType(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(WsdlReturnValueMapping retValueMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 533 */     log.trace("setValue: [obj=" + retValueMapping + ",localName=" + localName + ",value=" + value + "]");
/* 534 */     if ("method-return-value".equals(localName))
/*     */     {
/* 536 */       retValueMapping.setMethodReturnValue(value);
/*     */     }
/* 538 */     else if ("wsdl-message".equals(localName))
/*     */     {
/* 540 */       retValueMapping.setWsdlMessage(navigator.resolveQName(value));
/*     */     }
/* 542 */     else if ("wsdl-message-part-name".equals(localName))
/*     */     {
/* 544 */       retValueMapping.setWsdlMessagePartName(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(WsdlMessageMapping msgMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 553 */     log.trace("setValue: [obj=" + msgMapping + ",localName=" + localName + ",value=" + value + "]");
/* 554 */     if ("wsdl-message".equals(localName))
/*     */     {
/* 556 */       msgMapping.setWsdlMessage(navigator.resolveQName(value));
/*     */     }
/* 558 */     else if ("wsdl-message-part-name".equals(localName))
/*     */     {
/* 560 */       msgMapping.setWsdlMessagePartName(value);
/*     */     }
/* 562 */     else if ("parameter-mode".equals(localName))
/*     */     {
/* 564 */       msgMapping.setParameterMode(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(WsdlMessageMapping msgMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 573 */     log.trace("newChild: " + localName);
/* 574 */     if ("soap-header".equals(localName))
/*     */     {
/* 576 */       msgMapping.setSoapHeader(true);
/*     */     }
/* 578 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory
 * JD-Core Version:    0.6.0
 */