/*    */ package org.jboss.ws.metadata.config.jaxws;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.ws.metadata.config.CommonConfig;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.HandlerMetaData;
/*    */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*    */ 
/*    */ public abstract class CommonConfigJAXWS extends CommonConfig
/*    */ {
/*    */   private HandlerChainsConfigJAXWS preHandlerChains;
/*    */   private HandlerChainsConfigJAXWS postHandlerChains;
/*    */ 
/*    */   public HandlerChainsConfigJAXWS getPostHandlerChains()
/*    */   {
/* 50 */     return this.postHandlerChains;
/*    */   }
/*    */ 
/*    */   public void setPostHandlerChains(HandlerChainsConfigJAXWS postHandlerChain)
/*    */   {
/* 55 */     this.postHandlerChains = postHandlerChain;
/*    */   }
/*    */ 
/*    */   public HandlerChainsConfigJAXWS getPreHandlerChains()
/*    */   {
/* 60 */     return this.preHandlerChains;
/*    */   }
/*    */ 
/*    */   public void setPreHandlerChains(HandlerChainsConfigJAXWS preHandlerChains)
/*    */   {
/* 65 */     this.preHandlerChains = preHandlerChains;
/*    */   }
/*    */ 
/*    */   public List<HandlerMetaData> getHandlers(EndpointMetaData epMetaData, UnifiedHandlerMetaData.HandlerType type)
/*    */   {
/* 70 */     List handlers = new ArrayList();
/*    */     HandlerChainsConfigJAXWS handlerChains;
/* 73 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
/* 74 */       handlerChains = getPreHandlerChains();
/*    */     }
/*    */     else
/*    */     {
/*    */       HandlerChainsConfigJAXWS handlerChains;
/* 75 */       if (type == UnifiedHandlerMetaData.HandlerType.POST)
/* 76 */         handlerChains = getPostHandlerChains();
/* 77 */       else throw new IllegalArgumentException("Invalid handler type: " + type);
/*    */     }
/*    */     HandlerChainsConfigJAXWS handlerChains;
/* 79 */     if (handlerChains != null)
/*    */     {
/* 81 */       for (UnifiedHandlerChainMetaData handlerChain : handlerChains.getHandlerChains())
/*    */       {
/* 83 */         for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers())
/*    */         {
/* 85 */           HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, type);
/* 86 */           hmd.setEndpointMetaData(epMetaData);
/* 87 */           handlers.add(hmd);
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 92 */     return handlers;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.config.jaxws.CommonConfigJAXWS
 * JD-Core Version:    0.6.0
 */