/*    */ package org.jboss.ws.metadata.config.jaxrpc;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.ws.metadata.config.CommonConfig;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.HandlerMetaData;
/*    */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*    */ 
/*    */ public abstract class CommonConfigJAXRPC extends CommonConfig
/*    */ {
/*    */   private UnifiedHandlerChainMetaData preHandlerChain;
/*    */   private UnifiedHandlerChainMetaData postHandlerChain;
/*    */ 
/*    */   public UnifiedHandlerChainMetaData getPostHandlerChain()
/*    */   {
/* 51 */     return this.postHandlerChain;
/*    */   }
/*    */ 
/*    */   public void setPostHandlerChain(UnifiedHandlerChainMetaData postHandlerChain)
/*    */   {
/* 56 */     this.postHandlerChain = postHandlerChain;
/*    */   }
/*    */ 
/*    */   public UnifiedHandlerChainMetaData getPreHandlerChain()
/*    */   {
/* 61 */     return this.preHandlerChain;
/*    */   }
/*    */ 
/*    */   public void setPreHandlerChain(UnifiedHandlerChainMetaData preHandlerChain)
/*    */   {
/* 66 */     this.preHandlerChain = preHandlerChain;
/*    */   }
/*    */ 
/*    */   public List<HandlerMetaData> getHandlers(EndpointMetaData epMetaData, UnifiedHandlerMetaData.HandlerType type)
/*    */   {
/* 72 */     List handlers = new ArrayList();
/*    */     UnifiedHandlerChainMetaData handlerChain;
/* 75 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
/* 76 */       handlerChain = getPreHandlerChain();
/*    */     }
/*    */     else
/*    */     {
/*    */       UnifiedHandlerChainMetaData handlerChain;
/* 77 */       if (type == UnifiedHandlerMetaData.HandlerType.POST)
/* 78 */         handlerChain = getPostHandlerChain();
/*    */       else
/* 80 */         throw new IllegalArgumentException("Invalid handler type: " + type);
/*    */     }
/*    */     UnifiedHandlerChainMetaData handlerChain;
/* 82 */     if (handlerChain != null)
/*    */     {
/* 84 */       for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers())
/*    */       {
/* 86 */         HandlerMetaDataJAXRPC hmd = HandlerMetaDataJAXRPC.newInstance(uhmd, type);
/* 87 */         handlers.add(hmd);
/*    */       }
/*    */     }
/*    */ 
/* 91 */     return handlers;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.config.jaxrpc.CommonConfigJAXRPC
 * JD-Core Version:    0.6.0
 */