/*     */ package org.jboss.ws.metadata.builder.jaxws;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import javax.jws.WebService;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.Provider;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import javax.xml.ws.ServiceMode;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.WebServiceProvider;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.builder.MetaDataBuilder;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ 
/*     */ public class JAXWSProviderMetaDataBuilder extends JAXWSServerMetaDataBuilder
/*     */ {
/*     */   public ServerEndpointMetaData buildProviderMetaData(ArchiveDeployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName)
/*     */     throws IOException
/*     */   {
/*  67 */     if (!JavaUtils.isAssignableFrom(Provider.class, sepClass)) {
/*  68 */       throw new WebServiceException("Endpoint implementation does not implement javax.xml.ws.Provider: " + sepClass.getName());
/*     */     }
/*     */ 
/*  72 */     WebServiceProvider anWebServiceProvider = (WebServiceProvider)sepClass.getAnnotation(WebServiceProvider.class);
/*  73 */     if (anWebServiceProvider == null) {
/*  74 */       throw new WebServiceException("Cannot obtain @WebServiceProvider annotation from: " + sepClass.getName());
/*     */     }
/*     */ 
/*  78 */     if (sepClass.isAnnotationPresent(WebService.class)) {
/*  79 */       throw new WebServiceException("Provider cannot carry @WebService annotation: " + sepClass.getName());
/*     */     }
/*  81 */     WSDLUtils wsdlUtils = WSDLUtils.getInstance();
/*     */ 
/*  83 */     String name = WSDLUtils.getJustClassName(sepClass);
/*     */ 
/*  85 */     String serviceName = anWebServiceProvider.serviceName();
/*  86 */     if (serviceName.length() == 0) {
/*  87 */       serviceName = name + "Service";
/*     */     }
/*  89 */     String targetNS = anWebServiceProvider.targetNamespace();
/*  90 */     if (targetNS.length() == 0) {
/*  91 */       targetNS = WSDLUtils.getTypeNamespace(sepClass);
/*     */     }
/*  93 */     String portName = anWebServiceProvider.portName();
/*  94 */     if (portName.length() == 0) {
/*  95 */       portName = name + "Port";
/*     */     }
/*  97 */     ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName(targetNS, serviceName));
/*  98 */     wsMetaData.addService(serviceMetaData);
/*     */ 
/* 101 */     QName portQName = new QName(targetNS, portName);
/* 102 */     QName portTypeQName = new QName(targetNS, name);
/*     */ 
/* 104 */     Endpoint ep = dep.getService().getEndpointByName(linkName);
/* 105 */     ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, ep, portQName, portTypeQName, EndpointMetaData.Type.JAXWS);
/* 106 */     sepMetaData.setLinkName(linkName);
/*     */ 
/* 108 */     sepMetaData.setStyle(Style.DOCUMENT);
/* 109 */     sepMetaData.setParameterStyle(SOAPBinding.ParameterStyle.BARE);
/*     */ 
/* 111 */     sepMetaData.setServiceEndpointImplName(sepClass.getName());
/* 112 */     sepMetaData.setServiceEndpointInterfaceName(sepClass.getName());
/*     */ 
/* 114 */     ServiceMode anServiceMode = (ServiceMode)sepClass.getAnnotation(ServiceMode.class);
/* 115 */     sepMetaData.setServiceMode(anServiceMode != null ? anServiceMode.value() : Service.Mode.PAYLOAD);
/*     */ 
/* 117 */     serviceMetaData.addEndpoint(sepMetaData);
/*     */ 
/* 120 */     processInvokeMethod(sepMetaData);
/*     */ 
/* 123 */     String wsdlLocation = anWebServiceProvider.wsdlLocation();
/* 124 */     if (wsdlLocation.length() > 0)
/*     */     {
/* 126 */       URL wsdlURL = dep.getMetaDataFileURL(wsdlLocation);
/* 127 */       serviceMetaData.setWsdlLocation(wsdlURL);
/*     */     }
/*     */ 
/* 131 */     processBindingType(sepMetaData, sepClass);
/*     */ 
/* 134 */     processHandlerChain(sepMetaData, sepClass);
/*     */ 
/* 137 */     processEndpointConfig(dep, sepMetaData, sepClass, linkName);
/*     */ 
/* 140 */     processWebContext(dep, sepClass, linkName, sepMetaData);
/*     */ 
/* 143 */     initEndpointAddress(dep, sepMetaData);
/*     */ 
/* 146 */     if (sepMetaData.getServiceMetaData().getWsdlLocation() != null) {
/* 147 */       MetaDataBuilder.replaceAddressLocation(sepMetaData);
/*     */     }
/*     */ 
/* 150 */     ObjectName sepID = MetaDataBuilder.createServiceEndpointID(dep, sepMetaData);
/* 151 */     sepMetaData.setServiceEndpointID(sepID);
/*     */ 
/* 153 */     return sepMetaData;
/*     */   }
/*     */ 
/*     */   private void processInvokeMethod(ServerEndpointMetaData epMetaData)
/*     */   {
/* 158 */     String javaName = "invoke";
/* 159 */     String targetNS = epMetaData.getPortName().getNamespaceURI();
/* 160 */     OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, javaName), javaName);
/* 161 */     epMetaData.addOperation(opMetaData);
/*     */ 
/* 164 */     Class paramType = Source.class;
/* 165 */     QName xmlName = SOAPContentElement.GENERIC_PARAM_NAME;
/* 166 */     QName xmlType = Constants.TYPE_LITERAL_ANYTYPE;
/* 167 */     ParameterMetaData pmd = new ParameterMetaData(opMetaData, xmlName, xmlType, paramType.getName());
/* 168 */     opMetaData.addParameter(pmd);
/*     */ 
/* 171 */     xmlName = SOAPContentElement.GENERIC_RETURN_NAME;
/* 172 */     ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, paramType.getName());
/* 173 */     opMetaData.setReturnParameter(retMetaData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSProviderMetaDataBuilder
 * JD-Core Version:    0.6.0
 */