/*    */ package org.jboss.ws.metadata.builder.jaxws;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*    */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*    */ import org.jboss.wsf.spi.deployment.Endpoint;
/*    */ import org.jboss.wsf.spi.deployment.Service;
/*    */ 
/*    */ public class JAXWSMetaDataBuilderJSE
/*    */ {
/* 42 */   private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderJSE.class);
/*    */ 
/*    */   public UnifiedMetaData buildMetaData(ArchiveDeployment dep)
/*    */   {
/* 48 */     this.log.debug("START buildMetaData: [name=" + dep.getCanonicalName() + "]");
/*    */     try
/*    */     {
/* 51 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(dep.getRootFile());
/* 52 */       wsMetaData.setDeploymentName(dep.getCanonicalName());
/* 53 */       ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
/* 54 */       if (null == runtimeClassLoader)
/* 55 */         throw new IllegalArgumentException("Runtime classloader cannot be null");
/* 56 */       wsMetaData.setClassLoader(runtimeClassLoader);
/*    */ 
/* 59 */       for (Endpoint ep : dep.getService().getEndpoints())
/*    */       {
/* 61 */         String shortName = ep.getShortName();
/* 62 */         Class beanClass = ep.getTargetBeanClass();
/* 63 */         JAXWSServerMetaDataBuilder.setupProviderOrWebService(dep, wsMetaData, beanClass, shortName);
/*    */       }
/*    */ 
/* 66 */       this.log.debug("END buildMetaData: " + wsMetaData);
/* 67 */       return wsMetaData;
/*    */     }
/*    */     catch (RuntimeException rte)
/*    */     {
/* 71 */       throw rte;
/*    */     }
/*    */     catch (Exception ex) {
/*    */     }
/* 75 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderJSE
 * JD-Core Version:    0.6.0
 */