/*     */ package org.jboss.ws.metadata.builder.jaxws;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import javax.jws.WebService;
/*     */ import javax.xml.ws.WebServiceProvider;
/*     */ import org.jboss.annotation.security.SecurityDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
/*     */ 
/*     */ public class JAXWSMetaDataBuilderEJB3
/*     */ {
/*  48 */   private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderEJB3.class);
/*     */   protected Class annotatedClass;
/*     */ 
/*     */   public UnifiedMetaData buildMetaData(ArchiveDeployment dep)
/*     */   {
/*  56 */     this.log.debug("START buildMetaData: [name=" + dep.getCanonicalName() + "]");
/*     */     try
/*     */     {
/*  59 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(dep.getRootFile());
/*  60 */       wsMetaData.setDeploymentName(dep.getCanonicalName());
/*     */ 
/*  62 */       ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
/*  63 */       if (null == runtimeClassLoader)
/*  64 */         throw new IllegalArgumentException("Runtime loader cannot be null");
/*  65 */       wsMetaData.setClassLoader(runtimeClassLoader);
/*     */ 
/*  68 */       EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
/*  69 */       Iterator it = apMetaData.getEnterpriseBeans();
/*  70 */       while (it.hasNext())
/*     */       {
/*  72 */         EJBMetaData beanMetaData = (EJBMetaData)it.next();
/*  73 */         String ejbClassName = beanMetaData.getEjbClass();
/*  74 */         Class beanClass = wsMetaData.getClassLoader().loadClass(ejbClassName);
/*  75 */         if ((beanClass.isAnnotationPresent(WebService.class)) || (beanClass.isAnnotationPresent(WebServiceProvider.class)))
/*     */         {
/*  77 */           String ejbLink = beanMetaData.getEjbName();
/*  78 */           JAXWSServerMetaDataBuilder.setupProviderOrWebService(dep, wsMetaData, beanClass, ejbLink);
/*     */ 
/*  81 */           if (beanClass.isAnnotationPresent(SecurityDomain.class))
/*     */           {
/*  83 */             SecurityDomain anSecurityDomain = (SecurityDomain)beanClass.getAnnotation(SecurityDomain.class);
/*  84 */             String lastDomain = wsMetaData.getSecurityDomain();
/*  85 */             String securityDomain = anSecurityDomain.value();
/*  86 */             if ((lastDomain != null) && (!lastDomain.equals(securityDomain))) {
/*  87 */               throw new IllegalStateException("Multiple security domains not supported: " + securityDomain);
/*     */             }
/*  89 */             wsMetaData.setSecurityDomain(securityDomain);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*  94 */       this.log.debug("END buildMetaData: " + wsMetaData);
/*  95 */       return wsMetaData;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/*  99 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 103 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderEJB3
 * JD-Core Version:    0.6.0
 */