/*      */ package org.jboss.ws.metadata.builder.jaxws;
/*      */ 
/*      */ import com.sun.xml.bind.api.JAXBRIContext;
/*      */ import com.sun.xml.bind.api.TypeReference;
/*      */ import java.io.File;
/*      */ import java.io.InputStream;
/*      */ import java.lang.annotation.Annotation;
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.ParameterizedType;
/*      */ import java.lang.reflect.Type;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.rmi.RemoteException;
/*      */ import java.security.ProtectionDomain;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.jws.HandlerChain;
/*      */ import javax.jws.Oneway;
/*      */ import javax.jws.WebMethod;
/*      */ import javax.jws.WebParam;
/*      */ import javax.jws.WebParam.Mode;
/*      */ import javax.jws.WebResult;
/*      */ import javax.jws.soap.SOAPBinding;
/*      */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*      */ import javax.jws.soap.SOAPBinding.Style;
/*      */ import javax.jws.soap.SOAPBinding.Use;
/*      */ import javax.jws.soap.SOAPMessageHandlers;
/*      */ import javax.xml.namespace.QName;
/*      */ import javax.xml.rpc.ParameterMode;
/*      */ import javax.xml.ws.BindingType;
/*      */ import javax.xml.ws.RequestWrapper;
/*      */ import javax.xml.ws.ResponseWrapper;
/*      */ import javax.xml.ws.WebFault;
/*      */ import javax.xml.ws.addressing.Action;
/*      */ import javax.xml.ws.addressing.AddressingProperties;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.ws.WSException;
/*      */ import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
/*      */ import org.jboss.ws.core.jaxws.JAXBContextFactory;
/*      */ import org.jboss.ws.core.jaxws.WrapperGenerator;
/*      */ import org.jboss.ws.core.soap.Style;
/*      */ import org.jboss.ws.core.soap.Use;
/*      */ import org.jboss.ws.core.utils.HolderUtils;
/*      */ import org.jboss.ws.core.utils.JBossWSEntityResolver;
/*      */ import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
/*      */ import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
/*      */ import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult;
/*      */ import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult.Type;
/*      */ import org.jboss.ws.extensions.xop.jaxws.ReflectiveAttachmentRefScanner;
/*      */ import org.jboss.ws.metadata.acessor.JAXBAccessor;
/*      */ import org.jboss.ws.metadata.builder.MetaDataBuilder;
/*      */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*      */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*      */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
/*      */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*      */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*      */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*      */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*      */ import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
/*      */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*      */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*      */ import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
/*      */ import org.jboss.wsf.common.JavaUtils;
/*      */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*      */ import org.jboss.wsf.spi.deployment.Endpoint;
/*      */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.HandlerChainsObjectFactory;
/*      */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*      */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
/*      */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*      */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*      */ import org.jboss.xb.binding.ObjectModelFactory;
/*      */ import org.jboss.xb.binding.Unmarshaller;
/*      */ import org.jboss.xb.binding.UnmarshallerFactory;
/*      */ 
/*      */ public class JAXWSMetaDataBuilder extends MetaDataBuilder
/*      */ {
/*  110 */   protected static final Logger log = Logger.getLogger(JAXWSWebServiceMetaDataBuilder.class);
/*  111 */   protected List<Class<?>> javaTypes = new ArrayList();
/*      */   protected JAXBRIContext jaxbCtx;
/*  113 */   protected List<TypeReference> typeRefs = new ArrayList();
/*      */   protected WrapperGenerator wrapperGenerator;
/*      */ 
/*      */   protected void processBindingType(EndpointMetaData epMetaData, Class<?> wsClass)
/*      */   {
/*  118 */     if (wsClass.isAnnotationPresent(BindingType.class))
/*      */     {
/*  120 */       log.debug("processBindingType on: " + wsClass.getName());
/*  121 */       BindingType anBindingType = (BindingType)wsClass.getAnnotation(BindingType.class);
/*  122 */       epMetaData.setBindingId(anBindingType.value());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void processSOAPBinding(EndpointMetaData epMetaData, Class<?> wsClass)
/*      */   {
/*  128 */     if (wsClass.isAnnotationPresent(SOAPBinding.class))
/*      */     {
/*  130 */       log.debug("processSOAPBinding on: " + wsClass.getName());
/*  131 */       SOAPBinding anSoapBinding = (SOAPBinding)wsClass.getAnnotation(SOAPBinding.class);
/*      */ 
/*  133 */       SOAPBinding.Style attrStyle = anSoapBinding.style();
/*  134 */       Style style = attrStyle == SOAPBinding.Style.RPC ? Style.RPC : Style.DOCUMENT;
/*  135 */       epMetaData.setStyle(style);
/*      */ 
/*  137 */       SOAPBinding.Use attrUse = anSoapBinding.use();
/*  138 */       if (attrUse == SOAPBinding.Use.ENCODED) {
/*  139 */         throw new WSException("SOAP encoding is not supported for JSR-181 deployments");
/*      */       }
/*  141 */       epMetaData.setEncodingStyle(Use.LITERAL);
/*      */ 
/*  143 */       SOAPBinding.ParameterStyle paramStyle = anSoapBinding.parameterStyle();
/*  144 */       epMetaData.setParameterStyle(paramStyle);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void processHandlerChain(EndpointMetaData epMetaData, Class<?> wsClass)
/*      */   {
/*  161 */     if (wsClass.isAnnotationPresent(SOAPMessageHandlers.class)) {
/*  162 */       throw new WSException("Cannot combine @HandlerChain with @SOAPMessageHandlers");
/*      */     }
/*  164 */     if (wsClass.isAnnotationPresent(HandlerChain.class))
/*      */     {
/*  166 */       HandlerChain anHandlerChain = (HandlerChain)wsClass.getAnnotation(HandlerChain.class);
/*  167 */       String filename = anHandlerChain.file();
/*      */ 
/*  170 */       UnifiedHandlerChainsMetaData handlerChainsMetaData = getHandlerChainsMetaData(wsClass, filename);
/*  171 */       for (UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData : handlerChainsMetaData.getHandlerChains())
/*      */       {
/*  173 */         for (UnifiedHandlerMetaData uhmd : UnifiedHandlerChainMetaData.getHandlers())
/*      */         {
/*  175 */           HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/*  176 */           epMetaData.addHandler(hmd);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public static UnifiedHandlerChainsMetaData getHandlerChainsMetaData(Class<?> wsClass, String filename)
/*      */   {
/*  184 */     URL fileURL = null;
/*  185 */     log.debug("processHandlerChain [" + filename + "] on: " + wsClass.getName());
/*      */     try
/*      */     {
/*  190 */       fileURL = new URL(filename);
/*      */     }
/*      */     catch (MalformedURLException ex)
/*      */     {
/*      */     }
/*      */ 
/*  198 */     if (fileURL == null)
/*      */     {
/*      */       try
/*      */       {
/*  202 */         File file = new File(filename);
/*  203 */         if (file.exists()) {
/*  204 */           fileURL = file.toURL();
/*      */         }
/*      */       }
/*      */       catch (MalformedURLException e)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  213 */     if (fileURL == null)
/*      */     {
/*  215 */       log.debug(wsClass.getProtectionDomain().getCodeSource());
/*  216 */       log.debug(wsClass.getClassLoader());
/*  217 */       fileURL = wsClass.getClassLoader().getResource(filename);
/*      */     }
/*      */ 
/*  221 */     if (fileURL == null)
/*      */     {
/*  223 */       String filepath = filename;
/*  224 */       String packagePath = wsClass.getPackage().getName().replace('.', '/');
/*  225 */       String resourcePath = packagePath + "/" + filepath;
/*  226 */       while (filepath.startsWith("../"))
/*      */       {
/*  228 */         packagePath = packagePath.substring(0, packagePath.lastIndexOf("/"));
/*  229 */         filepath = filepath.substring(3);
/*  230 */         resourcePath = packagePath + "/" + filepath;
/*      */       }
/*  232 */       fileURL = wsClass.getClassLoader().getResource(resourcePath);
/*      */     }
/*      */ 
/*  235 */     if (fileURL == null) {
/*  236 */       throw new WSException("Cannot resolve handler file '" + filename + "' on " + wsClass.getName());
/*      */     }
/*  238 */     log.debug("Loading handler chain: " + fileURL);
/*      */ 
/*  240 */     UnifiedHandlerChainsMetaData handlerChainsMetaData = null;
/*      */     try
/*      */     {
/*  243 */       InputStream is = fileURL.openStream();
/*      */       try
/*      */       {
/*  246 */         Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  247 */         unmarshaller.setValidation(true);
/*  248 */         unmarshaller.setSchemaValidation(true);
/*  249 */         unmarshaller.setEntityResolver(new JBossWSEntityResolver());
/*  250 */         ObjectModelFactory factory = new HandlerChainsObjectFactory();
/*  251 */         handlerChainsMetaData = (UnifiedHandlerChainsMetaData)unmarshaller.unmarshal(is, factory, null);
/*      */       }
/*      */       finally
/*      */       {
/*  255 */         is.close();
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (RuntimeException rte)
/*      */     {
/*  261 */       throw rte;
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/*  265 */       throw new WSException("Cannot process handler chain: " + filename, ex);
/*      */     }
/*      */ 
/*  268 */     return handlerChainsMetaData;
/*      */   }
/*      */ 
/*      */   private void addFault(OperationMetaData opMetaData, Class<?> exception)
/*      */   {
/*  273 */     if (opMetaData.isOneWay()) {
/*  274 */       throw new IllegalStateException("JSR-181 4.3.1 - A JSR-181 processor is REQUIRED to report an error if an operation marked @Oneway has a return value, declares any checked exceptions or has any INOUT or OUT parameters.");
/*      */     }
/*      */ 
/*  277 */     WebFault anWebFault = (WebFault)exception.getAnnotation(WebFault.class);
/*      */ 
/*  280 */     QName xmlType = new QName(opMetaData.getQName().getNamespaceURI(), exception.getSimpleName());
/*      */ 
/*  282 */     String name = xmlType.getLocalPart();
/*  283 */     String namespace = xmlType.getNamespaceURI();
/*      */ 
/*  285 */     String faultBean = null;
/*  286 */     Class faultBeanClass = getFaultInfo(exception);
/*  287 */     if (faultBeanClass != null) {
/*  288 */       faultBean = faultBeanClass.getName();
/*      */     }
/*      */ 
/*  294 */     if (anWebFault != null)
/*      */     {
/*  296 */       if (anWebFault.name().length() > 0) {
/*  297 */         name = anWebFault.name();
/*      */       }
/*  299 */       if (anWebFault.targetNamespace().length() > 0) {
/*  300 */         namespace = anWebFault.targetNamespace();
/*      */       }
/*  302 */       if (anWebFault.faultBean().length() > 0) {
/*  303 */         faultBean = anWebFault.faultBean();
/*      */       }
/*      */     }
/*  306 */     if (faultBean == null) {
/*  307 */       faultBean = JavaUtils.getPackageName(opMetaData.getEndpointMetaData().getServiceEndpointInterface()) + ".jaxws." + exception.getSimpleName() + "Bean";
/*      */     }
/*  309 */     QName xmlName = new QName(namespace, name);
/*      */ 
/*  311 */     FaultMetaData fmd = new FaultMetaData(opMetaData, xmlName, xmlType, exception.getName());
/*  312 */     fmd.setFaultBeanName(faultBean);
/*      */ 
/*  314 */     if (fmd.loadFaultBean() == null) {
/*  315 */       this.wrapperGenerator.generate(fmd);
/*      */     }
/*  317 */     this.javaTypes.add(fmd.getFaultBean());
/*  318 */     this.typeRefs.add(new TypeReference(fmd.getXmlName(), fmd.getFaultBean(), new Annotation[0]));
/*      */ 
/*  320 */     opMetaData.addFault(fmd);
/*      */   }
/*      */ 
/*      */   private String convertToVariable(String localName)
/*      */   {
/*  325 */     return JAXBRIContext.mangleNameToVariableName(localName.intern());
/*      */   }
/*      */ 
/*      */   private String[] convertTypeArguments(Class<?> rawType, Type type)
/*      */   {
/*  330 */     if ((!Collection.class.isAssignableFrom(rawType)) && (!Map.class.isAssignableFrom(rawType))) {
/*  331 */       return null;
/*      */     }
/*  333 */     if (!(type instanceof ParameterizedType)) {
/*  334 */       return null;
/*      */     }
/*  336 */     ParameterizedType paramType = (ParameterizedType)type;
/*  337 */     Type[] arguments = paramType.getActualTypeArguments();
/*  338 */     String[] ret = new String[arguments.length];
/*  339 */     for (int i = 0; i < arguments.length; i++) {
/*  340 */       ret[i] = JavaUtils.erasure(arguments[i]).getName();
/*      */     }
/*  342 */     return ret;
/*      */   }
/*      */ 
/*      */   private ParameterMetaData createRequestWrapper(OperationMetaData operation, Method method)
/*      */   {
/*  347 */     String requestWrapperType = null;
/*  348 */     QName xmlName = operation.getQName();
/*  349 */     QName xmlType = xmlName;
/*  350 */     if (method.isAnnotationPresent(RequestWrapper.class))
/*      */     {
/*  352 */       RequestWrapper anReqWrapper = (RequestWrapper)method.getAnnotation(RequestWrapper.class);
/*      */ 
/*  354 */       String localName = anReqWrapper.localName().length() > 0 ? anReqWrapper.localName() : xmlName.getLocalPart();
/*  355 */       String targetNamespace = anReqWrapper.targetNamespace().length() > 0 ? anReqWrapper.targetNamespace() : xmlName.getNamespaceURI();
/*  356 */       xmlName = new QName(targetNamespace, localName);
/*      */ 
/*  358 */       if (anReqWrapper.className().length() > 0) {
/*  359 */         requestWrapperType = anReqWrapper.className();
/*      */       }
/*      */     }
/*      */ 
/*  363 */     if (requestWrapperType == null)
/*      */     {
/*  365 */       String packageName = JavaUtils.getPackageName(method.getDeclaringClass());
/*  366 */       requestWrapperType = packageName + ".jaxws." + JavaUtils.capitalize(method.getName());
/*      */     }
/*      */ 
/*  370 */     ParameterMetaData wrapperParameter = new ParameterMetaData(operation, xmlName, xmlType, requestWrapperType);
/*  371 */     wrapperParameter.setAccessorFactoryCreator(JAXBAccessor.FACTORY_CREATOR);
/*  372 */     operation.addParameter(wrapperParameter);
/*      */ 
/*  374 */     return wrapperParameter;
/*      */   }
/*      */ 
/*      */   private ParameterMetaData createResponseWrapper(OperationMetaData operation, Method method)
/*      */   {
/*  379 */     QName operationQName = operation.getQName();
/*  380 */     QName xmlName = new QName(operationQName.getNamespaceURI(), operationQName.getLocalPart() + "Response");
/*  381 */     QName xmlType = xmlName;
/*      */ 
/*  383 */     String responseWrapperType = null;
/*  384 */     if (method.isAnnotationPresent(ResponseWrapper.class))
/*      */     {
/*  386 */       ResponseWrapper anResWrapper = (ResponseWrapper)method.getAnnotation(ResponseWrapper.class);
/*      */ 
/*  388 */       String localName = anResWrapper.localName().length() > 0 ? anResWrapper.localName() : xmlName.getLocalPart();
/*  389 */       String targetNamespace = anResWrapper.targetNamespace().length() > 0 ? anResWrapper.targetNamespace() : xmlName.getNamespaceURI();
/*  390 */       xmlName = new QName(targetNamespace, localName);
/*      */ 
/*  392 */       if (anResWrapper.className().length() > 0) {
/*  393 */         responseWrapperType = anResWrapper.className();
/*      */       }
/*      */     }
/*  396 */     if (responseWrapperType == null)
/*      */     {
/*  398 */       String packageName = JavaUtils.getPackageName(method.getDeclaringClass());
/*  399 */       responseWrapperType = packageName + ".jaxws." + JavaUtils.capitalize(method.getName()) + "Response";
/*      */     }
/*      */ 
/*  402 */     ParameterMetaData retMetaData = new ParameterMetaData(operation, xmlName, xmlType, responseWrapperType);
/*  403 */     retMetaData.setAccessorFactoryCreator(JAXBAccessor.FACTORY_CREATOR);
/*  404 */     operation.setReturnParameter(retMetaData);
/*      */ 
/*  406 */     return retMetaData;
/*      */   }
/*      */ 
/*      */   private Class<?> getFaultInfo(Class<?> exception)
/*      */   {
/*      */     try
/*      */     {
/*  413 */       Method method = exception.getMethod("getFaultInfo", new Class[0]);
/*  414 */       Class returnType = method.getReturnType();
/*  415 */       if (returnType == Void.TYPE) {
/*  416 */         return null;
/*      */       }
/*  418 */       return returnType;
/*      */     }
/*      */     catch (SecurityException e)
/*      */     {
/*  422 */       throw new WSException("Unexpected security exception: " + e.getMessage(), e);
/*      */     }
/*      */     catch (NoSuchMethodException e) {
/*      */     }
/*  426 */     return null;
/*      */   }
/*      */ 
/*      */   private ParameterMode getParameterMode(WebParam anWebParam, Class<?> javaType)
/*      */   {
/*  432 */     if (anWebParam != null)
/*      */     {
/*  434 */       if (anWebParam.mode() == WebParam.Mode.INOUT)
/*  435 */         return ParameterMode.INOUT;
/*  436 */       if (anWebParam.mode() == WebParam.Mode.OUT) {
/*  437 */         return ParameterMode.OUT;
/*      */       }
/*      */     }
/*  440 */     return HolderUtils.isHolderType(javaType) ? ParameterMode.INOUT : ParameterMode.IN;
/*      */   }
/*      */ 
/*      */   private WebParam getWebParamAnnotation(Method method, int pos)
/*      */   {
/*  445 */     for (Annotation annotation : method.getParameterAnnotations()[pos]) {
/*  446 */       if ((annotation instanceof WebParam))
/*  447 */         return (WebParam)annotation;
/*      */     }
/*  449 */     return null;
/*      */   }
/*      */ 
/*      */   private QName getWebParamName(OperationMetaData opMetaData, int index, WebParam webParam)
/*      */   {
/*  454 */     String namespace = null;
/*  455 */     String name = null;
/*  456 */     boolean header = false;
/*      */ 
/*  458 */     if (webParam != null)
/*      */     {
/*  460 */       if (webParam.targetNamespace().length() > 0) {
/*  461 */         namespace = webParam.targetNamespace();
/*      */       }
/*      */ 
/*  464 */       if ((webParam.partName().length() > 0) && (opMetaData.isRPCLiteral()))
/*  465 */         name = webParam.partName();
/*  466 */       else if (webParam.name().length() > 0) {
/*  467 */         name = webParam.name();
/*      */       }
/*  469 */       header = webParam.header();
/*      */     }
/*      */ 
/*  473 */     if ((namespace == null) && ((opMetaData.isDocumentBare()) || (header))) {
/*  474 */       namespace = opMetaData.getQName().getNamespaceURI();
/*      */     }
/*  477 */     else if ((opMetaData.isRPCLiteral()) && (!header)) {
/*  478 */       namespace = null;
/*      */     }
/*      */ 
/*  481 */     if (name == null) {
/*  482 */       name = "arg" + index;
/*      */     }
/*  484 */     return namespace != null ? new QName(namespace, name) : new QName(name);
/*      */   }
/*      */ 
/*      */   private QName getWebResultName(OperationMetaData opMetaData, WebResult anWebResult)
/*      */   {
/*  489 */     String name = null;
/*  490 */     String namespace = null;
/*  491 */     boolean header = false;
/*      */ 
/*  493 */     if (anWebResult != null)
/*      */     {
/*  495 */       if (anWebResult.targetNamespace().length() > 0) {
/*  496 */         namespace = anWebResult.targetNamespace();
/*      */       }
/*      */ 
/*  499 */       if ((anWebResult.partName().length() > 0) && (opMetaData.isRPCLiteral()))
/*  500 */         name = anWebResult.partName();
/*  501 */       else if (anWebResult.name().length() > 0) {
/*  502 */         name = anWebResult.name();
/*      */       }
/*  504 */       header = anWebResult.header();
/*      */     }
/*      */ 
/*  508 */     if ((namespace == null) && ((opMetaData.isDocumentBare()) || (header))) {
/*  509 */       namespace = opMetaData.getQName().getNamespaceURI();
/*      */     }
/*  512 */     else if ((opMetaData.isRPCLiteral()) && (!header)) {
/*  513 */       namespace = null;
/*      */     }
/*      */ 
/*  516 */     if (name == null) {
/*  517 */       name = (opMetaData.isDocumentBare()) && (!header) ? opMetaData.getResponseName().getLocalPart() : "return";
/*      */     }
/*  519 */     return namespace != null ? new QName(namespace, name) : new QName(name);
/*      */   }
/*      */ 
/*      */   private void processMetaExtensions(Method method, EndpointMetaData epMetaData, OperationMetaData opMetaData)
/*      */   {
/*  527 */     AddressingProperties ADDR = new AddressingPropertiesImpl();
/*  528 */     AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
/*      */ 
/*  530 */     Action anAction = (Action)method.getAnnotation(Action.class);
/*  531 */     if (anAction != null)
/*      */     {
/*  533 */       addrExt.setInboundAction(anAction.input());
/*  534 */       addrExt.setOutboundAction(anAction.output());
/*      */     }
/*      */     else
/*      */     {
/*  540 */       String tns = epMetaData.getPortName().getNamespaceURI();
/*  541 */       String portTypeName = epMetaData.getPortName().getLocalPart();
/*  542 */       addrExt.setInboundAction(tns + "/" + portTypeName + "/IN");
/*      */ 
/*  544 */       if (!opMetaData.isOneWay()) {
/*  545 */         addrExt.setOutboundAction(tns + "/" + portTypeName + "/OUT");
/*      */       }
/*      */     }
/*  548 */     opMetaData.addExtension(addrExt);
/*      */   }
/*      */ 
/*      */   private void processWebMethod(EndpointMetaData epMetaData, Method method)
/*      */   {
/*  553 */     String javaName = method.getName();
/*      */ 
/*  556 */     if (method.getName().endsWith("Async")) {
/*  557 */       return;
/*      */     }
/*      */ 
/*  560 */     String soapAction = "";
/*  561 */     String operationName = method.getName();
/*      */ 
/*  564 */     if (method.isAnnotationPresent(WebMethod.class))
/*      */     {
/*  566 */       WebMethod anWebMethod = (WebMethod)method.getAnnotation(WebMethod.class);
/*  567 */       soapAction = anWebMethod.action();
/*  568 */       if (anWebMethod.operationName().length() > 0)
/*      */       {
/*  570 */         operationName = anWebMethod.operationName();
/*      */       }
/*      */     }
/*      */ 
/*  574 */     String targetNS = epMetaData.getPortTypeName().getNamespaceURI();
/*  575 */     OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, operationName), javaName);
/*  576 */     opMetaData.setOneWay(method.isAnnotationPresent(Oneway.class));
/*  577 */     opMetaData.setSOAPAction(soapAction);
/*      */ 
/*  579 */     if (method.isAnnotationPresent(SOAPBinding.class))
/*      */     {
/*  581 */       SOAPBinding anBinding = (SOAPBinding)method.getAnnotation(SOAPBinding.class);
/*  582 */       if ((anBinding.style() != SOAPBinding.Style.DOCUMENT) || (epMetaData.getStyle() != Style.DOCUMENT))
/*  583 */         throw new IllegalArgumentException("@SOAPBinding must be specified using DOCUMENT style when placed on a method");
/*  584 */       opMetaData.setParameterStyle(anBinding.parameterStyle());
/*      */     }
/*      */ 
/*  587 */     epMetaData.addOperation(opMetaData);
/*      */ 
/*  591 */     List scanResult = ReflectiveAttachmentRefScanner.scanMethod(method);
/*      */ 
/*  593 */     Class[] parameterTypes = method.getParameterTypes();
/*  594 */     Type[] genericTypes = method.getGenericParameterTypes();
/*  595 */     Annotation[][] parameterAnnotations = method.getParameterAnnotations();
/*  596 */     ParameterMetaData wrapperParameter = null; ParameterMetaData wrapperOutputParameter = null;
/*  597 */     List wrappedParameters = null; List wrappedOutputParameters = null;
/*      */ 
/*  600 */     if ((method.isAnnotationPresent(RequestWrapper.class)) || (method.isAnnotationPresent(ResponseWrapper.class)))
/*      */     {
/*  602 */       epMetaData.setParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
/*      */     }
/*      */ 
/*  605 */     if (opMetaData.isDocumentWrapped())
/*      */     {
/*  607 */       wrapperParameter = createRequestWrapper(opMetaData, method);
/*  608 */       wrappedParameters = new ArrayList(parameterTypes.length);
/*  609 */       wrapperParameter.setWrappedParameters(wrappedParameters);
/*      */ 
/*  611 */       if (!opMetaData.isOneWay())
/*      */       {
/*  613 */         wrapperOutputParameter = createResponseWrapper(opMetaData, method);
/*  614 */         wrappedOutputParameters = new ArrayList(parameterTypes.length + 1);
/*  615 */         wrapperOutputParameter.setWrappedParameters(wrappedOutputParameters);
/*      */       }
/*      */     }
/*      */ 
/*  619 */     for (int i = 0; i < parameterTypes.length; i++)
/*      */     {
/*  621 */       Class javaType = parameterTypes[i];
/*  622 */       Type genericType = genericTypes[i];
/*  623 */       String javaTypeName = javaType.getName();
/*  624 */       WebParam anWebParam = getWebParamAnnotation(method, i);
/*  625 */       boolean isHeader = (anWebParam != null) && (anWebParam.header());
/*  626 */       boolean isWrapped = (opMetaData.isDocumentWrapped()) && (!isHeader);
/*  627 */       ParameterMode mode = getParameterMode(anWebParam, javaType);
/*      */ 
/*  630 */       if ((opMetaData.isOneWay()) && (mode != ParameterMode.IN)) {
/*  631 */         throw new IllegalArgumentException("A one-way operation can not have output parameters [method = " + method.getName() + ", parameter = " + i + "]");
/*      */       }
/*  633 */       if (HolderUtils.isHolderType(javaType))
/*      */       {
/*  635 */         genericType = HolderUtils.getGenericValueType(genericType);
/*  636 */         javaType = JavaUtils.erasure(genericType);
/*  637 */         javaTypeName = javaType.getName();
/*      */       }
/*      */ 
/*  640 */       if (isWrapped)
/*      */       {
/*  642 */         QName wrappedElementName = getWebParamName(opMetaData, i, anWebParam);
/*  643 */         String variable = convertToVariable(wrappedElementName.getLocalPart());
/*      */ 
/*  645 */         WrappedParameter wrappedParameter = new WrappedParameter(wrappedElementName, javaTypeName, variable, i);
/*  646 */         wrappedParameter.setTypeArguments(convertTypeArguments(javaType, genericType));
/*      */ 
/*  648 */         if (mode != ParameterMode.OUT) {
/*  649 */           wrappedParameters.add(wrappedParameter);
/*      */         }
/*  651 */         if (mode != ParameterMode.IN)
/*      */         {
/*  653 */           wrappedParameter.setHolder(true);
/*      */ 
/*  656 */           if (mode == ParameterMode.INOUT)
/*  657 */             wrappedParameter = new WrappedParameter(wrappedParameter);
/*  658 */           wrappedOutputParameters.add(wrappedParameter);
/*      */         }
/*      */ 
/*  661 */         processAttachmentAnnotationsWrapped(scanResult, i, wrappedParameter);
/*      */       }
/*      */       else
/*      */       {
/*  665 */         QName xmlName = getWebParamName(opMetaData, i, anWebParam);
/*      */ 
/*  667 */         ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, javaTypeName);
/*  668 */         paramMetaData.setInHeader(isHeader);
/*  669 */         paramMetaData.setIndex(i);
/*  670 */         paramMetaData.setMode(mode);
/*      */ 
/*  684 */         if ((anWebParam != null) && (!opMetaData.isDocumentWrapped()) && (anWebParam.partName().length() > 0)) {
/*  685 */           paramMetaData.setPartName(anWebParam.partName());
/*      */         }
/*  687 */         opMetaData.addParameter(paramMetaData);
/*  688 */         this.javaTypes.add(javaType);
/*  689 */         this.typeRefs.add(new TypeReference(xmlName, genericType, parameterAnnotations[i]));
/*      */ 
/*  691 */         processAttachmentAnnotations(scanResult, i, paramMetaData);
/*  692 */         processMIMEBinding(epMetaData, opMetaData, paramMetaData);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  697 */     Class returnType = method.getReturnType();
/*  698 */     Type genericReturnType = method.getGenericReturnType();
/*  699 */     String returnTypeName = returnType.getName();
/*  700 */     if (returnType != Void.TYPE)
/*      */     {
/*  702 */       if (opMetaData.isOneWay()) {
/*  703 */         throw new IllegalArgumentException("[JSR-181 2.5.1] The method '" + method.getName() + "' can not have a return value if it is marked OneWay");
/*      */       }
/*  705 */       WebResult anWebResult = (WebResult)method.getAnnotation(WebResult.class);
/*  706 */       boolean isHeader = (anWebResult != null) && (anWebResult.header());
/*  707 */       boolean isWrappedBody = (opMetaData.isDocumentWrapped()) && (!isHeader);
/*  708 */       QName xmlName = getWebResultName(opMetaData, anWebResult);
/*      */ 
/*  710 */       if (isWrappedBody)
/*      */       {
/*  712 */         WrappedParameter wrapped = new WrappedParameter(xmlName, returnTypeName, convertToVariable(xmlName.getLocalPart()), -1);
/*  713 */         wrapped.setTypeArguments(convertTypeArguments(returnType, genericReturnType));
/*      */ 
/*  716 */         wrappedOutputParameters.add(0, wrapped);
/*      */ 
/*  718 */         processAttachmentAnnotationsWrapped(scanResult, -1, wrapped);
/*      */       }
/*      */       else
/*      */       {
/*  722 */         ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, returnTypeName);
/*  723 */         retMetaData.setInHeader(isHeader);
/*  724 */         retMetaData.setIndex(-1);
/*  725 */         retMetaData.setMode(ParameterMode.OUT);
/*      */ 
/*  733 */         if (opMetaData.isDocumentWrapped())
/*      */         {
/*  735 */           opMetaData.addParameter(retMetaData);
/*      */         }
/*      */         else
/*      */         {
/*  742 */           if ((anWebResult != null) && (anWebResult.partName().length() > 0)) {
/*  743 */             retMetaData.setPartName(anWebResult.partName());
/*      */           }
/*  745 */           opMetaData.setReturnParameter(retMetaData);
/*      */         }
/*      */ 
/*  748 */         this.javaTypes.add(returnType);
/*  749 */         this.typeRefs.add(new TypeReference(xmlName, genericReturnType, method.getAnnotations()));
/*      */ 
/*  751 */         processAttachmentAnnotations(scanResult, -1, retMetaData);
/*  752 */         processMIMEBinding(epMetaData, opMetaData, retMetaData);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  757 */     if (opMetaData.isDocumentWrapped())
/*      */     {
/*  759 */       if (wrapperParameter.loadWrapperBean() == null) {
/*  760 */         this.wrapperGenerator.generate(wrapperParameter);
/*      */       }
/*  762 */       Class wrapperClass = wrapperParameter.getJavaType();
/*  763 */       this.javaTypes.add(wrapperClass);
/*      */ 
/*  766 */       this.typeRefs.add(new TypeReference(wrapperParameter.getXmlName(), wrapperClass, new Annotation[0]));
/*  767 */       if (!opMetaData.isOneWay())
/*      */       {
/*  769 */         if (wrapperOutputParameter.loadWrapperBean() == null) {
/*  770 */           this.wrapperGenerator.generate(wrapperOutputParameter);
/*      */         }
/*  772 */         wrapperClass = wrapperOutputParameter.getJavaType();
/*  773 */         this.javaTypes.add(wrapperClass);
/*      */ 
/*  776 */         this.typeRefs.add(new TypeReference(wrapperOutputParameter.getXmlName(), wrapperClass, new Annotation[0]));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  781 */     for (Class exClass : method.getExceptionTypes()) {
/*  782 */       if (!RemoteException.class.isAssignableFrom(exClass)) {
/*  783 */         addFault(opMetaData, exClass);
/*      */       }
/*      */     }
/*  786 */     processMetaExtensions(method, epMetaData, opMetaData);
/*      */   }
/*      */ 
/*      */   private void processAttachmentAnnotationsWrapped(List<AttachmentScanResult> scanResult, int i, WrappedParameter wrappedParameter)
/*      */   {
/*  797 */     AttachmentScanResult asr = ReflectiveAttachmentRefScanner.getResultByIndex(scanResult, i);
/*  798 */     if (asr != null)
/*      */     {
/*  800 */       if (AttachmentScanResult.Type.SWA_REF == asr.getType())
/*  801 */         wrappedParameter.setSwaRef(true);
/*  802 */       else wrappedParameter.setXOP(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processAttachmentAnnotations(List<AttachmentScanResult> scanResult, int i, ParameterMetaData parameter)
/*      */   {
/*  814 */     AttachmentScanResult asr = ReflectiveAttachmentRefScanner.getResultByIndex(scanResult, i);
/*  815 */     if (asr != null)
/*      */     {
/*  817 */       if (AttachmentScanResult.Type.SWA_REF == asr.getType())
/*  818 */         parameter.setSwaRef(true);
/*  819 */       else parameter.setXOP(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void processMIMEBinding(EndpointMetaData epMetaData, OperationMetaData opMetaData, ParameterMetaData paramMetaData)
/*      */   {
/*  826 */     WSDLDefinitions wsdlDef = epMetaData.getServiceMetaData().getWsdlDefinitions();
/*  827 */     if (wsdlDef != null)
/*      */     {
/*  829 */       for (WSDLBinding binding : wsdlDef.getBindings())
/*      */       {
/*  831 */         for (WSDLBindingOperation bindingOp : binding.getOperations())
/*      */         {
/*  834 */           WSDLBindingMessageReference[] inOrOutPut = (paramMetaData.getMode().equals(ParameterMode.IN)) || (paramMetaData.getMode().equals(ParameterMode.INOUT)) ? (WSDLBindingMessageReference[])bindingOp.getInputs() : (WSDLBindingMessageReference[])bindingOp.getOutputs();
/*      */ 
/*  838 */           if (inOrOutPut.length <= 0) {
/*      */             continue;
/*      */           }
/*  841 */           if (!bindingOp.getRef().equals(opMetaData.getQName()))
/*      */             continue;
/*  843 */           WSDLBindingMessageReference bindingInput = inOrOutPut[0];
/*  844 */           for (WSDLMIMEPart mimePart : bindingInput.getMimeParts())
/*      */           {
/*  846 */             String partName = mimePart.getPartName();
/*  847 */             if (paramMetaData.getPartName().equals(partName))
/*      */             {
/*  849 */               log.debug("Identified 'mime:content' binding: " + partName + ", mimeTypes=" + mimePart.getMimeTypes());
/*  850 */               paramMetaData.setSwA(true);
/*  851 */               paramMetaData.setMimeTypes(mimePart.getMimeTypes());
/*  852 */               break;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void processWebMethods(EndpointMetaData epMetaData, Class<?> wsClass)
/*      */   {
/*  865 */     epMetaData.clearOperations();
/*      */ 
/*  868 */     int webMethodCount = 0;
/*  869 */     for (Method method : wsClass.getMethods())
/*      */     {
/*  871 */       WebMethod annotation = (WebMethod)method.getAnnotation(WebMethod.class);
/*  872 */       boolean exclude = (annotation != null) && (annotation.exclude());
/*  873 */       if ((exclude) || ((annotation == null) && (!wsClass.isInterface())))
/*      */         continue;
/*  875 */       processWebMethod(epMetaData, method);
/*  876 */       webMethodCount++;
/*      */     }
/*      */ 
/*  881 */     if ((webMethodCount == 0) && (!wsClass.isInterface()))
/*      */     {
/*  883 */       for (Method method : wsClass.getMethods())
/*      */       {
/*  885 */         WebMethod annotation = (WebMethod)method.getAnnotation(WebMethod.class);
/*  886 */         boolean exclude = (annotation != null) && (annotation.exclude());
/*  887 */         if ((exclude) || (method.getDeclaringClass() == Object.class))
/*      */           continue;
/*  889 */         processWebMethod(epMetaData, method);
/*  890 */         webMethodCount++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  895 */     if (webMethodCount == 0)
/*  896 */       throw new WSException("No exposable methods found");
/*      */   }
/*      */ 
/*      */   protected void initWrapperGenerator(ClassLoader loader)
/*      */   {
/*  902 */     if (this.wrapperGenerator == null)
/*  903 */       this.wrapperGenerator = new DynamicWrapperGenerator(loader);
/*  904 */     else this.wrapperGenerator.reset(loader);
/*      */   }
/*      */ 
/*      */   protected void resetMetaDataBuilder(ClassLoader loader)
/*      */   {
/*  909 */     initWrapperGenerator(loader);
/*  910 */     this.javaTypes.clear();
/*  911 */     this.typeRefs.clear();
/*  912 */     this.jaxbCtx = null;
/*      */   }
/*      */ 
/*      */   protected void createJAXBContext(EndpointMetaData epMetaData)
/*      */   {
/*      */     try
/*      */     {
/*  919 */       String targetNS = epMetaData.getPortTypeName().getNamespaceURI().intern();
/*  920 */       if (log.isDebugEnabled()) {
/*  921 */         log.debug("JAXBContext [types=" + this.javaTypes + ",tns=" + targetNS + "]");
/*      */       }
/*  923 */       JAXBContextFactory factory = JAXBContextFactory.newInstance();
/*      */ 
/*  928 */       BindingCustomization bindingCustomization = null;
/*  929 */       if ((epMetaData instanceof ServerEndpointMetaData))
/*      */       {
/*  931 */         Endpoint endpoint = ((ServerEndpointMetaData)epMetaData).getEndpoint();
/*  932 */         bindingCustomization = endpoint != null ? (BindingCustomization)endpoint.getAttachment(BindingCustomization.class) : null;
/*      */       }
/*      */ 
/*  935 */       this.jaxbCtx = factory.createContext((Class[])this.javaTypes.toArray(new Class[0]), this.typeRefs, targetNS, false, bindingCustomization);
/*      */     }
/*      */     catch (WSException ex)
/*      */     {
/*  944 */       throw new IllegalStateException("Cannot build JAXB context", ex);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void populateXmlType(FaultMetaData faultMetaData)
/*      */   {
/*  950 */     EndpointMetaData epMetaData = faultMetaData.getOperationMetaData().getEndpointMetaData();
/*  951 */     TypesMetaData types = epMetaData.getServiceMetaData().getTypesMetaData();
/*      */ 
/*  953 */     QName xmlType = faultMetaData.getXmlType();
/*  954 */     String faultBeanName = faultMetaData.getFaultBeanName();
/*      */ 
/*  956 */     types.addTypeMapping(new TypeMappingMetaData(types, xmlType, faultBeanName));
/*      */   }
/*      */ 
/*      */   private void populateXmlType(ParameterMetaData paramMetaData)
/*      */   {
/*  961 */     EndpointMetaData epMetaData = paramMetaData.getOperationMetaData().getEndpointMetaData();
/*  962 */     TypesMetaData types = epMetaData.getServiceMetaData().getTypesMetaData();
/*      */ 
/*  964 */     QName xmlName = paramMetaData.getXmlName();
/*  965 */     QName xmlType = paramMetaData.getXmlType();
/*  966 */     Class javaType = paramMetaData.getJavaType();
/*  967 */     String javaName = paramMetaData.getJavaTypeName();
/*      */ 
/*  969 */     if (xmlType == null)
/*      */     {
/*      */       try
/*      */       {
/*  973 */         xmlType = this.jaxbCtx.getTypeName(new TypeReference(xmlName, javaType, new Annotation[0]));
/*      */       }
/*      */       catch (IllegalArgumentException e)
/*      */       {
/*  977 */         throw new IllegalStateException("Cannot obtain xml type for: [xmlName=" + xmlName + ",javaName=" + javaName + "]");
/*      */       }
/*      */ 
/*  987 */       if (xmlType == null) {
/*  988 */         xmlType = new QName(xmlName.getNamespaceURI(), ">" + xmlName.getLocalPart());
/*      */       }
/*  990 */       paramMetaData.setXmlType(xmlType);
/*      */     }
/*      */ 
/*  993 */     types.addTypeMapping(new TypeMappingMetaData(types, xmlType, javaName));
/*      */   }
/*      */ 
/*      */   protected void populateXmlTypes(EndpointMetaData epMetaData)
/*      */   {
/*  998 */     for (OperationMetaData operation : epMetaData.getOperations())
/*      */     {
/* 1001 */       for (ParameterMetaData paramMetaData : operation.getParameters())
/*      */       {
/* 1003 */         populateXmlType(paramMetaData);
/*      */       }
/*      */ 
/* 1007 */       ParameterMetaData returnParameter = operation.getReturnParameter();
/* 1008 */       if (returnParameter != null) {
/* 1009 */         populateXmlType(returnParameter);
/*      */       }
/*      */ 
/* 1012 */       for (FaultMetaData faultMetaData : operation.getFaults())
/*      */       {
/* 1014 */         populateXmlType(faultMetaData);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setWrapperGenerator(WrapperGenerator wrapperGenerator)
/*      */   {
/* 1024 */     this.wrapperGenerator = wrapperGenerator;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder
 * JD-Core Version:    0.6.0
 */