/*     */ package org.jboss.ws.metadata.builder.jaxrpc;
/*     */ 
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
/*     */ 
/*     */ public class JAXRPCServerMetaDataBuilder extends JAXRPCMetaDataBuilder
/*     */ {
/*  66 */   final Logger log = Logger.getLogger(JAXRPCServerMetaDataBuilder.class);
/*     */ 
/*     */   public UnifiedMetaData buildMetaData(ArchiveDeployment dep)
/*     */   {
/*  73 */     this.log.debug("START buildMetaData: [name=" + dep.getCanonicalName() + "]");
/*     */     try
/*     */     {
/*  77 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(dep.getRootFile());
/*  78 */       wsMetaData.setDeploymentName(dep.getCanonicalName());
/*  79 */       ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
/*  80 */       if (null == runtimeClassLoader)
/*  81 */         throw new IllegalArgumentException("Runtime loader cannot be null");
/*  82 */       wsMetaData.setClassLoader(runtimeClassLoader);
/*     */ 
/*  84 */       WebservicesMetaData jaxrpcMapping = (WebservicesMetaData)dep.getAttachment(WebservicesMetaData.class);
/*  85 */       WebserviceDescriptionMetaData[] wsDescriptionArr = jaxrpcMapping.getWebserviceDescriptions();
/*  86 */       for (WebserviceDescriptionMetaData wsdMetaData : wsDescriptionArr)
/*     */       {
/*  88 */         ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, null);
/*  89 */         serviceMetaData.setWebserviceDescriptionName(wsdMetaData.getWebserviceDescriptionName());
/*  90 */         wsMetaData.addService(serviceMetaData);
/*     */ 
/*  93 */         String wsdlFile = wsdMetaData.getWsdlFile();
/*  94 */         serviceMetaData.setWsdlFile(wsdlFile);
/*     */ 
/*  97 */         WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
/*     */ 
/* 100 */         String mappingFile = wsdMetaData.getJaxrpcMappingFile();
/* 101 */         serviceMetaData.setMappingLocation(dep.getMetaDataFileURL(mappingFile));
/* 102 */         JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
/* 103 */         if (javaWsdlMapping == null) {
/* 104 */           throw new WSException("jaxrpc-mapping-file not configured from webservices.xml");
/*     */         }
/*     */ 
/* 107 */         setupTypesMetaData(serviceMetaData);
/*     */ 
/* 110 */         WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
/* 111 */         WSSecurityConfiguration securityConfiguration = wsseConfFactory.createConfiguration(wsMetaData.getRootFile(), WSSecurityOMFactory.SERVER_RESOURCE_NAME);
/* 112 */         serviceMetaData.setSecurityConfiguration(securityConfiguration);
/*     */ 
/* 115 */         PortComponentMetaData[] pcMetaDataArr = wsdMetaData.getPortComponents();
/* 116 */         for (PortComponentMetaData pcMetaData : pcMetaDataArr)
/*     */         {
/* 118 */           String linkName = pcMetaData.getEjbLink() != null ? pcMetaData.getEjbLink() : pcMetaData.getServletLink();
/* 119 */           QName portName = pcMetaData.getWsdlPort();
/*     */ 
/* 123 */           if (portName.getNamespaceURI().length() == 0)
/*     */           {
/* 125 */             String nsURI = wsdlDefinitions.getTargetNamespace();
/* 126 */             portName = new QName(nsURI, portName.getLocalPart());
/* 127 */             this.log.warn("Adding wsdl targetNamespace to: " + portName);
/* 128 */             pcMetaData.setWsdlPort(portName);
/*     */           }
/*     */ 
/* 131 */           WSDLEndpoint wsdlEndpoint = getWsdlEndpoint(wsdlDefinitions, portName);
/* 132 */           if (wsdlEndpoint == null) {
/* 133 */             throw new WSException("Cannot find port in wsdl: " + portName);
/*     */           }
/*     */ 
/* 136 */           serviceMetaData.setServiceName(wsdlEndpoint.getWsdlService().getName());
/* 137 */           QName interfaceQName = wsdlEndpoint.getInterface().getName();
/*     */ 
/* 139 */           Endpoint ep = dep.getService().getEndpointByName(linkName);
/* 140 */           ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, ep, portName, interfaceQName, EndpointMetaData.Type.JAXRPC);
/* 141 */           sepMetaData.setPortComponentName(pcMetaData.getPortComponentName());
/* 142 */           sepMetaData.setLinkName(linkName);
/* 143 */           serviceMetaData.addEndpoint(sepMetaData);
/*     */ 
/* 145 */           initEndpointEncodingStyle(sepMetaData);
/*     */ 
/* 147 */           initEndpointAddress(dep, sepMetaData);
/*     */ 
/* 149 */           EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
/* 150 */           JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
/* 151 */           if (apMetaData != null)
/*     */           {
/* 153 */             wsMetaData.setSecurityDomain(apMetaData.getSecurityDomain());
/*     */ 
/* 156 */             String wsdName = serviceMetaData.getWebserviceDescriptionName();
/* 157 */             String wsdlPublishLocation = apMetaData.getWsdlPublishLocationByName(wsdName);
/* 158 */             serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
/*     */ 
/* 161 */             EJBMetaData bmd = apMetaData.getBeanByEjbName(linkName);
/* 162 */             if (bmd == null) {
/* 163 */               throw new WSException("Cannot obtain UnifiedBeanMetaData for: " + linkName);
/*     */             }
/* 165 */             String configName = apMetaData.getConfigName();
/* 166 */             String configFile = apMetaData.getConfigFile();
/* 167 */             if ((configName != null) || (configFile != null)) {
/* 168 */               sepMetaData.setConfigName(configName, configFile);
/*     */             }
/* 170 */             EJBSecurityMetaData smd = bmd.getSecurityMetaData();
/* 171 */             if (smd != null)
/*     */             {
/* 173 */               String authMethod = smd.getAuthMethod();
/* 174 */               sepMetaData.setAuthMethod(authMethod);
/* 175 */               String transportGuarantee = smd.getTransportGuarantee();
/* 176 */               sepMetaData.setTransportGuarantee(transportGuarantee);
/* 177 */               Boolean secureWSDLAccess = Boolean.valueOf(smd.getSecureWSDLAccess());
/* 178 */               sepMetaData.setSecureWSDLAccess(secureWSDLAccess.booleanValue());
/*     */             }
/*     */           }
/* 181 */           else if (webMetaData != null)
/*     */           {
/* 183 */             wsMetaData.setSecurityDomain(webMetaData.getSecurityDomain());
/*     */ 
/* 185 */             String targetBean = (String)webMetaData.getServletClassNames().get(linkName);
/* 186 */             sepMetaData.setServiceEndpointImplName(targetBean);
/*     */ 
/* 189 */             String wsdName = serviceMetaData.getWebserviceDescriptionName();
/* 190 */             String wsdlPublishLocation = webMetaData.getWsdlPublishLocationByName(wsdName);
/* 191 */             serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
/*     */ 
/* 193 */             String configName = webMetaData.getConfigName();
/* 194 */             String configFile = webMetaData.getConfigFile();
/* 195 */             if ((configName != null) || (configFile != null)) {
/* 196 */               sepMetaData.setConfigName(configName, configFile);
/*     */             }
/* 198 */             initTransportGuaranteeJSE(dep, sepMetaData, linkName);
/*     */           }
/*     */ 
/* 202 */           ObjectName sepID = createServiceEndpointID(dep, sepMetaData);
/* 203 */           sepMetaData.setServiceEndpointID(sepID);
/*     */ 
/* 205 */           replaceAddressLocation(sepMetaData);
/*     */ 
/* 207 */           String seiName = pcMetaData.getServiceEndpointInterface();
/* 208 */           sepMetaData.setServiceEndpointInterfaceName(seiName);
/*     */ 
/* 210 */           ServiceEndpointInterfaceMapping seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMapping(seiName);
/* 211 */           if (seiMapping == null) {
/* 212 */             this.log.warn("Cannot obtain SEI mapping for: " + seiName);
/*     */           }
/*     */ 
/* 215 */           processEndpointMetaDataExtensions(sepMetaData, wsdlDefinitions);
/*     */ 
/* 218 */           setupOperationsFromWSDL(sepMetaData, wsdlEndpoint, seiMapping);
/*     */ 
/* 221 */           for (UnifiedHandlerMetaData uhmd : pcMetaData.getHandlers())
/*     */           {
/* 223 */             Set portNames = uhmd.getPortNames();
/* 224 */             if ((portNames.size() != 0) && (!portNames.contains(portName.getLocalPart())))
/*     */               continue;
/* 226 */             HandlerMetaDataJAXRPC hmd = HandlerMetaDataJAXRPC.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 227 */             sepMetaData.addHandler(hmd);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 233 */       this.log.debug("END buildMetaData: " + wsMetaData);
/* 234 */       return wsMetaData;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 238 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 242 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*     */   }
/*     */ 
/*     */   private WSDLEndpoint getWsdlEndpoint(WSDLDefinitions wsdlDefinitions, QName portName)
/*     */   {
/* 248 */     WSDLEndpoint wsdlEndpoint = null;
/* 249 */     for (WSDLService wsdlService : wsdlDefinitions.getServices())
/*     */     {
/* 251 */       WSDLEndpoint auxEndpoint = wsdlService.getEndpoint(portName);
/* 252 */       if (auxEndpoint == null)
/*     */         continue;
/* 254 */       wsdlEndpoint = auxEndpoint;
/* 255 */       break;
/*     */     }
/*     */ 
/* 258 */     return wsdlEndpoint;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxrpc.JAXRPCServerMetaDataBuilder
 * JD-Core Version:    0.6.0
 */