/*     */ package org.jboss.ws.metadata.builder.jaxrpc;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ 
/*     */ public class JAXRPCClientMetaDataBuilder extends JAXRPCMetaDataBuilder
/*     */ {
/*  65 */   private final Logger log = Logger.getLogger(JAXRPCClientMetaDataBuilder.class);
/*     */ 
/*     */   public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, URL mappingURL, URL securityURL, UnifiedServiceRefMetaData serviceRefMetaData, ClassLoader loader)
/*     */   {
/*     */     try
/*     */     {
/*  74 */       JavaWsdlMapping javaWsdlMapping = null;
/*  75 */       if (mappingURL != null)
/*     */       {
/*  77 */         JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
/*  78 */         javaWsdlMapping = mappingFactory.parse(mappingURL);
/*     */       }
/*     */ 
/*  81 */       WSSecurityConfiguration securityConfig = null;
/*  82 */       if (securityURL != null)
/*     */       {
/*  84 */         securityConfig = WSSecurityOMFactory.newInstance().parse(securityURL);
/*     */       }
/*     */ 
/*  87 */       return buildMetaData(serviceQName, wsdlURL, javaWsdlMapping, securityConfig, serviceRefMetaData, loader);
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/*  91 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/*  95 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*     */   }
/*     */ 
/*     */   public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, JavaWsdlMapping javaWsdlMapping, WSSecurityConfiguration securityConfig, UnifiedServiceRefMetaData usrMetaData, ClassLoader loader)
/*     */   {
/* 104 */     if (this.log.isDebugEnabled()) this.log.debug("START buildMetaData: [service=" + serviceQName + "]");
/*     */     try
/*     */     {
/* 107 */       ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter(loader);
/*     */ 
/* 109 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(vfsRoot);
/* 110 */       wsMetaData.setClassLoader(loader);
/*     */ 
/* 112 */       ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceQName);
/* 113 */       wsMetaData.addService(serviceMetaData);
/*     */ 
/* 115 */       serviceMetaData.setWsdlLocation(wsdlURL);
/* 116 */       WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
/*     */ 
/* 118 */       if (javaWsdlMapping != null)
/*     */       {
/* 120 */         URL mappingURL = new URL("http://www.jboss.org/jbossws/dummy-mapping-file");
/* 121 */         if ((usrMetaData != null) && (usrMetaData.getMappingLocation() != null))
/*     */         {
/* 123 */           mappingURL = usrMetaData.getMappingLocation();
/*     */         }
/* 125 */         wsMetaData.addMappingDefinition(mappingURL.toExternalForm(), javaWsdlMapping);
/* 126 */         serviceMetaData.setMappingLocation(mappingURL);
/*     */       }
/*     */ 
/* 129 */       if (securityConfig != null)
/*     */       {
/* 131 */         serviceMetaData.setSecurityConfiguration(securityConfig);
/* 132 */         setupSecurity(securityConfig, wsMetaData.getRootFile());
/*     */       }
/*     */ 
/* 135 */       buildMetaDataInternal(serviceMetaData, wsdlDefinitions, javaWsdlMapping, usrMetaData);
/*     */ 
/* 138 */       wsMetaData.eagerInitialize();
/*     */ 
/* 140 */       if (this.log.isDebugEnabled()) this.log.debug("END buildMetaData: " + wsMetaData);
/* 141 */       return serviceMetaData;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 145 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 149 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*     */   }
/*     */ 
/*     */   private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions, JavaWsdlMapping javaWsdlMapping, UnifiedServiceRefMetaData serviceRefMetaData)
/*     */     throws IOException
/*     */   {
/* 156 */     QName serviceQName = serviceMetaData.getServiceName();
/*     */ 
/* 159 */     WSDLService wsdlService = null;
/* 160 */     if (serviceQName == null)
/*     */     {
/* 162 */       if (wsdlDefinitions.getServices().length != 1) {
/* 163 */         throw new IllegalArgumentException("Expected a single service element");
/*     */       }
/* 165 */       wsdlService = wsdlDefinitions.getServices()[0];
/* 166 */       serviceMetaData.setServiceName(wsdlService.getName());
/*     */     }
/*     */     else
/*     */     {
/* 170 */       wsdlService = wsdlDefinitions.getService(serviceQName);
/*     */     }
/* 172 */     if (wsdlService == null) {
/* 173 */       throw new IllegalArgumentException("Cannot obtain wsdl service: " + serviceQName);
/*     */     }
/*     */ 
/* 176 */     setupTypesMetaData(serviceMetaData);
/*     */ 
/* 179 */     for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints())
/*     */     {
/* 181 */       QName bindingName = wsdlEndpoint.getBinding();
/* 182 */       WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
/* 183 */       String bindingType = wsdlBinding.getType();
/* 184 */       if ((!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType)) && (!"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)))
/*     */         continue;
/* 186 */       QName portName = wsdlEndpoint.getName();
/* 187 */       QName interfaceQName = wsdlEndpoint.getInterface().getName();
/* 188 */       ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, portName, interfaceQName, EndpointMetaData.Type.JAXRPC);
/* 189 */       epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
/* 190 */       serviceMetaData.addEndpoint(epMetaData);
/*     */ 
/* 193 */       if (serviceRefMetaData != null)
/*     */       {
/* 195 */         String configName = serviceRefMetaData.getConfigName();
/* 196 */         String configFile = serviceRefMetaData.getConfigFile();
/* 197 */         if ((configName != null) || (configFile != null)) {
/* 198 */           epMetaData.setConfigName(configName, configFile);
/*     */         }
/*     */       }
/*     */ 
/* 202 */       initEndpointBinding(wsdlEndpoint, epMetaData);
/*     */ 
/* 205 */       initEndpointEncodingStyle(epMetaData);
/*     */ 
/* 207 */       ServiceEndpointInterfaceMapping seiMapping = null;
/* 208 */       if (javaWsdlMapping != null)
/*     */       {
/* 210 */         QName portType = wsdlEndpoint.getInterface().getName();
/* 211 */         seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMappingByPortType(portType);
/* 212 */         if (seiMapping != null)
/*     */         {
/* 214 */           epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
/*     */         }
/*     */         else
/*     */         {
/* 218 */           this.log.warn("Cannot obtain the SEI mapping for: " + portType);
/*     */         }
/*     */       }
/*     */ 
/* 222 */       processEndpointMetaDataExtensions(epMetaData, wsdlDefinitions);
/* 223 */       setupOperationsFromWSDL(epMetaData, wsdlEndpoint, seiMapping);
/* 224 */       setupHandlers(serviceRefMetaData, portName, epMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupHandlers(UnifiedServiceRefMetaData serviceRefMetaData, QName portName, EndpointMetaData epMetaData)
/*     */   {
/* 232 */     if (serviceRefMetaData != null)
/*     */     {
/* 234 */       for (UnifiedHandlerMetaData uhmd : serviceRefMetaData.getHandlers())
/*     */       {
/* 236 */         Set portNames = uhmd.getPortNames();
/* 237 */         if ((portNames.size() == 0) || (portNames.contains(portName.getLocalPart())))
/*     */         {
/* 239 */           HandlerMetaDataJAXRPC hmd = HandlerMetaDataJAXRPC.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 240 */           epMetaData.addHandler(hmd);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupSecurity(WSSecurityConfiguration securityConfig, UnifiedVirtualFile vfsRoot)
/*     */   {
/* 248 */     if (securityConfig.getKeyStoreFile() != null) {
/*     */       try
/*     */       {
/* 251 */         UnifiedVirtualFile child = vfsRoot.findChild(securityConfig.getKeyStoreFile());
/* 252 */         securityConfig.setKeyStoreURL(child.toURL());
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/*     */     }
/* 258 */     if (securityConfig.getTrustStoreFile() != null)
/*     */       try
/*     */       {
/* 261 */         UnifiedVirtualFile child = vfsRoot.findChild(securityConfig.getTrustStoreFile());
/* 262 */         securityConfig.setTrustStoreURL(child.toURL());
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxrpc.JAXRPCClientMetaDataBuilder
 * JD-Core Version:    0.6.0
 */