/*     */ package org.jboss.ws.metadata.builder;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import javax.wsdl.Definition;
/*     */ import javax.wsdl.Import;
/*     */ import javax.wsdl.Port;
/*     */ import javax.wsdl.extensions.http.HTTPAddress;
/*     */ import javax.wsdl.extensions.soap.SOAPAddress;
/*     */ import javax.wsdl.extensions.soap12.SOAP12Address;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Use;
/*     */ import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
/*     */ import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
/*     */ import org.jboss.ws.extensions.eventing.EventingUtils;
/*     */ import org.jboss.ws.extensions.eventing.metadata.EventingEpMetaExt;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.ObjectNameFactory;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.management.ServerConfig;
/*     */ import org.jboss.wsf.spi.management.ServerConfigFactory;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData.JSEResourceCollection;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
/*     */ 
/*     */ public abstract class MetaDataBuilder
/*     */ {
/*  92 */   private static final Logger log = Logger.getLogger(MetaDataBuilder.class);
/*     */ 
/*     */   protected void initEndpointBinding(WSDLEndpoint wsdlEndpoint, ClientEndpointMetaData epMetaData)
/*     */   {
/*  97 */     WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getWsdlService().getWsdlDefinitions();
/*  98 */     WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
/*  99 */     WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getName());
/* 100 */     String bindingType = wsdlBinding.getType();
/* 101 */     if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType))
/* 102 */       epMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http");
/* 103 */     else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType))
/* 104 */       epMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
/*     */   }
/*     */ 
/*     */   protected void initEndpointEncodingStyle(EndpointMetaData epMetaData)
/*     */   {
/* 111 */     WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
/* 112 */     for (WSDLService wsdlService : wsdlDefinitions.getServices())
/*     */     {
/* 114 */       for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints())
/*     */       {
/* 116 */         if (!epMetaData.getPortName().equals(wsdlEndpoint.getName()))
/*     */           continue;
/* 118 */         QName bindQName = wsdlEndpoint.getBinding();
/* 119 */         WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(bindQName);
/* 120 */         if (wsdlBinding == null) {
/* 121 */           throw new WSException("Cannot obtain binding: " + bindQName);
/*     */         }
/* 123 */         for (WSDLBindingOperation wsdlBindingOperation : wsdlBinding.getOperations())
/*     */         {
/* 125 */           String encStyle = wsdlBindingOperation.getEncodingStyle();
/* 126 */           epMetaData.setEncodingStyle(Use.valueOf(encStyle));
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initEndpointAddress(Deployment dep, ServerEndpointMetaData sepMetaData)
/*     */   {
/* 135 */     String contextRoot = dep.getService().getContextRoot();
/* 136 */     String urlPattern = null;
/*     */ 
/* 139 */     String linkName = sepMetaData.getLinkName();
/* 140 */     if (linkName != null)
/*     */     {
/* 142 */       Endpoint endpoint = dep.getService().getEndpointByName(linkName);
/* 143 */       if (endpoint != null) {
/* 144 */         urlPattern = endpoint.getURLPattern();
/*     */       }
/*     */     }
/*     */ 
/* 148 */     if (contextRoot == null)
/*     */     {
/* 150 */       String simpleName = dep.getSimpleName();
/* 151 */       contextRoot = simpleName.substring(0, simpleName.indexOf('.'));
/* 152 */       if ((dep instanceof ArchiveDeployment))
/*     */       {
/* 154 */         if (((ArchiveDeployment)dep).getParent() != null)
/*     */         {
/* 156 */           simpleName = ((ArchiveDeployment)dep).getParent().getSimpleName();
/* 157 */           simpleName = simpleName.substring(0, simpleName.indexOf('.'));
/* 158 */           contextRoot = simpleName + "-" + contextRoot;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 164 */     if (urlPattern == null) {
/* 165 */       urlPattern = "/*";
/*     */     }
/* 167 */     if (!contextRoot.startsWith("/"))
/* 168 */       contextRoot = "/" + contextRoot;
/* 169 */     if (!urlPattern.startsWith("/")) {
/* 170 */       urlPattern = "/" + urlPattern;
/*     */     }
/* 172 */     sepMetaData.setContextRoot(contextRoot);
/* 173 */     sepMetaData.setURLPattern(urlPattern);
/*     */ 
/* 175 */     String servicePath = contextRoot + urlPattern;
/* 176 */     sepMetaData.setEndpointAddress(getServiceEndpointAddress(null, servicePath));
/*     */   }
/*     */ 
/*     */   public static ObjectName createServiceEndpointID(Deployment dep, ServerEndpointMetaData sepMetaData)
/*     */   {
/* 181 */     String linkName = sepMetaData.getLinkName();
/* 182 */     String context = sepMetaData.getContextRoot();
/* 183 */     if (context.startsWith("/")) {
/* 184 */       context = context.substring(1);
/*     */     }
/* 186 */     StringBuilder idstr = new StringBuilder("jboss.ws:");
/* 187 */     idstr.append("context=" + context);
/* 188 */     idstr.append(",endpoint=" + linkName);
/*     */ 
/* 191 */     EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
/* 192 */     if (apMetaData != null)
/*     */     {
/* 194 */       String ejbName = sepMetaData.getLinkName();
/* 195 */       if (ejbName == null) {
/* 196 */         throw new WSException("Cannot obtain ejb-link from port component");
/*     */       }
/* 198 */       EJBMetaData beanMetaData = apMetaData.getBeanByEjbName(ejbName);
/* 199 */       if (beanMetaData == null) {
/* 200 */         throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
/*     */       }
/* 202 */       if ((beanMetaData instanceof MDBMetaData))
/*     */       {
/* 204 */         MDBMetaData mdMetaData = (MDBMetaData)beanMetaData;
/* 205 */         String jndiName = mdMetaData.getDestinationJndiName();
/* 206 */         idstr.append(",jms=" + jndiName);
/*     */       }
/*     */     }
/*     */ 
/* 210 */     return ObjectNameFactory.create(idstr.toString());
/*     */   }
/*     */ 
/*     */   public static String getServiceEndpointAddress(String uriScheme, String servicePath)
/*     */   {
/* 217 */     if ((servicePath == null) || (servicePath.length() == 0)) {
/* 218 */       throw new WSException("Service path cannot be null");
/*     */     }
/* 220 */     if (servicePath.endsWith("/*")) {
/* 221 */       servicePath = servicePath.substring(0, servicePath.length() - 2);
/*     */     }
/* 223 */     if (uriScheme == null) {
/* 224 */       uriScheme = "http";
/*     */     }
/* 226 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 227 */     ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
/*     */ 
/* 229 */     String host = config.getWebServiceHost();
/* 230 */     int port = config.getWebServicePort();
/* 231 */     if ("https".equals(uriScheme)) {
/* 232 */       port = config.getWebServiceSecurePort();
/*     */     }
/* 234 */     String urlStr = uriScheme + "://" + host + ":" + port + servicePath;
/*     */     try
/*     */     {
/* 237 */       return new URL(urlStr).toExternalForm();
/*     */     }
/*     */     catch (MalformedURLException e) {
/*     */     }
/* 241 */     throw new WSException("Malformed URL: " + urlStr);
/*     */   }
/*     */ 
/*     */   protected void initTransportGuaranteeJSE(Deployment dep, ServerEndpointMetaData sepMetaData, String servletLink)
/*     */     throws IOException
/*     */   {
/* 250 */     String transportGuarantee = null;
/* 251 */     JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
/*     */     String urlPattern;
/*     */     Iterator i$;
/* 252 */     if (webMetaData != null)
/*     */     {
/* 254 */       Map servletMappings = webMetaData.getServletMappings();
/* 255 */       urlPattern = (String)servletMappings.get(servletLink);
/*     */ 
/* 257 */       if (urlPattern == null) {
/* 258 */         throw new WSException("Cannot find <url-pattern> for servlet-name: " + servletLink);
/*     */       }
/* 260 */       List securityList = webMetaData.getSecurityMetaData();
/* 261 */       for (i$ = securityList.iterator(); i$.hasNext(); ) { currentSecurity = (JSESecurityMetaData)i$.next();
/*     */ 
/* 263 */         if ((currentSecurity.getTransportGuarantee() != null) && (currentSecurity.getTransportGuarantee().length() > 0))
/*     */         {
/* 265 */           for (JSESecurityMetaData.JSEResourceCollection currentCollection : currentSecurity.getWebResources())
/*     */           {
/* 267 */             for (String currentUrlPattern : currentCollection.getUrlPatterns())
/*     */             {
/* 269 */               if (urlPattern.equals(currentUrlPattern))
/*     */               {
/* 271 */                 transportGuarantee = currentSecurity.getTransportGuarantee();
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     JSESecurityMetaData currentSecurity;
/* 278 */     sepMetaData.setTransportGuarantee(transportGuarantee);
/*     */   }
/*     */ 
/*     */   public static void replaceAddressLocation(ServerEndpointMetaData sepMetaData)
/*     */   {
/* 285 */     WSDLDefinitions wsdlDefinitions = sepMetaData.getServiceMetaData().getWsdlDefinitions();
/* 286 */     QName portName = sepMetaData.getPortName();
/*     */ 
/* 288 */     boolean endpointFound = false;
/* 289 */     for (WSDLService wsdlService : wsdlDefinitions.getServices())
/*     */     {
/* 291 */       for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints())
/*     */       {
/* 293 */         QName wsdlPortName = wsdlEndpoint.getName();
/* 294 */         if (!wsdlPortName.equals(portName))
/*     */           continue;
/* 296 */         endpointFound = true;
/*     */ 
/* 298 */         String orgAddress = wsdlEndpoint.getAddress();
/* 299 */         String uriScheme = getUriScheme(orgAddress);
/*     */ 
/* 301 */         String transportGuarantee = sepMetaData.getTransportGuarantee();
/* 302 */         if ("CONFIDENTIAL".equals(transportGuarantee)) {
/* 303 */           uriScheme = "https";
/*     */         }
/* 305 */         String servicePath = sepMetaData.getContextRoot() + sepMetaData.getURLPattern();
/* 306 */         String serviceEndpointURL = getServiceEndpointAddress(uriScheme, servicePath);
/*     */ 
/* 308 */         SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 309 */         ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
/* 310 */         boolean alwaysModify = config.isModifySOAPAddress();
/*     */ 
/* 312 */         if ((alwaysModify) || (uriScheme == null) || (orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0))
/*     */         {
/* 314 */           log.debug("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'");
/* 315 */           wsdlEndpoint.setAddress(serviceEndpointURL);
/* 316 */           sepMetaData.setEndpointAddress(serviceEndpointURL);
/*     */ 
/* 319 */           if (wsdlDefinitions.getWsdlOneOneDefinition() != null)
/* 320 */             replaceWSDL11PortAddress(wsdlDefinitions, portName, serviceEndpointURL);
/*     */         }
/*     */         else
/*     */         {
/* 324 */           log.debug("Don't replace service endpoint address '" + orgAddress + "'");
/*     */           try
/*     */           {
/* 327 */             sepMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
/*     */           }
/*     */           catch (MalformedURLException e)
/*     */           {
/* 331 */             throw new WSException("Malformed URL: " + orgAddress);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 338 */     if (!endpointFound)
/* 339 */       throw new WSException("Cannot find port in wsdl: " + portName);
/*     */   }
/*     */ 
/*     */   private static void replaceWSDL11PortAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL)
/*     */   {
/* 344 */     Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
/* 345 */     String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
/*     */ 
/* 348 */     Port wsdlOneOnePort = modifyPortAddress(tnsURI, portQName, serviceEndpointURL, wsdlOneOneDefinition.getServices());
/*     */ 
/* 351 */     if ((wsdlOneOnePort == null) && (!wsdlOneOneDefinition.getImports().isEmpty()))
/*     */     {
/* 354 */       Iterator imports = wsdlOneOneDefinition.getImports().values().iterator();
/* 355 */       while (imports.hasNext())
/*     */       {
/* 357 */         List l = (List)imports.next();
/* 358 */         Iterator importsByNS = l.iterator();
/* 359 */         while (importsByNS.hasNext())
/*     */         {
/* 361 */           Import anImport = (Import)importsByNS.next();
/* 362 */           wsdlOneOnePort = modifyPortAddress(anImport.getNamespaceURI(), portQName, serviceEndpointURL, anImport.getDefinition().getServices());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 368 */     if (wsdlOneOnePort == null)
/* 369 */       throw new IllegalArgumentException("Cannot find port with name '" + portQName + "' in wsdl document");
/*     */   }
/*     */ 
/*     */   private static Port modifyPortAddress(String tnsURI, QName portQName, String serviceEndpointURL, Map services)
/*     */   {
/* 374 */     Port wsdlOneOnePort = null;
/* 375 */     Iterator itServices = services.values().iterator();
/* 376 */     while (itServices.hasNext())
/*     */     {
/* 378 */       javax.wsdl.Service wsdlOneOneService = (javax.wsdl.Service)itServices.next();
/* 379 */       Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
/* 380 */       Iterator itPorts = wsdlOneOnePorts.keySet().iterator();
/*     */       Iterator i$;
/* 381 */       while (itPorts.hasNext())
/*     */       {
/* 383 */         String portLocalName = (String)itPorts.next();
/* 384 */         if (portQName.equals(new QName(tnsURI, portLocalName)))
/*     */         {
/* 386 */           wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
/* 387 */           List extElements = wsdlOneOnePort.getExtensibilityElements();
/* 388 */           for (i$ = extElements.iterator(); i$.hasNext(); ) { Object extElement = i$.next();
/*     */ 
/* 390 */             if ((extElement instanceof SOAPAddress))
/*     */             {
/* 392 */               SOAPAddress address = (SOAPAddress)extElement;
/* 393 */               address.setLocationURI(serviceEndpointURL);
/*     */             }
/* 395 */             else if ((extElement instanceof SOAP12Address))
/*     */             {
/* 397 */               SOAP12Address address = (SOAP12Address)extElement;
/* 398 */               address.setLocationURI(serviceEndpointURL);
/*     */             }
/* 400 */             else if ((extElement instanceof HTTPAddress))
/*     */             {
/* 402 */               HTTPAddress address = (HTTPAddress)extElement;
/* 403 */               address.setLocationURI(serviceEndpointURL);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 410 */     return wsdlOneOnePort;
/*     */   }
/*     */ 
/*     */   private static String getUriScheme(String addrStr)
/*     */   {
/*     */     try
/*     */     {
/* 417 */       URI addrURI = new URI(addrStr);
/* 418 */       String scheme = addrURI.getScheme();
/* 419 */       return scheme;
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/* 423 */     return null;
/*     */   }
/*     */ 
/*     */   protected void processEndpointMetaDataExtensions(EndpointMetaData epMetaData, WSDLDefinitions wsdlDefinitions)
/*     */   {
/* 429 */     for (WSDLInterface wsdlInterface : wsdlDefinitions.getInterfaces())
/*     */     {
/* 431 */       WSDLProperty eventSourceProp = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wse/isEventSource");
/* 432 */       if ((eventSourceProp == null) || (!(epMetaData instanceof ServerEndpointMetaData)))
/*     */         continue;
/* 434 */       ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)epMetaData;
/* 435 */       String eventSourceNS = wsdlInterface.getName().getNamespaceURI() + "/" + wsdlInterface.getName().getLocalPart();
/*     */ 
/* 438 */       JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
/* 439 */       String[] notificationSchema = EventingUtils.extractNotificationSchema(schemaModel);
/*     */ 
/* 442 */       String notificationRootElementNS = null;
/* 443 */       WSDLInterfaceOperation wsdlInterfaceOperation = wsdlInterface.getOperations()[0];
/* 444 */       if (wsdlInterfaceOperation.getOutputs().length > 0)
/*     */       {
/* 446 */         WSDLInterfaceOperationOutput wsdlInterfaceOperationOutput = wsdlInterfaceOperation.getOutputs()[0];
/* 447 */         notificationRootElementNS = wsdlInterfaceOperationOutput.getElement().getNamespaceURI();
/*     */       }
/*     */       else
/*     */       {
/* 453 */         throw new WSException("Unable to resolve eventing root element NS. No operation output found at " + wsdlInterfaceOperation.getName());
/*     */       }
/*     */ 
/* 456 */       EventingEpMetaExt ext = new EventingEpMetaExt("http://schemas.xmlsoap.org/ws/2004/08/eventing");
/* 457 */       ext.setEventSourceNS(eventSourceNS);
/* 458 */       ext.setNotificationSchema(notificationSchema);
/* 459 */       ext.setNotificationRootElementNS(notificationRootElementNS);
/* 460 */       sepMetaData.addExtension(ext);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processOpMetaExtensions(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation)
/*     */   {
/* 469 */     String tns = wsdlOperation.getName().getNamespaceURI();
/* 470 */     String portTypeName = wsdlOperation.getName().getLocalPart();
/*     */ 
/* 472 */     AddressingProperties ADDR = new AddressingPropertiesImpl();
/* 473 */     AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
/*     */ 
/* 476 */     WSDLProperty wsaInAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionIn");
/* 477 */     if (wsaInAction != null)
/*     */     {
/* 479 */       addrExt.setInboundAction(wsaInAction.getValue());
/*     */     }
/*     */     else
/*     */     {
/* 483 */       WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/in");
/* 484 */       addrExt.setInboundAction(tns + "/" + portTypeName + "/" + messageName);
/*     */     }
/*     */ 
/* 488 */     WSDLProperty wsaOutAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionOut");
/* 489 */     if (wsaOutAction != null)
/*     */     {
/* 491 */       addrExt.setOutboundAction(wsaOutAction.getValue());
/*     */     }
/*     */     else
/*     */     {
/* 495 */       WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/out");
/* 496 */       addrExt.setOutboundAction(tns + "/" + portTypeName + "/" + messageName);
/*     */     }
/*     */ 
/* 499 */     opMetaData.addExtension(addrExt);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.MetaDataBuilder
 * JD-Core Version:    0.6.0
 */