/*     */ package org.jboss.ws.metadata.acessor;
/*     */ 
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.umdm.Accessor;
/*     */ import org.jboss.ws.metadata.umdm.AccessorFactory;
/*     */ import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ 
/*     */ public class ReflectiveMethodAccessor
/*     */   implements Accessor
/*     */ {
/*     */   private Method getter;
/*     */   private Method setter;
/*  47 */   public static AccessorFactoryCreator FACTORY_CREATOR = new AccessorFactoryCreator()
/*     */   {
/*     */     public AccessorFactory create(ParameterMetaData parameter)
/*     */     {
/*  51 */       return create(parameter.getJavaType());
/*     */     }
/*     */ 
/*     */     public AccessorFactory create(FaultMetaData fault)
/*     */     {
/*  56 */       return create(fault.getFaultBean());
/*     */     }
/*     */ 
/*     */     private AccessorFactory create(Class clazz)
/*     */     {
/*  61 */       return new AccessorFactory(clazz)
/*     */       {
/*     */         public Accessor create(WrappedParameter parameter) {
/*     */           WSException ex;
/*     */           try {
/*  67 */             PropertyDescriptor pd = new PropertyDescriptor(parameter.getVariable(), this.val$clazz);
/*  68 */             return new ReflectiveMethodAccessor(pd.getReadMethod(), pd.getWriteMethod(), null);
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/*  72 */             ex = new WSException(t.getMessage());
/*  73 */             ex.setStackTrace(t.getStackTrace());
/*  74 */           }throw ex;
/*     */         }
/*     */       };
/*     */     }
/*  47 */   };
/*     */ 
/*     */   private ReflectiveMethodAccessor(Method getter, Method setter)
/*     */   {
/*  83 */     this.getter = getter;
/*  84 */     this.setter = setter;
/*     */   }
/*     */ 
/*     */   public Object get(Object bean) {
/*     */     WSException ex;
/*     */     try {
/*  91 */       return this.getter.invoke(bean, new Object[0]);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  95 */       ex = new WSException(e.getMessage());
/*  96 */       ex.setStackTrace(ex.getStackTrace());
/*  97 */     }throw ex;
/*     */   }
/*     */ 
/*     */   public void set(Object bean, Object value)
/*     */   {
/*     */     try
/*     */     {
/* 105 */       this.setter.invoke(bean, new Object[] { value });
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 109 */       WSException ex = new WSException(e.getMessage());
/* 110 */       ex.setStackTrace(ex.getStackTrace());
/* 111 */       throw ex;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.acessor.ReflectiveMethodAccessor
 * JD-Core Version:    0.6.0
 */