/*     */ package org.jboss.ws.metadata.acessor;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Modifier;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.umdm.Accessor;
/*     */ import org.jboss.ws.metadata.umdm.AccessorFactory;
/*     */ import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ 
/*     */ public class ReflectiveFieldAccessor
/*     */   implements Accessor
/*     */ {
/*     */   private Field field;
/*  46 */   public static AccessorFactoryCreator FACTORY_CREATOR = new AccessorFactoryCreator()
/*     */   {
/*     */     public AccessorFactory create(ParameterMetaData parameter)
/*     */     {
/*  50 */       return create(parameter.getJavaType());
/*     */     }
/*     */ 
/*     */     public AccessorFactory create(FaultMetaData fault)
/*     */     {
/*  55 */       return create(fault.getFaultBean());
/*     */     }
/*     */ 
/*     */     private AccessorFactory create(Class clazz)
/*     */     {
/*  60 */       return new AccessorFactory(clazz)
/*     */       {
/*     */         public Accessor create(WrappedParameter parameter) {
/*  64 */           String fieldName = parameter.getVariable();
/*     */           WSException ex;
/*     */           try {
/*     */             Field field;
/*     */             try {
/*  71 */               field = this.val$clazz.getField(fieldName);
/*     */             }
/*     */             catch (NoSuchFieldException e)
/*     */             {
/*  76 */               field = this.val$clazz.getDeclaredField(fieldName);
/*  77 */               field.setAccessible(true);
/*     */             }
/*     */ 
/*  80 */             if (Modifier.isStatic(field.getModifiers())) {
/*  81 */               throw new WSException("Field can not be static: " + fieldName);
/*     */             }
/*  83 */             return new ReflectiveFieldAccessor(field, null);
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/*  87 */             ex = new WSException("Error accessing field: " + fieldName + t.getClass().getSimpleName() + ": " + t.getMessage());
/*  88 */             ex.setStackTrace(t.getStackTrace());
/*  89 */           }throw ex;
/*     */         }
/*     */       };
/*     */     }
/*  46 */   };
/*     */ 
/*     */   private ReflectiveFieldAccessor(Field field)
/*     */   {
/*  98 */     this.field = field;
/*     */   }
/*     */ 
/*     */   public Object get(Object bean) {
/*     */     WSException ex;
/*     */     try {
/* 105 */       return this.field.get(bean);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 109 */       ex = new WSException(e.getMessage());
/* 110 */       ex.setStackTrace(ex.getStackTrace());
/* 111 */     }throw ex;
/*     */   }
/*     */ 
/*     */   public void set(Object bean, Object value)
/*     */   {
/*     */     try
/*     */     {
/* 119 */       this.field.set(bean, value);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 123 */       WSException ex = new WSException(e.getMessage());
/* 124 */       ex.setStackTrace(ex.getStackTrace());
/* 125 */       throw ex;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.acessor.ReflectiveFieldAccessor
 * JD-Core Version:    0.6.0
 */