/*     */ package org.jboss.ws.metadata.acessor;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.api.JAXBRIContext;
/*     */ import com.sun.xml.bind.api.RawAccessor;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxws.JAXBContextFactory;
/*     */ import org.jboss.ws.metadata.umdm.Accessor;
/*     */ import org.jboss.ws.metadata.umdm.AccessorFactory;
/*     */ import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ 
/*     */ public class JAXBAccessor
/*     */   implements Accessor
/*     */ {
/*     */   private RawAccessor accessor;
/*  51 */   public static AccessorFactoryCreator FACTORY_CREATOR = new AccessorFactoryCreator()
/*     */   {
/*     */     public AccessorFactory create(ParameterMetaData parameter)
/*     */     {
/*  55 */       return create(parameter.getJavaType());
/*     */     }
/*     */ 
/*     */     public AccessorFactory create(FaultMetaData fault)
/*     */     {
/*  60 */       return create(fault.getFaultBean());
/*     */     }
/*     */ 
/*     */     private AccessorFactory create(Class clazz)
/*     */     {
/*  65 */       JAXBRIContext ctx = (JAXBRIContext)JAXBContextFactory.newInstance().createContext(clazz);
/*     */ 
/*  67 */       return new AccessorFactory(ctx, clazz)
/*     */       {
/*     */         public Accessor create(WrappedParameter parameter)
/*     */         {
/*     */           RawAccessor accessor;
/*     */           try {
/*  74 */             QName name = parameter.getName();
/*  75 */             accessor = this.val$ctx.getElementPropertyAccessor(this.val$clazz, name.getNamespaceURI().intern(), name.getLocalPart().intern());
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/*  83 */             WSException ex = new WSException(t.getMessage());
/*  84 */             ex.setStackTrace(t.getStackTrace());
/*  85 */             throw ex;
/*     */           }
/*     */ 
/*  88 */           if (accessor == null) {
/*  89 */             throw new IllegalStateException("Could not obtain accessor for parameter: " + parameter);
/*     */           }
/*  91 */           return new JAXBAccessor(accessor, null);
/*     */         }
/*     */       };
/*     */     }
/*  51 */   };
/*     */ 
/*     */   private JAXBAccessor(RawAccessor accessor)
/*     */   {
/*  99 */     this.accessor = accessor;
/*     */   }
/*     */ 
/*     */   public Object get(Object bean) {
/*     */     WSException ex;
/*     */     try {
/* 106 */       return this.accessor.get(bean);
/*     */     }
/*     */     catch (AccessorException a)
/*     */     {
/* 110 */       ex = new WSException(a.getMessage());
/* 111 */       ex.setStackTrace(a.getStackTrace());
/* 112 */     }throw ex;
/*     */   }
/*     */ 
/*     */   public void set(Object bean, Object value)
/*     */   {
/*     */     try
/*     */     {
/* 120 */       this.accessor.set(bean, value);
/*     */     }
/*     */     catch (AccessorException a)
/*     */     {
/* 124 */       WSException ex = new WSException(a.getMessage());
/* 125 */       ex.setStackTrace(a.getStackTrace());
/* 126 */       throw ex;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.acessor.JAXBAccessor
 * JD-Core Version:    0.6.0
 */