/*     */ package org.jboss.ws.extensions.xop.jaxws;
/*     */ 
/*     */ import java.awt.Image;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.bind.annotation.XmlAttachmentRef;
/*     */ import javax.xml.bind.annotation.XmlMimeType;
/*     */ import javax.xml.transform.Source;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ReflectiveAttachmentRefScanner
/*     */ {
/*  54 */   private static List<Class> SUPPORTED_TYPES = new ArrayList(5);
/*     */ 
/*  66 */   private List<Field> scannedFields = new ArrayList();
/*     */ 
/*     */   public AttachmentScanResult scanBean(Class xmlRoot)
/*     */   {
/*  76 */     if (isJDKType(xmlRoot)) return null;
/*     */ 
/*  78 */     AttachmentScanResult result = null;
/*     */ 
/*  80 */     for (Field field : xmlRoot.getDeclaredFields())
/*     */     {
/*  82 */       Class type = field.getType();
/*     */ 
/*  84 */       boolean exceptionToTheRule = isAttachmentDataType(type);
/*     */ 
/*  87 */       if ((alreadyScanned(field)) || ((!exceptionToTheRule) && (isJDKType(type))))
/*     */       {
/*     */         continue;
/*     */       }
/*  91 */       if (field.isAnnotationPresent(XmlAttachmentRef.class))
/*     */       {
/*  94 */         result = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
/*     */       }
/*  98 */       else if (field.isAnnotationPresent(XmlMimeType.class))
/*     */       {
/* 100 */         XmlMimeType mimeTypeDecl = (XmlMimeType)field.getAnnotation(XmlMimeType.class);
/* 101 */         result = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
/*     */       }
/*     */ 
/* 104 */       if (null == result)
/*     */       {
/* 106 */         result = scanGetterAnnotation(xmlRoot, field);
/*     */       }
/*     */ 
/* 110 */       if (!isAttachmentDataType(type)) {
/* 111 */         this.scannedFields.add(field);
/*     */       }
/*     */ 
/* 114 */       if (null == result) {
/* 115 */         result = scanBean(type);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 121 */     return result;
/*     */   }
/*     */ 
/*     */   public static List<AttachmentScanResult> scanMethod(Method method)
/*     */   {
/* 126 */     List results = new ArrayList();
/*     */ 
/* 129 */     if (method.getReturnType() != Void.TYPE)
/*     */     {
/* 132 */       AttachmentScanResult result = null;
/*     */ 
/* 134 */       if (method.isAnnotationPresent(XmlAttachmentRef.class))
/*     */       {
/* 136 */         result = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
/*     */       }
/* 138 */       else if (method.isAnnotationPresent(XmlMimeType.class))
/*     */       {
/* 140 */         XmlMimeType mimeTypeDecl = (XmlMimeType)method.getAnnotation(XmlMimeType.class);
/* 141 */         result = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
/*     */       }
/*     */ 
/* 144 */       if (result != null)
/*     */       {
/* 146 */         result.setIndex(-1);
/* 147 */         results.add(result);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 153 */     int index = 0;
/* 154 */     for (Annotation[] parameterAnnotations : method.getParameterAnnotations())
/*     */     {
/* 156 */       if (parameterAnnotations != null)
/*     */       {
/* 158 */         for (Annotation annotation : parameterAnnotations)
/*     */         {
/* 160 */           AttachmentScanResult paramResult = null;
/*     */ 
/* 162 */           if (XmlAttachmentRef.class == annotation.annotationType())
/*     */           {
/* 164 */             paramResult = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
/*     */           }
/* 166 */           else if (XmlMimeType.class == annotation.annotationType())
/*     */           {
/* 168 */             XmlMimeType mimeTypeDecl = (XmlMimeType)method.getAnnotation(XmlMimeType.class);
/* 169 */             paramResult = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
/*     */           }
/*     */ 
/* 172 */           if (paramResult == null)
/*     */             continue;
/* 174 */           paramResult.setIndex(index);
/* 175 */           results.add(paramResult);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 181 */       index++;
/*     */     }
/*     */ 
/* 185 */     return results;
/*     */   }
/*     */ 
/*     */   public static AttachmentScanResult getResultByIndex(List<AttachmentScanResult> results, int index)
/*     */   {
/* 190 */     AttachmentScanResult result = null;
/*     */ 
/* 192 */     for (AttachmentScanResult asr : results)
/*     */     {
/* 194 */       if (asr.getIndex() == index)
/*     */       {
/* 196 */         result = asr;
/* 197 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 201 */     return result;
/*     */   }
/*     */ 
/*     */   private boolean alreadyScanned(Field field)
/*     */   {
/* 207 */     for (Field f : this.scannedFields)
/*     */     {
/* 209 */       if (f.equals(field)) {
/* 210 */         return true;
/*     */       }
/*     */     }
/* 213 */     return false;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 218 */     this.scannedFields.clear();
/*     */   }
/*     */ 
/*     */   private static boolean isAttachmentDataType(Class clazz) {
/* 222 */     for (Class cl : SUPPORTED_TYPES)
/*     */     {
/* 224 */       if (JavaUtils.isAssignableFrom(cl, clazz)) {
/* 225 */         return true;
/*     */       }
/*     */     }
/* 228 */     return false;
/*     */   }
/*     */ 
/*     */   private static boolean isJDKType(Class clazz)
/*     */   {
/* 233 */     return (clazz.getCanonicalName().startsWith("java")) || (clazz.isPrimitive());
/*     */   }
/*     */ 
/*     */   private static AttachmentScanResult scanGetterAnnotation(Class owner, Field field)
/*     */   {
/* 238 */     String getterMethodName = "get" + field.getName();
/* 239 */     for (Method method : owner.getDeclaredMethods())
/*     */     {
/* 241 */       if (!method.getName().equalsIgnoreCase(getterMethodName))
/*     */         continue;
/* 243 */       if (method.isAnnotationPresent(XmlMimeType.class))
/*     */       {
/* 245 */         XmlMimeType mimeTypeDecl = (XmlMimeType)method.getAnnotation(XmlMimeType.class);
/* 246 */         return new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
/*     */       }
/* 248 */       if (method.isAnnotationPresent(XmlAttachmentRef.class))
/*     */       {
/* 250 */         return new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 255 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  59 */     SUPPORTED_TYPES.add(String.class);
/*  60 */     SUPPORTED_TYPES.add([B.class);
/*  61 */     SUPPORTED_TYPES.add(Image.class);
/*  62 */     SUPPORTED_TYPES.add(Source.class);
/*  63 */     SUPPORTED_TYPES.add(DataHandler.class);
/*     */   }
/*     */ 
/*     */   public static enum ResultType
/*     */   {
/*  56 */     XOP, SWA_REF;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxws.ReflectiveAttachmentRefScanner
 * JD-Core Version:    0.6.0
 */