/*     */ package org.jboss.ws.extensions.xop.jaxrpc;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ 
/*     */ public class XOPScanner
/*     */ {
/*  58 */   private List<String> scannedItems = new ArrayList();
/*     */   private static final String BASE64_BINARY = "base64Binary";
/*     */ 
/*     */   public XSTypeDefinition findXOPTypeDef(XSTypeDefinition typeDef)
/*     */   {
/*  66 */     if (typeDef == null)
/*  67 */       return typeDef;
/*  68 */     XSTypeDefinition result = null;
/*  69 */     String name = typeDef.getName();
/*  70 */     String namespace = typeDef.getNamespace() != null ? typeDef.getNamespace() : "";
/*     */ 
/*  72 */     if (((typeDef instanceof XSSimpleTypeDefinition)) && ("base64Binary".equals(name)))
/*     */     {
/*  74 */       return typeDef;
/*     */     }
/*  76 */     if ((typeDef instanceof XSComplexTypeDefinition))
/*     */     {
/*  78 */       XSComplexTypeDefinition complexTypeDef = (XSComplexTypeDefinition)typeDef;
/*  79 */       if (name != null)
/*     */       {
/*  81 */         String typeKey = namespace + ":" + name;
/*     */ 
/*  83 */         if (this.scannedItems.contains(typeKey))
/*     */         {
/*  85 */           return null;
/*     */         }
/*     */ 
/*  89 */         this.scannedItems.add(typeKey);
/*     */       }
/*     */ 
/*  95 */       if (complexTypeDef.getSimpleType() != null)
/*     */       {
/*  97 */         String typeName = complexTypeDef.getSimpleType().getName();
/*  98 */         if ("base64Binary".equals(typeName)) {
/*  99 */           return complexTypeDef;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 104 */         XSModelGroup xm = null;
/* 105 */         if (complexTypeDef.getContentType() != 0)
/*     */         {
/* 107 */           XSParticle xp = complexTypeDef.getParticle();
/* 108 */           if (xp != null)
/*     */           {
/* 110 */             XSTerm xterm = xp.getTerm();
/* 111 */             if ((xterm instanceof XSModelGroup))
/*     */             {
/* 113 */               xm = (XSModelGroup)xterm;
/*     */ 
/* 116 */               XSObjectList xo = xm.getParticles();
/*     */ 
/* 119 */               for (int i = 0; i < xm.getParticles().getLength(); i++)
/*     */               {
/* 121 */                 XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
/*     */ 
/* 125 */                 if (!(xsterm instanceof XSElementDeclaration))
/*     */                   continue;
/* 127 */                 XSElementDeclaration xe = (XSElementDeclaration)xsterm;
/* 128 */                 XSTypeDefinition nestedTypeDef = xe.getTypeDefinition();
/*     */ 
/* 131 */                 result = findXOPTypeDef(nestedTypeDef);
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 144 */     return result;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 150 */     this.scannedItems.clear();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxrpc.XOPScanner
 * JD-Core Version:    0.6.0
 */