/*     */ package org.jboss.ws.extensions.xop.jaxrpc;
/*     */ 
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.attachment.CIDGenerator;
/*     */ import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPObject;
/*     */ 
/*     */ public class XOPMarshallerImpl
/*     */   implements XOPMarshaller
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(XOPMarshallerImpl.class);
/*     */ 
/*     */   public boolean isXOPPackage()
/*     */   {
/*  61 */     return XOPContext.isXOPMessage();
/*     */   }
/*     */ 
/*     */   public String addMtomAttachment(XOPObject obj, String elementNamespace, String elementName)
/*     */   {
/*  67 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  68 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*     */ 
/*  70 */     QName xmlName = new QName(elementNamespace, elementName);
/*  71 */     if (log.isDebugEnabled()) log.debug("serialize: [xmlName=" + xmlName + "]");
/*     */ 
/*  73 */     String cid = soapMessage.getCidGenerator().generateFromName(xmlName.getLocalPart());
/*     */ 
/*  75 */     DataHandler dataHandler = XOPContext.createDataHandler(obj);
/*  76 */     AttachmentPart xopPart = soapMessage.createAttachmentPart(dataHandler);
/*  77 */     xopPart.addMimeHeader("Content-Id", '<' + cid + '>');
/*  78 */     soapMessage.addAttachmentPart(xopPart);
/*     */ 
/*  80 */     if (log.isDebugEnabled()) log.debug("Created attachment part " + cid + ", with content-type " + xopPart.getContentType());
/*     */ 
/*  82 */     return "cid:" + cid;
/*     */   }
/*     */ 
/*     */   public String addMtomAttachment(byte[] data, String elementNamespace, String elementName)
/*     */   {
/*  97 */     throw new NotImplementedException("Not implemented yet");
/*     */   }
/*     */ 
/*     */   public String addSwaRefAttachment(Object obj)
/*     */   {
/* 102 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  56 */     ContentHandlerRegistry.register();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl
 * JD-Core Version:    0.6.0
 */