/*     */ package org.jboss.ws.extensions.xop;
/*     */ 
/*     */ import java.awt.Image;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.util.Iterator;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.transform.Source;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.NameImpl;
/*     */ import org.jboss.ws.core.soap.SOAPElementImpl;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.utils.MimeUtils;
/*     */ import org.jboss.ws.core.utils.MimeUtils.ByteArrayConverter;
/*     */ import org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPObject;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class XOPContext
/*     */ {
/*  72 */   private static final Logger log = Logger.getLogger(XOPContext.class);
/*     */   private static final String NS_XOP_JBOSSWS = "http://org.jboss.ws/xop";
/*     */ 
/*     */   public static boolean isXOPMessage()
/*     */   {
/*  82 */     boolean isXOP = false;
/*  83 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  84 */     if (msgContext != null)
/*     */     {
/*  86 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*  87 */       isXOP = (soapMessage != null) && (soapMessage.isXOPMessage());
/*     */     }
/*  89 */     return isXOP;
/*     */   }
/*     */ 
/*     */   public static boolean isSWARefMessage()
/*     */   {
/*  94 */     boolean isSWARef = false;
/*  95 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*  96 */     if (msgContext != null)
/*     */     {
/*  98 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*  99 */       isSWARef = (soapMessage != null) && (soapMessage.isSWARefMessage());
/*     */     }
/* 101 */     return isSWARef;
/*     */   }
/*     */ 
/*     */   public static boolean isXOPEncodedRequest()
/*     */   {
/* 109 */     boolean isMultippartXOP = false;
/* 110 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 111 */     if (msgContext != null)
/*     */     {
/* 113 */       MessageAbstraction message = msgContext.getMessageAbstraction();
/* 114 */       String[] contentType = message.getMimeHeaders().getHeader("content-type");
/* 115 */       if (contentType != null)
/*     */       {
/* 117 */         for (String value : contentType)
/*     */         {
/* 119 */           if (value.indexOf("application/xop+xml") == -1)
/*     */             continue;
/* 121 */           isMultippartXOP = true;
/* 122 */           break;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 128 */     return isMultippartXOP;
/*     */   }
/*     */ 
/*     */   public static boolean isMTOMEnabled()
/*     */   {
/* 140 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 141 */     Boolean mtomEnabled = (Boolean)msgContext.get("org.jboss.ws.mtom.enabled");
/* 142 */     return Boolean.TRUE.equals(mtomEnabled);
/*     */   }
/*     */ 
/*     */   public static void setMTOMEnabled(boolean b)
/*     */   {
/* 147 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 148 */     msgContext.put("org.jboss.ws.mtom.enabled", Boolean.valueOf(b));
/*     */   }
/*     */ 
/*     */   public static void inlineXOPData(SOAPElement xopElement)
/*     */   {
/* 158 */     String ns = xopElement.getNamespaceURI() != null ? xopElement.getNamespaceURI() : "";
/* 159 */     String localName = xopElement.getLocalName();
/*     */ 
/* 162 */     if ((ns.equals("http://www.w3.org/2004/08/xop/include")) && (localName.equals("Include")))
/*     */     {
/* 164 */       replaceXOPInclude(xopElement.getParentElement(), xopElement);
/*     */     }
/*     */     else
/*     */     {
/* 169 */       Iterator it = DOMUtils.getChildElements(xopElement);
/* 170 */       while (it.hasNext())
/*     */       {
/* 172 */         SOAPElement childElement = (SOAPElement)it.next();
/* 173 */         String childNS = childElement.getNamespaceURI() != null ? childElement.getNamespaceURI() : "";
/* 174 */         String childName = childElement.getLocalName();
/* 175 */         if ((childNS.equals("http://www.w3.org/2004/08/xop/include")) && (childName.equals("Include")))
/*     */         {
/* 177 */           replaceXOPInclude(xopElement, childElement);
/*     */         }
/*     */         else
/*     */         {
/* 181 */           inlineXOPData(childElement);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void setXOPMessage(boolean isXOPMessage)
/*     */   {
/* 195 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 196 */     SOAPMessageImpl soapMsg = (SOAPMessageImpl)msgContext.getSOAPMessage();
/* 197 */     soapMsg.setXOPMessage(isXOPMessage);
/*     */   }
/*     */ 
/*     */   public static void eagerlyCreateAttachments()
/*     */   {
/* 211 */     if ((!isXOPMessage()) && (!isSWARefMessage())) {
/* 212 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 216 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 217 */       SOAPMessage soapMessage = msgContext != null ? msgContext.getSOAPMessage() : null;
/* 218 */       SOAPBody body = soapMessage != null ? soapMessage.getSOAPBody() : null;
/*     */ 
/* 220 */       if (body != null)
/*     */       {
/* 222 */         CreateAttachmentVisitor visitor = new CreateAttachmentVisitor();
/* 223 */         visitor.visitXOPElements((SOAPElementImpl)body);
/*     */       }
/*     */     }
/*     */     catch (SOAPException e)
/*     */     {
/* 228 */       throw new WSException("Failed to eagerly create XOP attachments", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void visitAndRestoreXOPData()
/*     */   {
/*     */     try
/*     */     {
/* 239 */       if ((!isXOPMessage()) && (isMTOMEnabled()))
/*     */       {
/* 241 */         CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 242 */         SOAPBody body = msgContext.getSOAPMessage().getSOAPBody();
/* 243 */         RestoreXOPElementVisitor visitor = new RestoreXOPElementVisitor();
/* 244 */         visitor.visitXOPElements((SOAPElementImpl)body);
/*     */       }
/*     */     }
/*     */     catch (SOAPException e)
/*     */     {
/* 249 */       throw new WSException("Failed to restore XOP data", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void restoreXOPDataDOM(SOAPElement xopElement)
/*     */   {
/* 261 */     String contentType = xopElement.getAttributeNS("http://org.jboss.ws/xop", "content-type");
/* 262 */     if ((contentType != null) && (contentType.length() > 0))
/*     */     {
/* 264 */       replaceBase64Representation(xopElement, contentType);
/* 265 */       xopElement.removeAttribute(new NameImpl(new QName("http://org.jboss.ws/xop", "content-type")));
/*     */     }
/*     */     else
/*     */     {
/* 269 */       Iterator it = DOMUtils.getChildElements(xopElement);
/* 270 */       while (it.hasNext())
/*     */       {
/* 272 */         SOAPElement childElement = (SOAPElement)it.next();
/* 273 */         restoreXOPDataDOM(childElement);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void replaceBase64Representation(SOAPElement xopElement, String contentType)
/*     */   {
/* 281 */     SOAPElement parentElement = xopElement.getParentElement();
/* 282 */     if (log.isDebugEnabled()) {
/* 283 */       log.debug("Replace base64 representation on element [xmlName=" + parentElement.getLocalName() + "]");
/*     */     }
/* 285 */     String base64 = xopElement.getValue();
/* 286 */     byte[] data = SimpleTypeBindings.unmarshalBase64(base64);
/*     */ 
/* 288 */     MimeUtils.ByteArrayConverter converter = MimeUtils.getConverterForContentType(contentType);
/* 289 */     Object converted = converter.readFrom(new ByteArrayInputStream(data));
/*     */ 
/* 291 */     XOPObject xopObject = new XOPObject(converted);
/* 292 */     xopObject.setContentType(contentType);
/*     */ 
/* 294 */     XOPMarshaller xopMarshaller = new XOPMarshallerImpl();
/* 295 */     String cid = xopMarshaller.addMtomAttachment(xopObject, xopElement.getNamespaceURI(), xopElement.getLocalName());
/*     */ 
/* 298 */     Node child = xopElement.getFirstChild();
/* 299 */     xopElement.removeChild(child);
/*     */     try
/*     */     {
/* 303 */       SOAPElement xopInclude = xopElement.addChildElement(Constants.NAME_XOP_INCLUDE);
/* 304 */       xopInclude.setAttribute("href", cid);
/* 305 */       if (log.isDebugEnabled()) {
/* 306 */         log.debug("Restored xop:Include element on [xmlName=" + xopElement.getLocalName() + "]");
/*     */       }
/* 308 */       setXOPMessage(true);
/*     */     }
/*     */     catch (SOAPException e)
/*     */     {
/* 312 */       throw new WSException("Failed to create XOP include element", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void replaceXOPInclude(SOAPElement parent, SOAPElement xopIncludeElement)
/*     */   {
/* 320 */     if (log.isDebugEnabled()) {
/* 321 */       log.debug("Replace xop:Include on element [xmlName=" + parent.getLocalName() + "]");
/* 323 */     }String cid = xopIncludeElement.getAttribute("href");
/*     */     String contentType;
/*     */     byte[] data;
/*     */     try {
/* 329 */       AttachmentPart part = getAttachmentByCID(cid);
/* 330 */       DataHandler dh = part.getDataHandler();
/* 331 */       contentType = dh.getContentType();
/*     */ 
/* 334 */       ByteArrayOutputStream bout = new ByteArrayOutputStream();
/* 335 */       dh.writeTo(bout);
/* 336 */       data = bout.toByteArray();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 341 */       throw new WSException("Failed to inline XOP data", e);
/*     */     }
/*     */ 
/* 345 */     String base64 = SimpleTypeBindings.marshalBase64(data);
/* 346 */     parent.removeChild(xopIncludeElement);
/* 347 */     parent.setValue(base64);
/* 348 */     parent.setAttributeNS("http://org.jboss.ws/xop", "content-type", contentType);
/*     */ 
/* 350 */     if (log.isDebugEnabled()) {
/* 351 */       log.debug("Created base64 representation for content-type " + contentType);
/*     */     }
/*     */ 
/* 354 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 355 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*     */ 
/* 357 */     if (cid.startsWith("cid:"))
/* 358 */       cid = cid.substring(4);
/* 359 */     cid = '<' + cid + '>';
/*     */ 
/* 361 */     AttachmentPart removedPart = soapMessage.removeAttachmentByContentId(cid);
/* 362 */     if (null == removedPart) {
/* 363 */       throw new WSException("Unable to remove attachment part " + cid);
/*     */     }
/* 365 */     if (log.isDebugEnabled()) {
/* 366 */       log.debug("Removed attachment part " + cid);
/*     */     }
/*     */ 
/* 369 */     setXOPMessage(false);
/*     */   }
/*     */ 
/*     */   public static AttachmentPart getAttachmentByCID(String cid)
/*     */     throws SOAPException
/*     */   {
/* 378 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 379 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*     */ 
/* 382 */     if (cid.startsWith("cid:"))
/* 383 */       cid = cid.substring(4);
/* 384 */     cid = '<' + cid + '>';
/*     */ 
/* 386 */     AttachmentPart part = soapMessage.getAttachmentByContentId(cid);
/* 387 */     if (part == null) {
/* 388 */       throw new WSException("Cannot find attachment part for: " + cid);
/*     */     }
/* 390 */     return part;
/*     */   }
/*     */ 
/*     */   public static DataHandler createDataHandler(XOPObject xopObject)
/*     */   {
/* 400 */     Object o = xopObject.getContent();
/*     */     DataHandler dataHandler;
/*     */     DataHandler dataHandler;
/* 402 */     if ((o instanceof DataHandler))
/*     */     {
/* 404 */       dataHandler = (DataHandler)o;
/*     */     }
/*     */     else
/*     */     {
/*     */       DataHandler dataHandler;
/* 406 */       if (xopObject.getContentType() != null)
/*     */       {
/* 408 */         dataHandler = new DataHandler(o, xopObject.getContentType());
/*     */       }
/*     */       else
/*     */       {
/* 412 */         dataHandler = new DataHandler(o, getContentTypeForClazz(o.getClass()));
/*     */       }
/*     */     }
/* 415 */     return dataHandler;
/*     */   }
/*     */ 
/*     */   public static String getContentTypeForClazz(Class clazz)
/*     */   {
/* 420 */     if (JavaUtils.isAssignableFrom(Image.class, clazz))
/*     */     {
/* 422 */       return "image/jpeg";
/*     */     }
/* 424 */     if (JavaUtils.isAssignableFrom(Source.class, clazz))
/*     */     {
/* 426 */       return "application/xml";
/*     */     }
/* 428 */     if (JavaUtils.isAssignableFrom(String.class, clazz))
/*     */     {
/* 430 */       return "text/plain";
/*     */     }
/*     */ 
/* 434 */     return "application/octet-stream";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.XOPContext
 * JD-Core Version:    0.6.0
 */