/*     */ package org.jboss.ws.extensions.security.jaxrpc;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.handler.GenericHandler;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.extensions.security.Constants;
/*     */ import org.jboss.ws.extensions.security.WSSecurityDispatcher;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ 
/*     */ public abstract class WSSecurityHandler extends GenericHandler
/*     */ {
/*  53 */   private static Logger log = Logger.getLogger(WSSecurityHandler.class);
/*     */ 
/*     */   public QName[] getHeaders()
/*     */   {
/*  57 */     return new QName[] { Constants.WSSE_HEADER_QNAME };
/*     */   }
/*     */ 
/*     */   protected boolean handleInboundSecurity(MessageContext msgContext)
/*     */   {
/*     */     try
/*     */     {
/*  64 */       if (getSecurityConfiguration(msgContext) != null)
/*     */       {
/*  66 */         WSSecurityDispatcher.handleInbound((CommonMessageContext)msgContext);
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/*  71 */       log.error("Cannot handle inbound ws-security", ex);
/*  72 */       return false;
/*     */     }
/*  74 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean handleOutboundSecurity(MessageContext msgContext)
/*     */   {
/*     */     try
/*     */     {
/*  81 */       if (getSecurityConfiguration(msgContext) != null)
/*     */       {
/*  83 */         WSSecurityDispatcher.handleOutbound((CommonMessageContext)msgContext);
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/*  88 */       log.error("Cannot handle outbound ws-security", ex);
/*  89 */       return false;
/*     */     }
/*  91 */     return true;
/*     */   }
/*     */ 
/*     */   private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext)
/*     */   {
/* 100 */     EndpointMetaData epMetaData = ((CommonMessageContext)msgContext).getEndpointMetaData();
/* 101 */     ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/*     */ 
/* 103 */     WSSecurityConfiguration config = serviceMetaData.getSecurityConfiguration();
/* 104 */     if (config == null)
/*     */     {
/*     */       try
/*     */       {
/* 108 */         WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
/* 109 */         UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
/* 110 */         config = wsseConfFactory.createConfiguration(vfsRoot, getConfigResourceName());
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 114 */         throw new WSException("Cannot obtain security config: " + getConfigResourceName());
/*     */       }
/*     */ 
/* 118 */       serviceMetaData.setSecurityConfiguration(config);
/*     */     }
/*     */ 
/* 121 */     return config;
/*     */   }
/*     */ 
/*     */   protected abstract String getConfigResourceName();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.jaxrpc.WSSecurityHandler
 * JD-Core Version:    0.6.0
 */