/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.security.cert.CertificateEncodingException;
/*     */ import java.security.cert.CertificateFactory;
/*     */ import java.security.cert.X509Certificate;
/*     */ import org.apache.xml.security.utils.XMLUtils;
/*     */ import org.jboss.util.Base64;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class X509Token extends BinarySecurityToken
/*     */ {
/*     */   private X509Certificate cert;
/*     */   public static final String TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
/*     */ 
/*     */   public X509Token(X509Certificate cert, Document doc)
/*     */   {
/*  45 */     super(doc);
/*  46 */     this.cert = cert;
/*     */   }
/*     */ 
/*     */   public X509Token(Element element) throws WSSecurityException
/*     */   {
/*  51 */     super(element.getOwnerDocument());
/*     */ 
/*  53 */     String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
/*  54 */     if ((id == null) || (id.length() == 0)) {
/*  55 */       throw new WSSecurityException("Invalid message, BinarySecurityToken is missing an id");
/*     */     }
/*  57 */     setId(id);
/*     */ 
/*  59 */     if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(element.getAttribute("EncodingType"))) {
/*  60 */       throw new WSSecurityException("Invalid encoding type (only base64 is supported) for token:" + id);
/*     */     }
/*  62 */     setCert(decodeCert(XMLUtils.getFullTextChildrenFromElement(element)));
/*     */   }
/*     */ 
/*     */   public String getEncodingType()
/*     */   {
/*  68 */     return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
/*     */   }
/*     */ 
/*     */   public String getValueType()
/*     */   {
/*  74 */     return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
/*     */   }
/*     */ 
/*     */   public String getEncodedValue(boolean noWhitespace)
/*     */   {
/*     */     try
/*     */     {
/*  82 */       return Base64.encodeBytes(this.cert.getEncoded(), noWhitespace ? 8 : 0);
/*     */     }
/*     */     catch (CertificateEncodingException e) {
/*     */     }
/*  86 */     throw new RuntimeException("Could not encode X509 token", e);
/*     */   }
/*     */ 
/*     */   public X509Certificate getCert()
/*     */   {
/*  92 */     return this.cert;
/*     */   }
/*     */ 
/*     */   public void setCert(X509Certificate cert)
/*     */   {
/*  97 */     this.cert = cert;
/*     */   }
/*     */ 
/*     */   public X509Certificate decodeCert(String data) throws WSSecurityException
/*     */   {
/*     */     try
/*     */     {
/* 104 */       CertificateFactory factory = CertificateFactory.getInstance("X.509");
/* 105 */       return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode(data)));
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 109 */     throw new WSSecurityException("Error decoding BinarySecurityToken: " + e.getMessage());
/*     */   }
/*     */ 
/*     */   public Object getUniqueContent()
/*     */   {
/* 115 */     return this.cert;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.X509Token
 * JD-Core Version:    0.6.0
 */