/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import java.util.Calendar;
/*     */ import java.util.GregorianCalendar;
/*     */ import java.util.TimeZone;
/*     */ import org.apache.xml.security.utils.XMLUtils;
/*     */ import org.jboss.ws.extensions.security.Util;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class Timestamp
/*     */   implements SecurityElement
/*     */ {
/*  43 */   private String id = "timestamp";
/*     */   private Integer ttl;
/*     */   private Document doc;
/*     */   private Calendar created;
/*     */   private Calendar expires;
/*     */   private Element cachedElement;
/*     */ 
/*     */   public Timestamp(Integer ttl, Document doc)
/*     */   {
/*  57 */     this.doc = doc;
/*  58 */     this.ttl = ttl;
/*     */   }
/*     */ 
/*     */   public Timestamp(Element element) throws WSSecurityException
/*     */   {
/*  63 */     this.doc = element.getOwnerDocument();
/*  64 */     String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
/*  65 */     if ((id == null) || (id.length() == 0)) {
/*  66 */       throw new WSSecurityException("Invalid message, Timestamp is missing an id");
/*     */     }
/*  68 */     this.id = id;
/*     */ 
/*  70 */     Element child = Util.getFirstChildElement(element);
/*  71 */     if ((child == null) || (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(child.getNamespaceURI())) || (!"Created".equals(child.getLocalName()))) {
/*  72 */       throw new WSSecurityException("Created child expected in Timestamp element");
/*     */     }
/*  74 */     this.created = SimpleTypeBindings.unmarshalDateTime(XMLUtils.getFullTextChildrenFromElement(child));
/*     */ 
/*  76 */     child = Util.getNextSiblingElement(child);
/*  77 */     if (child == null) {
/*  78 */       return;
/*     */     }
/*  80 */     this.expires = SimpleTypeBindings.unmarshalDateTime(XMLUtils.getFullTextChildrenFromElement(child));
/*     */   }
/*     */ 
/*     */   private void setupTime()
/*     */   {
/*  85 */     this.created = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
/*  86 */     if (this.ttl != null)
/*     */     {
/*  88 */       this.expires = ((Calendar)this.created.clone());
/*  89 */       this.expires.add(13, this.ttl.intValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getId()
/*     */   {
/*  95 */     return this.id;
/*     */   }
/*     */ 
/*     */   public Calendar getCreated()
/*     */   {
/* 100 */     return this.created;
/*     */   }
/*     */ 
/*     */   public Calendar getExpires()
/*     */   {
/* 105 */     return this.expires;
/*     */   }
/*     */ 
/*     */   public Element getElement() throws WSSecurityException
/*     */   {
/* 110 */     if (this.cachedElement != null) {
/* 111 */       return this.cachedElement;
/*     */     }
/* 113 */     setupTime();
/*     */ 
/* 115 */     Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
/* 116 */     element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", getId());
/* 117 */     Element child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
/* 118 */     child.appendChild(this.doc.createTextNode(SimpleTypeBindings.marshalDateTime(this.created)));
/* 119 */     element.appendChild(child);
/*     */ 
/* 121 */     if (this.expires != null)
/*     */     {
/* 123 */       child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
/* 124 */       child.appendChild(this.doc.createTextNode(SimpleTypeBindings.marshalDateTime(this.expires)));
/* 125 */       element.appendChild(child);
/*     */     }
/*     */ 
/* 128 */     this.cachedElement = element;
/* 129 */     return this.cachedElement;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.Timestamp
 * JD-Core Version:    0.6.0
 */