/*    */ package org.jboss.ws.extensions.security.element;
/*    */ 
/*    */ import java.security.PublicKey;
/*    */ import org.apache.xml.security.exceptions.XMLSecurityException;
/*    */ import org.apache.xml.security.signature.XMLSignature;
/*    */ import org.jboss.ws.extensions.security.KeyResolver;
/*    */ import org.jboss.ws.extensions.security.WSSecurityException;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class Signature
/*    */   implements SecurityProcess
/*    */ {
/*    */   private XMLSignature signature;
/*    */   private PublicKey publicKey;
/*    */   private Element cachedElement;
/*    */ 
/*    */   public Signature(XMLSignature signature)
/*    */   {
/* 48 */     this.signature = signature;
/*    */   }
/*    */ 
/*    */   public Signature(Element element, KeyResolver resolver) throws WSSecurityException
/*    */   {
/*    */     try
/*    */     {
/* 55 */       this.signature = new XMLSignature(element, null);
/* 56 */       this.publicKey = resolver.resolvePublicKey(this.signature.getKeyInfo());
/*    */     }
/*    */     catch (XMLSecurityException e)
/*    */     {
/* 60 */       throw new WSSecurityException("Error decoding xml signature: " + e.getMessage(), e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public XMLSignature getSignature()
/*    */   {
/* 66 */     return this.signature;
/*    */   }
/*    */ 
/*    */   public void setSignature(XMLSignature signature)
/*    */   {
/* 71 */     this.signature = signature;
/*    */   }
/*    */ 
/*    */   public Element getElement()
/*    */   {
/* 76 */     if (this.cachedElement != null) {
/* 77 */       return this.cachedElement;
/*    */     }
/* 79 */     this.cachedElement = this.signature.getElement();
/* 80 */     return this.cachedElement;
/*    */   }
/*    */ 
/*    */   public PublicKey getPublicKey()
/*    */   {
/* 85 */     return this.publicKey;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.Signature
 * JD-Core Version:    0.6.0
 */