/*    */ package org.jboss.ws.extensions.security.element;
/*    */ 
/*    */ import org.jboss.ws.extensions.security.Util;
/*    */ import org.jboss.ws.extensions.security.WSSecurityException;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class SecurityTokenReference
/*    */ {
/*    */   private String id;
/*    */   private Reference reference;
/*    */   private Element cachedElement;
/*    */ 
/*    */   public SecurityTokenReference(Reference reference)
/*    */   {
/* 45 */     this.reference = reference;
/*    */   }
/*    */ 
/*    */   public SecurityTokenReference(Element element) throws WSSecurityException
/*    */   {
/* 50 */     if (!"SecurityTokenReference".equals(element.getLocalName())) {
/* 51 */       throw new WSSecurityException("SecurityTokenReference was passed an invalid local name");
/*    */     }
/* 53 */     String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
/* 54 */     if ((id == null) || (id.length() == 0)) {
/* 55 */       setId(id);
/*    */     }
/* 57 */     Element child = Util.getFirstChildElement(element);
/* 58 */     if (child == null) {
/* 59 */       throw new WSSecurityException("Invalid message, SecurityTokenRefence is empty: " + id);
/*    */     }
/* 61 */     this.reference = Reference.getReference(child);
/*    */   }
/*    */ 
/*    */   public Reference getReference()
/*    */   {
/* 66 */     return this.reference;
/*    */   }
/*    */ 
/*    */   public String getId()
/*    */   {
/* 71 */     if (this.id == null) {
/* 72 */       this.id = Util.generateId("reference");
/*    */     }
/* 74 */     return this.id;
/*    */   }
/*    */ 
/*    */   public void setId(String id)
/*    */   {
/* 79 */     this.id = id;
/*    */   }
/*    */ 
/*    */   public Element getElement() throws WSSecurityException
/*    */   {
/* 84 */     if (this.cachedElement != null) {
/* 85 */       return this.cachedElement;
/*    */     }
/* 87 */     Element referenceElement = this.reference.getElement();
/* 88 */     Document doc = referenceElement.getOwnerDocument();
/* 89 */     Element element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
/* 90 */     element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", getId());
/* 91 */     element.appendChild(referenceElement);
/*    */ 
/* 93 */     this.cachedElement = element;
/* 94 */     return this.cachedElement;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.SecurityTokenReference
 * JD-Core Version:    0.6.0
 */