/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedList;
/*     */ import org.jboss.ws.extensions.security.BinarySecurityTokenValidator;
/*     */ import org.jboss.ws.extensions.security.KeyResolver;
/*     */ import org.jboss.ws.extensions.security.SecurityStore;
/*     */ import org.jboss.ws.extensions.security.UnsupportedSecurityTokenException;
/*     */ import org.jboss.ws.extensions.security.Util;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SecurityHeader
/*     */   implements SecurityElement
/*     */ {
/*     */   private Document document;
/*     */   private Timestamp timestamp;
/*  51 */   private LinkedList<Token> tokens = new LinkedList();
/*     */ 
/*  53 */   private HashMap<Object, Token> sharedTokens = new HashMap();
/*     */ 
/*  55 */   private LinkedList<SecurityProcess> securityProcesses = new LinkedList();
/*     */ 
/*  58 */   private LinkedList<SecurityTokenReference> securityTokenReferences = new LinkedList();
/*     */ 
/*     */   public SecurityHeader(Document document)
/*     */   {
/*  62 */     this.document = document;
/*     */   }
/*     */ 
/*     */   public SecurityHeader(Element element, SecurityStore store) throws WSSecurityException
/*     */   {
/*  67 */     this.document = element.getOwnerDocument();
/*  68 */     KeyResolver resolver = new KeyResolver(store);
/*  69 */     BinarySecurityTokenValidator validator = new BinarySecurityTokenValidator(store);
/*  70 */     Element child = Util.getFirstChildElement(element);
/*  71 */     while (child != null)
/*     */     {
/*  73 */       String tag = child.getLocalName();
/*     */ 
/*  75 */       if (tag.equals("BinarySecurityToken"))
/*     */       {
/*  77 */         BinarySecurityToken token = BinarySecurityToken.createBinarySecurityToken(child);
/*  78 */         validator.validateToken(token);
/*  79 */         resolver.cacheToken(token);
/*  80 */         this.tokens.add(token);
/*     */       }
/*  82 */       else if (tag.equals("UsernameToken")) {
/*  83 */         this.tokens.add(new UsernameToken(child));
/*  84 */       } else if (tag.equals("Timestamp")) {
/*  85 */         this.timestamp = new Timestamp(child);
/*  86 */       } else if (tag.equals("Signature")) {
/*  87 */         this.securityProcesses.add(new Signature(child, resolver));
/*  88 */       } else if (tag.equals("EncryptedKey")) {
/*  89 */         this.securityProcesses.add(new EncryptedKey(child, resolver));
/*  90 */       } else if (tag.equals("ReferenceList")) {
/*  91 */         throw new UnsupportedSecurityTokenException("ReferenceLists outside of encrypted keys (shared secrets) are not supported.");
/*     */       }
/*  93 */       child = Util.getNextSiblingElement(child);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Timestamp getTimestamp()
/*     */   {
/*  99 */     return this.timestamp;
/*     */   }
/*     */ 
/*     */   public void setTimestamp(Timestamp timestamp)
/*     */   {
/* 104 */     this.timestamp = timestamp;
/*     */   }
/*     */ 
/*     */   public LinkedList getSecurityTokenReferences()
/*     */   {
/* 112 */     return this.securityTokenReferences;
/*     */   }
/*     */ 
/*     */   public void setSecurityTokenReferences(LinkedList<SecurityTokenReference> securityTokenReferences)
/*     */   {
/* 119 */     this.securityTokenReferences = securityTokenReferences;
/*     */   }
/*     */ 
/*     */   public LinkedList<SecurityProcess> getSecurityProcesses()
/*     */   {
/* 126 */     return this.securityProcesses;
/*     */   }
/*     */ 
/*     */   public void setSecurityProcesses(LinkedList<SecurityProcess> securityProcesses)
/*     */   {
/* 134 */     this.securityProcesses = securityProcesses;
/*     */   }
/*     */ 
/*     */   public LinkedList<Token> getTokens()
/*     */   {
/* 141 */     return this.tokens;
/*     */   }
/*     */ 
/*     */   public void addToken(Token token)
/*     */   {
/* 146 */     this.tokens.addFirst(token);
/* 147 */     Object content = token.getUniqueContent();
/* 148 */     if (content != null)
/* 149 */       this.sharedTokens.put(content, token);
/*     */   }
/*     */ 
/*     */   public Token getSharedToken(Object uniqueContent)
/*     */   {
/* 154 */     if (uniqueContent == null) {
/* 155 */       return null;
/*     */     }
/* 157 */     return (Token)this.sharedTokens.get(uniqueContent);
/*     */   }
/*     */ 
/*     */   public void addSecurityProcess(SecurityProcess process)
/*     */   {
/* 162 */     this.securityProcesses.addFirst(process);
/*     */   }
/*     */ 
/*     */   public void addSecurityTokenReference(SecurityTokenReference reference)
/*     */   {
/* 167 */     this.securityTokenReferences.addFirst(reference);
/*     */   }
/*     */ 
/*     */   public Element getElement() throws WSSecurityException
/*     */   {
/* 172 */     Element element = this.document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
/* 173 */     Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
/* 174 */     Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
/*     */ 
/* 176 */     if (this.timestamp != null) {
/* 177 */       element.appendChild(this.timestamp.getElement());
/*     */     }
/* 179 */     for (Token t : this.tokens) {
/* 180 */       element.appendChild(t.getElement());
/*     */     }
/* 182 */     for (SecurityTokenReference r : this.securityTokenReferences) {
/* 183 */       element.appendChild(r.getElement());
/*     */     }
/* 185 */     for (SecurityProcess p : this.securityProcesses) {
/* 186 */       element.appendChild(p.getElement());
/*     */     }
/* 188 */     return element;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.SecurityHeader
 * JD-Core Version:    0.6.0
 */