/*    */ package org.jboss.ws.extensions.security.element;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import java.util.LinkedList;
/*    */ import org.apache.xml.security.encryption.Reference;
/*    */ import org.jboss.ws.extensions.security.Util;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class ReferenceList
/*    */ {
/* 40 */   private LinkedList<String> references = new LinkedList();
/*    */ 
/*    */   public ReferenceList()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ReferenceList(Element element)
/*    */   {
/* 48 */     Element child = Util.getFirstChildElement(element);
/* 49 */     while (child != null)
/*    */     {
/* 52 */       if (("http://www.w3.org/2001/04/xmlenc#".equals(child.getNamespaceURI())) && ("DataReference".equals(child.getLocalName())))
/*    */       {
/* 55 */         String uri = child.getAttribute("URI");
/* 56 */         if ((uri != null) && (uri.length() > 1) && (uri.charAt(0) == '#')) {
/* 57 */           this.references.add(uri.substring(1));
/*    */         }
/*    */       }
/* 60 */       child = Util.getNextSiblingElement(child);
/*    */     }
/*    */   }
/*    */ 
/*    */   public ReferenceList(org.apache.xml.security.encryption.ReferenceList list)
/*    */   {
/* 66 */     Iterator i = list.getReferences();
/*    */ 
/* 68 */     while (i.hasNext())
/*    */     {
/* 70 */       Reference r = (Reference)i.next();
/* 71 */       this.references.add(r.getURI());
/*    */     }
/*    */   }
/*    */ 
/*    */   public void add(String id)
/*    */   {
/* 79 */     this.references.addFirst(id);
/*    */   }
/*    */ 
/*    */   public void populateRealReferenceList(org.apache.xml.security.encryption.ReferenceList list)
/*    */   {
/* 84 */     for (String i : this.references)
/*    */     {
/* 86 */       list.add(list.newDataReference("#" + i));
/*    */     }
/*    */   }
/*    */ 
/*    */   public Collection<String> getAllReferences()
/*    */   {
/* 92 */     return this.references;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.ReferenceList
 * JD-Core Version:    0.6.0
 */