/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import java.security.cert.X509Certificate;
/*     */ import org.apache.xml.security.exceptions.Base64DecodingException;
/*     */ import org.apache.xml.security.utils.Base64;
/*     */ import org.apache.xml.security.utils.XMLUtils;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class KeyIdentifier extends Reference
/*     */ {
/*     */   public static final String SKI_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
/*     */   private Document doc;
/*     */   private String value;
/*     */   private Element cachedElement;
/*     */ 
/*     */   public KeyIdentifier(Document doc, BinarySecurityToken token)
/*     */     throws WSSecurityException
/*     */   {
/*  59 */     this.doc = doc;
/*  60 */     referenceToken(token);
/*     */   }
/*     */ 
/*     */   public KeyIdentifier(Element element) throws WSSecurityException
/*     */   {
/*  65 */     this.doc = element.getOwnerDocument();
/*     */ 
/*  67 */     if (!"KeyIdentifier".equals(element.getLocalName())) {
/*  68 */       throw new WSSecurityException("Invalid message, invalid local name on a KeyIdentifier");
/*     */     }
/*  70 */     String valueType = element.getAttribute("ValueType");
/*  71 */     if ((valueType == null) || (valueType.length() == 0)) {
/*  72 */       throw new WSSecurityException("Inavliad message, KeyIdentifier element is missing an ValueType");
/*     */     }
/*  74 */     if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType)) {
/*  75 */       throw new WSSecurityException("Currently only SubjectKeyIdentifiers are supported, was passed: " + valueType);
/*     */     }
/*     */ 
/*  78 */     this.value = XMLUtils.getFullTextChildrenFromElement(element);
/*     */   }
/*     */ 
/*     */   public void referenceToken(BinarySecurityToken token) throws WSSecurityException
/*     */   {
/*  83 */     if (!(token instanceof X509Token)) {
/*  84 */       throw new WSSecurityException("KeyIdentifier tried to reference something besides an X509 token");
/*     */     }
/*  86 */     X509Token x509 = (X509Token)token;
/*  87 */     X509Certificate cert = x509.getCert();
/*     */ 
/*  90 */     byte[] encoded = cert.getExtensionValue("2.5.29.14");
/*  91 */     if (encoded == null) {
/*  92 */       throw new WSSecurityException("Certificate did not contain a subject key identifier!");
/*     */     }
/*     */ 
/*  95 */     int trunc = encoded.length - 4;
/*     */ 
/*  97 */     byte[] identifier = new byte[trunc];
/*  98 */     System.arraycopy(identifier, 4, encoded, 0, trunc);
/*     */ 
/* 100 */     this.value = Base64.encode(identifier);
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 105 */     return this.value;
/*     */   }
/*     */ 
/*     */   public String getValueType()
/*     */   {
/* 111 */     return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
/*     */   }
/*     */ 
/*     */   public Document getDocument()
/*     */   {
/* 116 */     return this.doc;
/*     */   }
/*     */ 
/*     */   public byte[] getIdentifier() throws WSSecurityException
/*     */   {
/* 121 */     if (this.value == null) {
/* 122 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 126 */       return Base64.decode(this.value);
/*     */     }
/*     */     catch (Base64DecodingException e) {
/*     */     }
/* 130 */     throw new WSSecurityException("Error decoding key identifier", e);
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/* 136 */     if (this.cachedElement != null) {
/* 137 */       return this.cachedElement;
/*     */     }
/* 139 */     Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
/* 140 */     element.setAttribute("ValueType", getValueType());
/* 141 */     element.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
/*     */ 
/* 143 */     this.cachedElement = element;
/* 144 */     return this.cachedElement;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.KeyIdentifier
 * JD-Core Version:    0.6.0
 */