/*    */ package org.jboss.ws.extensions.security.element;
/*    */ 
/*    */ import org.jboss.ws.extensions.security.Util;
/*    */ import org.jboss.ws.extensions.security.WSSecurityException;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public abstract class BinarySecurityToken
/*    */   implements Token
/*    */ {
/*    */   private Document doc;
/*    */   private String id;
/*    */   private Element cachedElement;
/*    */ 
/*    */   public static BinarySecurityToken createBinarySecurityToken(Element element)
/*    */     throws WSSecurityException
/*    */   {
/* 45 */     String valueType = element.getAttribute("ValueType");
/* 46 */     if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType)) {
/* 47 */       return new X509Token(element);
/*    */     }
/* 49 */     throw new WSSecurityException("Unkown Binary Security Token!!!");
/*    */   }
/*    */ 
/*    */   public BinarySecurityToken(Document doc)
/*    */   {
/* 54 */     this.doc = doc;
/*    */   }
/*    */   public abstract String getValueType();
/*    */ 
/*    */   public abstract String getEncodingType();
/*    */ 
/*    */   public abstract String getEncodedValue(boolean paramBoolean);
/*    */ 
/* 65 */   public String getId() { if (this.id == null) {
/* 66 */       this.id = Util.generateId("token");
/*    */     }
/* 68 */     return this.id;
/*    */   }
/*    */ 
/*    */   public void setId(String id)
/*    */   {
/* 73 */     this.id = id;
/*    */   }
/*    */ 
/*    */   public Element getElement()
/*    */   {
/* 78 */     if (this.cachedElement != null) {
/* 79 */       return this.cachedElement;
/*    */     }
/* 81 */     Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
/* 82 */     element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", getId());
/* 83 */     element.setAttribute("ValueType", getValueType());
/* 84 */     element.setAttribute("EncodingType", getEncodingType());
/* 85 */     element.appendChild(this.doc.createTextNode(getEncodedValue(false)));
/*    */ 
/* 87 */     this.cachedElement = element;
/* 88 */     return this.cachedElement;
/*    */   }
/*    */ 
/*    */   public Element getSTRTransformElement()
/*    */   {
/* 93 */     Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
/* 94 */     Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
/* 95 */     element.setAttribute("ValueType", getValueType());
/* 96 */     element.appendChild(this.doc.createTextNode(getEncodedValue(true)));
/*    */ 
/* 98 */     return element;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.BinarySecurityToken
 * JD-Core Version:    0.6.0
 */