/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.wsse.Config;
/*     */ import org.jboss.ws.metadata.wsse.Encrypt;
/*     */ import org.jboss.ws.metadata.wsse.Operation;
/*     */ import org.jboss.ws.metadata.wsse.Port;
/*     */ import org.jboss.ws.metadata.wsse.RequireEncryption;
/*     */ import org.jboss.ws.metadata.wsse.RequireSignature;
/*     */ import org.jboss.ws.metadata.wsse.RequireTimestamp;
/*     */ import org.jboss.ws.metadata.wsse.Requires;
/*     */ import org.jboss.ws.metadata.wsse.Sign;
/*     */ import org.jboss.ws.metadata.wsse.Timestamp;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class WSSecurityDispatcher
/*     */ {
/*  61 */   private static Logger log = Logger.getLogger(WSSecurityDispatcher.class);
/*     */ 
/*     */   private static List<Target> convertTargets(List<org.jboss.ws.metadata.wsse.Target> targets)
/*     */   {
/*  65 */     if (targets == null) {
/*  66 */       return null;
/*     */     }
/*  68 */     ArrayList newList = new ArrayList(targets.size());
/*     */ 
/*  70 */     for (org.jboss.ws.metadata.wsse.Target target : targets)
/*     */     {
/*  72 */       if ("qname".equals(target.getType()))
/*     */       {
/*  74 */         QNameTarget qnameTarget = new QNameTarget(QName.valueOf(target.getValue()), target.isContentOnly());
/*  75 */         newList.add(qnameTarget);
/*     */       }
/*  77 */       else if ("wsuid".equals(target.getType()))
/*     */       {
/*  79 */         newList.add(new WsuIdTarget(target.getValue()));
/*     */       }
/*     */     }
/*     */ 
/*  83 */     return newList;
/*     */   }
/*     */ 
/*     */   private static Config getConfig(WSSecurityConfiguration config, String portName, String opName)
/*     */   {
/*  88 */     Port port = (Port)config.getPorts().get(portName);
/*  89 */     if (port == null) {
/*  90 */       return config.getDefaultConfig();
/*     */     }
/*  92 */     Operation operation = (Operation)port.getOperations().get(opName);
/*  93 */     if (operation == null)
/*     */     {
/*  95 */       Config portConfig = port.getDefaultConfig();
/*  96 */       return portConfig == null ? config.getDefaultConfig() : portConfig;
/*     */     }
/*     */ 
/* 100 */     return operation.getConfig();
/*     */   }
/*     */ 
/*     */   private static CommonSOAPFaultException convertToFault(WSSecurityException e)
/*     */   {
/* 105 */     return new CommonSOAPFaultException(e.getFaultCode(), e.getFaultString());
/*     */   }
/*     */ 
/*     */   public static void handleInbound(CommonMessageContext ctx) throws SOAPException, SOAPFaultException
/*     */   {
/* 110 */     WSSecurityConfiguration config = getSecurityConfig(ctx);
/* 111 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
/*     */ 
/* 113 */     SOAPHeader soapHeader = soapMessage.getSOAPHeader();
/* 114 */     QName secQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
/* 115 */     Element secHeaderElement = Util.findElement(soapHeader, secQName);
/*     */ 
/* 117 */     if (secHeaderElement == null)
/*     */     {
/* 120 */       if (soapMessage.getSOAPBody().getFault() != null) {
/* 121 */         return;
/*     */       }
/* 123 */       OperationMetaData opMetaData = ctx.getOperationMetaData();
/* 124 */       if (opMetaData == null)
/*     */       {
/* 128 */         EndpointMetaData epMetaData = ctx.getEndpointMetaData();
/* 129 */         opMetaData = soapMessage.getOperationMetaData(epMetaData);
/*     */       }
/*     */ 
/* 132 */       String operation = opMetaData.getQName().toString();
/* 133 */       String port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
/*     */ 
/* 135 */       if (hasRequirements(config, operation, port)) {
/* 136 */         throw convertToFault(new InvalidSecurityHeaderException("This service requires <wsse:Security>, which is missing."));
/*     */       }
/* 138 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 143 */       SecurityStore securityStore = new SecurityStore(config.getKeyStoreURL(), config.getKeyStoreType(), config.getKeyStorePassword(), config.getKeyPasswords(), config.getTrustStoreURL(), config.getTrustStoreType(), config.getTrustStorePassword());
/*     */ 
/* 145 */       SecurityDecoder decoder = new SecurityDecoder(securityStore);
/*     */ 
/* 147 */       decoder.decode(soapMessage.getSOAPPart(), secHeaderElement);
/*     */ 
/* 149 */       if (log.isTraceEnabled()) {
/* 150 */         log.trace("Decoded Message:\n" + DOMWriter.printNode(soapMessage.getSOAPPart(), true));
/*     */       }
/* 152 */       OperationMetaData opMetaData = ctx.getOperationMetaData();
/* 153 */       if (opMetaData == null)
/*     */       {
/* 157 */         EndpointMetaData epMetaData = ctx.getEndpointMetaData();
/* 158 */         opMetaData = soapMessage.getOperationMetaData(epMetaData);
/*     */       }
/*     */ 
/* 161 */       String operation = opMetaData.getQName().toString();
/* 162 */       String port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
/*     */ 
/* 164 */       List operations = buildRequireOperations(config, operation, port);
/*     */ 
/* 166 */       decoder.verify(operations);
/* 167 */       if (log.isDebugEnabled()) log.debug("Verification is successful");
/*     */ 
/* 169 */       decoder.complete();
/*     */     }
/*     */     catch (WSSecurityException e)
/*     */     {
/* 173 */       if (e.isInternalError())
/* 174 */         log.error("Internal error occured handling inbound message:", e);
/* 175 */       else if (log.isDebugEnabled()) log.debug("Returning error to sender: " + e.getMessage());
/*     */ 
/* 177 */       throw convertToFault(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static WSSecurityConfiguration getSecurityConfig(CommonMessageContext ctx)
/*     */   {
/* 183 */     WSSecurityConfiguration config = ctx.getEndpointMetaData().getServiceMetaData().getSecurityConfiguration();
/* 184 */     if (config == null) {
/* 185 */       throw new WSException("Cannot obtain security configuration from message context");
/*     */     }
/* 187 */     return config;
/*     */   }
/*     */ 
/*     */   private static boolean hasRequirements(WSSecurityConfiguration config, String operation, String port)
/*     */   {
/* 192 */     Config operationConfig = getConfig(config, port, operation);
/* 193 */     return (operationConfig != null) && (operationConfig.getRequires() != null);
/*     */   }
/*     */ 
/*     */   private static List<OperationDescription<RequireOperation>> buildRequireOperations(WSSecurityConfiguration config, String operation, String port)
/*     */   {
/* 198 */     Config operationConfig = getConfig(config, port, operation);
/* 199 */     if (operationConfig == null) {
/* 200 */       return null;
/*     */     }
/* 202 */     Requires requires = operationConfig.getRequires();
/* 203 */     if (requires == null) {
/* 204 */       return null;
/*     */     }
/* 206 */     ArrayList operations = new ArrayList();
/* 207 */     RequireTimestamp requireTimestamp = requires.getRequireTimestamp();
/* 208 */     if (requireTimestamp != null) {
/* 209 */       operations.add(new OperationDescription(RequireTimestampOperation.class, null, requireTimestamp.getMaxAge(), null, null));
/*     */     }
/* 211 */     RequireSignature requireSignature = requires.getRequireSignature();
/* 212 */     if (requireSignature != null)
/*     */     {
/* 214 */       List targets = convertTargets(requireSignature.getTargets());
/* 215 */       operations.add(new OperationDescription(RequireSignatureOperation.class, targets, null, null, null));
/*     */     }
/*     */ 
/* 218 */     RequireEncryption requireEncryption = requires.getRequireEncryption();
/* 219 */     if (requireEncryption != null)
/*     */     {
/* 221 */       List targets = convertTargets(requireEncryption.getTargets());
/* 222 */       operations.add(new OperationDescription(RequireEncryptionOperation.class, targets, null, null, null));
/*     */     }
/*     */ 
/* 225 */     return operations;
/*     */   }
/*     */ 
/*     */   public static void handleOutbound(CommonMessageContext ctx) throws SOAPException, SOAPFaultException
/*     */   {
/* 230 */     WSSecurityConfiguration config = getSecurityConfig(ctx);
/* 231 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
/*     */ 
/* 233 */     EndpointMetaData epMetaData = ctx.getEndpointMetaData();
/* 234 */     String port = epMetaData.getPortName().getLocalPart();
/*     */ 
/* 236 */     String opName = null;
/* 237 */     OperationMetaData opMetaData = ctx.getOperationMetaData();
/* 238 */     if (opMetaData != null) {
/* 239 */       opName = opMetaData.getQName().toString();
/*     */     }
/* 241 */     Config opConfig = getConfig(config, port, opName);
/* 242 */     log.debug("WS-Security config: " + opConfig);
/*     */ 
/* 245 */     if (opConfig == null) {
/* 246 */       return;
/*     */     }
/* 248 */     ArrayList operations = new ArrayList();
/* 249 */     Timestamp timestamp = opConfig.getTimestamp();
/* 250 */     if (timestamp != null)
/*     */     {
/* 252 */       operations.add(new OperationDescription(TimestampOperation.class, null, null, timestamp.getTtl(), null));
/*     */     }
/*     */ 
/* 255 */     if (opConfig.getUsername() != null)
/*     */     {
/* 257 */       Object user = ctx.get("javax.xml.rpc.security.auth.username");
/* 258 */       Object pass = ctx.get("javax.xml.rpc.security.auth.password");
/*     */ 
/* 260 */       if ((user == null) && (pass == null))
/*     */       {
/* 262 */         user = ctx.get("javax.xml.ws.security.auth.username");
/* 263 */         pass = ctx.get("javax.xml.ws.security.auth.password");
/*     */       }
/*     */ 
/* 266 */       if ((user != null) && (pass != null))
/*     */       {
/* 268 */         operations.add(new OperationDescription(SendUsernameOperation.class, null, user.toString(), pass.toString(), null));
/* 269 */         ctx.put("org.jboss.ws.authType", "org.jboss.ws.authType.wsse");
/*     */       }
/*     */     }
/*     */ 
/* 273 */     Sign sign = opConfig.getSign();
/* 274 */     if (sign != null)
/*     */     {
/* 276 */       List targets = convertTargets(sign.getTargets());
/* 277 */       if (sign.isIncludeTimestamp())
/*     */       {
/* 279 */         if (timestamp == null) {
/* 280 */           operations.add(new OperationDescription(TimestampOperation.class, null, null, null, null));
/*     */         }
/* 282 */         if ((targets != null) && (targets.size() > 0)) {
/* 283 */           targets.add(new WsuIdTarget("timestamp"));
/*     */         }
/*     */       }
/* 286 */       operations.add(new OperationDescription(SignatureOperation.class, targets, sign.getAlias(), null, null));
/*     */     }
/*     */ 
/* 289 */     Encrypt encrypt = opConfig.getEncrypt();
/* 290 */     if (encrypt != null)
/*     */     {
/* 292 */       List targets = convertTargets(encrypt.getTargets());
/* 293 */       operations.add(new OperationDescription(EncryptionOperation.class, targets, encrypt.getAlias(), null, encrypt.getAlgorithm()));
/*     */     }
/*     */ 
/* 296 */     if (operations.size() == 0) {
/* 297 */       return;
/*     */     }
/* 299 */     if (log.isDebugEnabled()) log.debug("Encoding Message:\n" + DOMWriter.printNode(soapMessage.getSOAPPart(), true));
/*     */ 
/*     */     try
/*     */     {
/* 303 */       SecurityStore securityStore = new SecurityStore(config.getKeyStoreURL(), config.getKeyStoreType(), config.getKeyStorePassword(), config.getKeyPasswords(), config.getTrustStoreURL(), config.getTrustStoreType(), config.getTrustStorePassword());
/*     */ 
/* 305 */       SecurityEncoder encoder = new SecurityEncoder(operations, securityStore);
/* 306 */       encoder.encode(soapMessage.getSOAPPart());
/*     */     }
/*     */     catch (WSSecurityException e)
/*     */     {
/* 310 */       if (e.isInternalError())
/* 311 */         log.error("Internal error occured handling outbound message:", e);
/* 312 */       else if (log.isDebugEnabled()) log.debug("Returning error to sender: " + e.getMessage());
/*     */ 
/* 314 */       throw convertToFault(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.WSSecurityDispatcher
 * JD-Core Version:    0.6.0
 */