/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import org.apache.xml.security.exceptions.XMLSecurityException;
/*    */ import org.apache.xml.security.signature.Reference;
/*    */ import org.apache.xml.security.signature.SignedInfo;
/*    */ import org.apache.xml.security.signature.XMLSignature;
/*    */ import org.apache.xml.security.signature.XMLSignatureException;
/*    */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*    */ import org.jboss.ws.extensions.security.element.SecurityProcess;
/*    */ import org.jboss.ws.extensions.security.element.Signature;
/*    */ import org.w3c.dom.Document;
/*    */ 
/*    */ public class SignatureVerificationOperation
/*    */   implements DecodingOperation
/*    */ {
/*    */   private SecurityHeader header;
/*    */   private SecurityStore store;
/*    */ 
/*    */   public SignatureVerificationOperation(SecurityHeader header, SecurityStore store)
/*    */     throws WSSecurityException
/*    */   {
/* 44 */     this.header = header;
/* 45 */     this.store = store;
/*    */   }
/*    */ 
/*    */   public Collection<String> process(Document message, SecurityProcess process) throws WSSecurityException
/*    */   {
/* 50 */     Signature signature = (Signature)process;
/* 51 */     XMLSignature xmlSig = signature.getSignature();
/*    */ 
/* 53 */     xmlSig.addResourceResolver(new WsuIdResolver(message));
/* 54 */     STRTransform.setSecurityStore(this.store);
/*    */     try
/*    */     {
/* 58 */       if (!xmlSig.checkSignatureValue(signature.getPublicKey()))
/* 59 */         throw new FailedCheckException("Signature is invalid.");
/*    */     }
/*    */     catch (XMLSignatureException e)
/*    */     {
/* 63 */       throw new WSSecurityException("An unexpected error occured while verifying signature", e);
/*    */     }
/*    */     finally
/*    */     {
/* 67 */       STRTransform.setSecurityStore(null);
/*    */     }
/*    */ 
/* 70 */     SignedInfo info = xmlSig.getSignedInfo();
/* 71 */     int length = info.getLength();
/* 72 */     Collection processed = new ArrayList(length);
/*    */     try
/*    */     {
/* 75 */       for (int i = 0; i < length; i++)
/*    */       {
/* 77 */         String uri = info.item(i).getURI();
/* 78 */         if ((uri != null) && (uri.length() > 1) && (uri.charAt(0) == '#'))
/* 79 */           processed.add(uri.substring(1));
/*    */       }
/*    */     }
/*    */     catch (XMLSecurityException e)
/*    */     {
/* 84 */       throw new WSSecurityException("Could not extract references", e);
/*    */     }
/*    */ 
/* 87 */     return processed;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.SignatureVerificationOperation
 * JD-Core Version:    0.6.0
 */