/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.security.PrivateKey;
/*     */ import java.security.cert.X509Certificate;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xml.security.exceptions.XMLSecurityException;
/*     */ import org.apache.xml.security.keys.KeyInfo;
/*     */ import org.apache.xml.security.signature.XMLSignature;
/*     */ import org.apache.xml.security.signature.XMLSignatureException;
/*     */ import org.apache.xml.security.transforms.TransformationException;
/*     */ import org.apache.xml.security.transforms.Transforms;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.extensions.security.element.DirectReference;
/*     */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*     */ import org.jboss.ws.extensions.security.element.SecurityTokenReference;
/*     */ import org.jboss.ws.extensions.security.element.Signature;
/*     */ import org.jboss.ws.extensions.security.element.X509Token;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SignatureOperation
/*     */   implements EncodingOperation
/*     */ {
/*     */   private SecurityHeader header;
/*     */   private SecurityStore store;
/*     */ 
/*     */   public SignatureOperation(SecurityHeader header, SecurityStore store)
/*     */     throws WSSecurityException
/*     */   {
/*  54 */     this.header = header;
/*  55 */     this.store = store;
/*     */   }
/*     */ 
/*     */   private void processTarget(XMLSignature sig, Document message, Target target)
/*     */   {
/*  60 */     if ((target instanceof QNameTarget))
/*  61 */       processQNameTarget(sig, message, (QNameTarget)target);
/*  62 */     else if ((target instanceof WsuIdTarget))
/*  63 */       processWsuIdTarget(sig, message, (WsuIdTarget)target);
/*     */     else
/*  65 */       throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   private void processQNameTarget(XMLSignature sig, Document message, QNameTarget target)
/*     */   {
/*  70 */     QName name = target.getName();
/*     */ 
/*  72 */     Transforms transforms = new Transforms(message);
/*     */     try
/*     */     {
/*  75 */       transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
/*     */     }
/*     */     catch (TransformationException e)
/*     */     {
/*  79 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/*  82 */     Element element = Util.findElement(message.getDocumentElement(), name);
/*  83 */     if (element == null) {
/*  84 */       throw new RuntimeException("Could not find element");
/*     */     }
/*  86 */     String id = Util.assignWsuId(element);
/*     */     try
/*     */     {
/*  90 */       sig.addDocument("#" + id, transforms);
/*     */     }
/*     */     catch (XMLSignatureException e)
/*     */     {
/*  94 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processWsuIdTarget(XMLSignature sig, Document message, WsuIdTarget target)
/*     */   {
/* 100 */     String id = target.getId();
/*     */ 
/* 102 */     Transforms transforms = new Transforms(message);
/*     */     try
/*     */     {
/* 105 */       transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
/*     */     }
/*     */     catch (TransformationException e)
/*     */     {
/* 109 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 114 */       sig.addDocument("#" + id, transforms);
/*     */     }
/*     */     catch (XMLSignatureException e)
/*     */     {
/* 118 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void process(Document message, List<Target> targets, String alias, String credential, String algorithm) throws WSSecurityException {
/* 124 */     Element envelope = message.getDocumentElement();
/*     */     XMLSignature sig;
/*     */     try {
/* 128 */       sig = new XMLSignature(message, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
/*     */     }
/*     */     catch (XMLSecurityException e)
/*     */     {
/* 132 */       throw new WSSecurityException("Error building signature", e);
/*     */     }
/*     */ 
/* 137 */     sig.addResourceResolver(new WsuIdResolver(message, this.header.getElement()));
/* 138 */     PrivateKey key = this.store.getPrivateKey(alias);
/*     */ 
/* 140 */     if ((targets == null) || (targets.size() == 0))
/*     */     {
/* 143 */       String namespace = envelope.getNamespaceURI();
/* 144 */       processTarget(sig, message, new QNameTarget(new QName(namespace, "Body")));
/* 145 */       if (this.header.getTimestamp() != null)
/* 146 */         processTarget(sig, message, new WsuIdTarget("timestamp"));
/*     */     }
/*     */     else
/*     */     {
/* 150 */       for (Target target : targets) {
/* 151 */         processTarget(sig, message, target);
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 156 */       sig.sign(key);
/*     */     }
/*     */     catch (XMLSignatureException e)
/*     */     {
/* 160 */       throw new WSSecurityException("Error signing message: " + e.getMessage(), e);
/*     */     }
/*     */ 
/* 163 */     X509Certificate cert = this.store.getCertificate(alias);
/* 164 */     X509Token token = (X509Token)this.header.getSharedToken(cert);
/*     */ 
/* 167 */     if (token == null)
/*     */     {
/* 169 */       token = new X509Token(cert, message);
/* 170 */       this.header.addToken(token);
/*     */     }
/*     */ 
/* 173 */     SecurityTokenReference reference = new SecurityTokenReference(new DirectReference(message, token));
/* 174 */     sig.getKeyInfo().addUnknownElement(reference.getElement());
/*     */ 
/* 176 */     this.header.addSecurityProcess(new Signature(sig));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.SignatureOperation
 * JD-Core Version:    0.6.0
 */