/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.List;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class RequireTargetableOperation
/*    */   implements RequireOperation
/*    */ {
/*    */   public RequireTargetableOperation(SecurityHeader header, SecurityStore store)
/*    */     throws WSSecurityException
/*    */   {
/*    */   }
/*    */ 
/*    */   private Collection<String> resolveTarget(Document message, Target target)
/*    */     throws WSSecurityException
/*    */   {
/* 42 */     if ((target instanceof QNameTarget))
/* 43 */       return resolveQNameTarget(message, (QNameTarget)target);
/* 44 */     if ((target instanceof WsuIdTarget))
/*    */     {
/* 46 */       Collection result = new ArrayList(1);
/* 47 */       result.add(((WsuIdTarget)target).getId());
/* 48 */       return result;
/*    */     }
/*    */ 
/* 51 */     throw new WSSecurityException("Unknown target");
/*    */   }
/*    */ 
/*    */   private Collection<String> resolveQNameTarget(Document message, QNameTarget target) throws WSSecurityException
/*    */   {
/* 56 */     QName name = target.getName();
/*    */ 
/* 58 */     Element element = Util.findElement(message.getDocumentElement(), name);
/* 59 */     if (element == null) {
/* 60 */       throw new FailedCheckException("Required QName was not present: " + name);
/*    */     }
/* 62 */     String id = Util.getWsuId(element);
/*    */ 
/* 64 */     if (id == null) {
/* 65 */       throw new FailedCheckException("Required element did not contain a wsu:id.");
/*    */     }
/* 67 */     Collection result = new ArrayList(1);
/* 68 */     result.add(id);
/*    */ 
/* 70 */     return result;
/*    */   }
/*    */ 
/*    */   public void process(Document message, List<Target> targets, String alias, String credential, Collection<String> processedIds) throws WSSecurityException
/*    */   {
/* 75 */     if ((targets == null) || (targets.size() == 0))
/*    */     {
/* 78 */       String namespace = message.getDocumentElement().getNamespaceURI();
/* 79 */       targets = new ArrayList(1);
/* 80 */       targets.add(new QNameTarget(new QName(namespace, "Body"), true));
/*    */     }
/*    */ 
/* 83 */     for (Target target : targets)
/*    */     {
/* 85 */       Collection ids = resolveTarget(message, target);
/* 86 */       if (!processedIds.containsAll(ids))
/* 87 */         throw new FailedCheckException("Required elements for encryption and or signing are not all present.");
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.RequireTargetableOperation
 * JD-Core Version:    0.6.0
 */