/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import javax.crypto.SecretKey;
/*     */ import org.apache.xml.security.encryption.XMLCipher;
/*     */ import org.apache.xml.security.encryption.XMLEncryptionException;
/*     */ import org.jboss.ws.extensions.security.element.EncryptedKey;
/*     */ import org.jboss.ws.extensions.security.element.ReferenceList;
/*     */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*     */ import org.jboss.ws.extensions.security.element.SecurityProcess;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class DecryptionOperation
/*     */   implements DecodingOperation
/*     */ {
/*     */   private SecurityHeader header;
/*     */   private SecurityStore store;
/*     */ 
/*     */   public DecryptionOperation(SecurityHeader header, SecurityStore store)
/*     */     throws WSSecurityException
/*     */   {
/*  47 */     this.header = header;
/*  48 */     this.store = store;
/*     */   }
/*     */ 
/*     */   private boolean isContent(Element element)
/*     */   {
/*  53 */     return "http://www.w3.org/2001/04/xmlenc#Content".equals(element.getAttribute("Type"));
/*     */   }
/*     */ 
/*     */   private String getEncryptionAlgorithm(Element element) throws WSSecurityException
/*     */   {
/*  58 */     element = Util.findElement(element, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
/*  59 */     if (element == null) {
/*  60 */       throw new InvalidSecurityHeaderException("Encrypted element corrupted, no encryption method");
/*     */     }
/*  62 */     String alg = element.getAttribute("Algorithm");
/*  63 */     if ((alg == null) || (alg.length() == 0)) {
/*  64 */       throw new InvalidSecurityHeaderException("Encrypted element corrupted, no algorithm specified");
/*     */     }
/*  66 */     return alg;
/*     */   }
/*     */ 
/*     */   private String decryptElement(Element element, SecretKey key)
/*     */     throws WSSecurityException
/*     */   {
/*     */     boolean isContent;
/*  80 */     boolean parent = isContent = isContent(element);
/*     */     Element previous;
/*     */     Element previous;
/*  81 */     if (parent)
/*     */     {
/*  83 */       previous = (Element)element.getParentNode();
/*     */     }
/*     */     else
/*     */     {
/*  87 */       previous = Util.getPreviousSiblingElement(element);
/*  88 */       if (previous == null)
/*     */       {
/*  90 */         parent = true;
/*  91 */         previous = (Element)element.getParentNode();
/*     */       }
/*     */     }
/*     */ 
/*  95 */     String alg = getEncryptionAlgorithm(element);
/*     */     try
/*     */     {
/*  98 */       XMLCipher cipher = XMLCipher.getInstance(alg);
/*  99 */       cipher.init(2, key);
/* 100 */       cipher.doFinal(element.getOwnerDocument(), element);
/*     */     }
/*     */     catch (XMLEncryptionException e)
/*     */     {
/* 104 */       throw new FailedCheckException("Decryption was invalid.");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 108 */       throw new WSSecurityException("Could not decrypt element: " + e.getMessage(), e);
/*     */     }
/*     */ 
/* 111 */     if (isContent) {
/* 112 */       return Util.getWsuId(previous);
/*     */     }
/* 114 */     Element decrypted = parent ? Util.getFirstChildElement(previous) : Util.getNextSiblingElement(previous);
/* 115 */     if (decrypted == null) {
/* 116 */       return null;
/*     */     }
/* 118 */     return Util.getWsuId(decrypted);
/*     */   }
/*     */ 
/*     */   private boolean isEncryptedData(Element element)
/*     */   {
/* 123 */     return ("EncryptedData".equals(element.getLocalName())) && ("http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI()));
/*     */   }
/*     */ 
/*     */   public Collection<String> process(Document message, SecurityProcess process) throws WSSecurityException
/*     */   {
/* 128 */     Collection ids = new HashSet();
/* 129 */     EncryptedKey key = (EncryptedKey)process;
/* 130 */     ReferenceList list = key.getReferenceList();
/* 131 */     for (String uri : list.getAllReferences())
/*     */     {
/* 133 */       Element element = Util.findElementByWsuId(message.getDocumentElement(), uri);
/* 134 */       if (element == null) {
/* 135 */         throw new WSSecurityException("A reference list refered to an element that was not found: " + uri);
/*     */       }
/* 137 */       if (!isEncryptedData(element)) {
/* 138 */         throw new WSSecurityException("Malformed reference list, a non encrypted data element was referenced: " + uri);
/*     */       }
/* 140 */       ids.add(decryptElement(element, key.getSecretKey()));
/*     */     }
/*     */ 
/* 143 */     return ids;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.DecryptionOperation
 * JD-Core Version:    0.6.0
 */