/*     */ package org.jboss.ws.extensions.policy.metadata;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ import org.apache.ws.policy.PolicyReference;
/*     */ import org.apache.ws.policy.util.DOMPolicyReader;
/*     */ import org.apache.ws.policy.util.PolicyFactory;
/*     */ import org.apache.ws.policy.util.PolicyRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.policy.PolicyScopeLevel;
/*     */ import org.jboss.ws.extensions.policy.annotation.PolicyAttachment;
/*     */ import org.jboss.ws.extensions.policy.deployer.PolicyDeployer;
/*     */ import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedPolicy;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ 
/*     */ public class PolicyMetaDataBuilder
/*     */ {
/*  61 */   private static final Logger log = Logger.getLogger(PolicyMetaDataBuilder.class);
/*  62 */   private boolean serverSide = true;
/*  63 */   private boolean toolMode = false;
/*     */   private PolicyDeployer customDeployer;
/*     */ 
/*     */   public PolicyMetaDataBuilder()
/*     */   {
/*     */   }
/*     */ 
/*     */   public PolicyMetaDataBuilder(PolicyDeployer customDeployer)
/*     */   {
/*  78 */     this.customDeployer = customDeployer;
/*     */   }
/*     */ 
/*     */   public static PolicyMetaDataBuilder getServerSidePolicyMetaDataBuilder(boolean toolMode)
/*     */   {
/*  89 */     PolicyMetaDataBuilder builder = new PolicyMetaDataBuilder();
/*  90 */     builder.setServerSide(true);
/*  91 */     builder.setToolMode(toolMode);
/*  92 */     return builder;
/*     */   }
/*     */ 
/*     */   public static PolicyMetaDataBuilder getClientSidePolicyMetaDataBuilder()
/*     */   {
/* 102 */     PolicyMetaDataBuilder builder = new PolicyMetaDataBuilder();
/* 103 */     builder.setServerSide(false);
/* 104 */     return builder;
/*     */   }
/*     */ 
/*     */   public void processPolicyAnnotations(EndpointMetaData epMetaData, Class<?> sepClass)
/*     */   {
/* 109 */     UnifiedVirtualFile vfRoot = epMetaData.getServiceMetaData().getUnifiedMetaData().getRootFile();
/* 110 */     for (org.jboss.ws.extensions.policy.annotation.Policy anPolicy : ((PolicyAttachment)sepClass.getAnnotation(PolicyAttachment.class)).value())
/*     */     {
/* 112 */       InputStream is = null;
/*     */       try
/*     */       {
/* 115 */         String policyFileLocation = anPolicy.policyFileLocation();
/* 116 */         if (policyFileLocation.length() == 0) {
/* 117 */           throw new IllegalStateException("Cannot obtain @Policy.policyFileLocation");
/*     */         }
/*     */ 
/* 121 */         UnifiedVirtualFile vfPolicyFile = vfRoot.findChild(policyFileLocation);
/* 122 */         is = vfPolicyFile.toURL().openStream();
/*     */ 
/* 124 */         DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader(3);
/* 125 */         org.apache.ws.policy.Policy unnormalizedPolicy = reader.readPolicy(is);
/* 126 */         org.apache.ws.policy.Policy normPolicy = (org.apache.ws.policy.Policy)unnormalizedPolicy.normalize();
/* 127 */         log.info("Deploying Annotated Policy = " + policyFileLocation);
/* 128 */         PolicyScopeLevel scope = anPolicy.scope();
/* 129 */         if ((PolicyScopeLevel.WSDL_PORT.equals(scope)) || (PolicyScopeLevel.WSDL_PORT_TYPE.equals(scope)) || (PolicyScopeLevel.WSDL_BINDING.equals(scope)))
/*     */         {
/* 131 */           deployPolicy(normPolicy, scope, epMetaData);
/*     */         }
/*     */         else
/*     */         {
/* 135 */           throw new WSException("Policy scope " + scope + " not supported yet!");
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 140 */         log.error(e);
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 146 */           is.close();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void processPolicyExtensions(EndpointMetaData epMetaData, WSDLDefinitions wsdlDefinitions)
/*     */   {
/* 158 */     DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader(3);
/* 159 */     PolicyRegistry localPolicyRegistry = new PolicyRegistry();
/* 160 */     for (WSDLExtensibilityElement policyElement : wsdlDefinitions.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policy"))
/*     */     {
/* 162 */       org.apache.ws.policy.Policy policy = reader.readPolicy(policyElement.getElement());
/* 163 */       localPolicyRegistry.register(policy.getPolicyURI(), policy);
/*     */     }
/*     */ 
/* 166 */     WSDLService wsdlService = wsdlDefinitions.getService(epMetaData.getServiceMetaData().getServiceName());
/* 167 */     if (wsdlService != null)
/*     */     {
/* 169 */       WSDLEndpoint wsdlEndpoint = wsdlService.getEndpoint(epMetaData.getPortName());
/* 170 */       if (wsdlEndpoint != null)
/*     */       {
/* 172 */         List portPolicyRefList = wsdlEndpoint.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policyReference");
/* 173 */         processPolicies(portPolicyRefList, PolicyScopeLevel.WSDL_PORT, localPolicyRegistry, epMetaData);
/*     */       }
/*     */       else
/*     */       {
/* 177 */         log.warn("Cannot get port '" + epMetaData.getPortName() + "' from the given wsdl definitions! Eventual policies attached to this port won't be considered.");
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 184 */       log.warn("Cannot get service '" + epMetaData.getServiceMetaData().getServiceName() + "' from the given wsdl definitions!  Eventual policies attached to this service won't be considered.");
/*     */     }
/*     */ 
/* 189 */     WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(epMetaData.getPortTypeName());
/* 190 */     if (wsdlBinding != null)
/*     */     {
/* 192 */       List bindingPolicyRefList = wsdlBinding.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policyReference");
/* 193 */       processPolicies(bindingPolicyRefList, PolicyScopeLevel.WSDL_BINDING, localPolicyRegistry, epMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 197 */       log.warn("Cannot get binding for portType '" + epMetaData.getPortTypeName() + "' from the given wsdl definitions!  Eventual policies attached to this binding won't be considered.");
/*     */     }
/*     */ 
/* 202 */     WSDLInterface wsdlInterface = wsdlDefinitions.getInterface(epMetaData.getPortTypeName());
/* 203 */     if (wsdlInterface != null)
/*     */     {
/* 205 */       WSDLProperty portTypePolicyProp = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
/* 206 */       processPolicies(portTypePolicyProp, PolicyScopeLevel.WSDL_PORT_TYPE, localPolicyRegistry, epMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 210 */       log.warn("Cannot get portType '" + epMetaData.getPortTypeName() + "' from the given wsdl definitions! Eventual policies attached to this portType won't be considered.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processPolicies(WSDLProperty policyProp, PolicyScopeLevel scope, PolicyRegistry localPolicies, ExtensibleMetaData extMetaData)
/*     */   {
/* 217 */     if ((policyProp != null) && (policyProp.getValue() != null))
/*     */     {
/* 219 */       StringTokenizer st = new StringTokenizer(policyProp.getValue(), ", ", false);
/* 220 */       while (st.hasMoreTokens())
/*     */       {
/* 222 */         PolicyReference policyRef = new PolicyReference(st.nextToken());
/* 223 */         deployPolicy(resolvePolicyReference(policyRef, localPolicies), scope, extMetaData);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processPolicies(List<WSDLExtensibilityElement> policyReferences, PolicyScopeLevel scope, PolicyRegistry localPolicies, ExtensibleMetaData extMetaData)
/*     */   {
/*     */     DOMPolicyReader reader;
/* 230 */     if ((policyReferences != null) && (policyReferences.size() != 0))
/*     */     {
/* 232 */       reader = (DOMPolicyReader)PolicyFactory.getPolicyReader(3);
/* 233 */       for (WSDLExtensibilityElement element : policyReferences)
/*     */       {
/* 235 */         PolicyReference policyRef = reader.readPolicyReference(element.getElement());
/* 236 */         deployPolicy(resolvePolicyReference(policyRef, localPolicies), scope, extMetaData);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private org.apache.ws.policy.Policy resolvePolicyReference(PolicyReference policyRef, PolicyRegistry localPolicies)
/*     */   {
/*     */     org.apache.ws.policy.Policy normPolicy;
/*     */     try {
/* 246 */       normPolicy = (org.apache.ws.policy.Policy)policyRef.normalize(localPolicies);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 251 */       normPolicy = null;
/*     */     }
/* 253 */     return normPolicy;
/*     */   }
/*     */ 
/*     */   private void deployPolicy(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData)
/*     */   {
/*     */     PolicyDeployer deployer;
/*     */     PolicyDeployer deployer;
/* 259 */     if (this.customDeployer != null)
/*     */     {
/* 261 */       deployer = this.customDeployer;
/*     */     }
/*     */     else
/*     */     {
/*     */       PolicyDeployer deployer;
/* 263 */       if (this.toolMode)
/*     */       {
/* 265 */         deployer = PolicyDeployer.newInstanceForTools();
/*     */       }
/*     */       else
/*     */       {
/* 269 */         deployer = PolicyDeployer.getInstance();
/*     */       }
/*     */     }
/* 271 */     if (this.serverSide)
/*     */     {
/* 273 */       deployPolicyServerSide(policy, scope, extMetaData, deployer);
/*     */     }
/*     */     else
/*     */     {
/* 277 */       deployPolicyClientSide(policy, scope, extMetaData, deployer);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deployPolicyServerSide(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData, PolicyDeployer deployer)
/*     */   {
/* 283 */     PolicyMetaExtension ext = (PolicyMetaExtension)extMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
/* 284 */     if (ext == null)
/*     */     {
/* 286 */       ext = new PolicyMetaExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
/* 287 */       extMetaData.addExtension(ext);
/*     */     }
/*     */     try
/*     */     {
/* 291 */       org.apache.ws.policy.Policy deployedPolicy = deployer.deployServerside(policy, extMetaData);
/* 292 */       ext.addPolicy(scope, deployedPolicy);
/*     */     }
/*     */     catch (UnsupportedPolicy e)
/*     */     {
/* 296 */       log.warn("Policy Not supported:" + policy.getPolicyURI());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deployPolicyClientSide(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData, PolicyDeployer deployer)
/*     */   {
/* 302 */     PolicyMetaExtension ext = (PolicyMetaExtension)extMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
/* 303 */     if (ext == null)
/*     */     {
/* 305 */       ext = new PolicyMetaExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
/* 306 */       extMetaData.addExtension(ext);
/*     */     }
/*     */     try
/*     */     {
/* 310 */       deployer.deployClientSide(policy, extMetaData);
/* 311 */       ext.addPolicy(scope, policy);
/*     */     }
/*     */     catch (UnsupportedPolicy e)
/*     */     {
/* 315 */       if (log.isDebugEnabled())
/*     */       {
/* 317 */         log.debug("Policy Not supported:" + policy.getPolicyURI());
/*     */       }
/* 319 */       WSException.rethrow("Policy not supported! " + policy.getPolicyURI(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isServerSide()
/*     */   {
/* 325 */     return this.serverSide;
/*     */   }
/*     */ 
/*     */   public void setServerSide(boolean serverSide)
/*     */   {
/* 330 */     this.serverSide = serverSide;
/*     */   }
/*     */ 
/*     */   public boolean isToolMode()
/*     */   {
/* 335 */     return this.toolMode;
/*     */   }
/*     */ 
/*     */   public void setToolMode(boolean toolMode)
/*     */   {
/* 340 */     this.toolMode = toolMode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.metadata.PolicyMetaDataBuilder
 * JD-Core Version:    0.6.0
 */