/*     */ package org.jboss.ws.extensions.policy.deployer.util;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.stream.XMLOutputFactory;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import javax.xml.stream.XMLStreamWriter;
/*     */ import org.apache.ws.policy.Assertion;
/*     */ import org.apache.ws.policy.PrimitiveAssertion;
/*     */ 
/*     */ public class PrimitiveAssertionWriter
/*     */ {
/*  45 */   private int num = 1;
/*     */ 
/*     */   public static PrimitiveAssertionWriter newInstance()
/*     */   {
/*  53 */     return new PrimitiveAssertionWriter();
/*     */   }
/*     */ 
/*     */   public void writePrimitiveAssertion(PrimitiveAssertion assertion, ByteArrayOutputStream stream) throws XMLStreamException
/*     */   {
/*  58 */     XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream);
/*  59 */     writePrimitiveAssertion(assertion, writer);
/*     */   }
/*     */ 
/*     */   public void writePrimitiveAssertion(PrimitiveAssertion assertion, XMLStreamWriter writer)
/*     */     throws XMLStreamException
/*     */   {
/*  65 */     QName qname = assertion.getName();
/*     */ 
/*  67 */     String writerPrefix = writer.getPrefix(qname.getNamespaceURI());
/*  68 */     if (writerPrefix != null)
/*     */     {
/*  70 */       writer.writeStartElement(qname.getNamespaceURI(), qname.getLocalPart());
/*     */     }
/*     */     else
/*     */     {
/*  74 */       String prefix = qname.getPrefix() != null ? qname.getPrefix() : generateNamespace();
/*  75 */       writer.writeStartElement(prefix, qname.getLocalPart(), qname.getNamespaceURI());
/*  76 */       writer.writeNamespace(prefix, qname.getNamespaceURI());
/*  77 */       writer.setPrefix(prefix, qname.getNamespaceURI());
/*     */     }
/*     */ 
/*  81 */     Hashtable attributes = assertion.getAttributes();
/*  82 */     writeAttributes(attributes, writer);
/*     */ 
/*  84 */     String text = assertion.getStrValue();
/*  85 */     if (text != null)
/*     */     {
/*  87 */       writer.writeCharacters(text);
/*     */     }
/*     */ 
/*  91 */     List terms = assertion.getTerms();
/*  92 */     writeTerms(terms, writer);
/*     */ 
/*  94 */     writer.writeEndElement();
/*  95 */     writer.flush();
/*     */   }
/*     */ 
/*     */   private void writeTerms(List terms, XMLStreamWriter writer)
/*     */     throws XMLStreamException
/*     */   {
/* 101 */     Iterator iterator = terms.iterator();
/* 102 */     while (iterator.hasNext())
/*     */     {
/* 104 */       Assertion assertion = (Assertion)iterator.next();
/* 105 */       writePrimitiveAssertion((PrimitiveAssertion)assertion, writer);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeAttributes(Hashtable attributes, XMLStreamWriter writer)
/*     */     throws XMLStreamException
/*     */   {
/* 112 */     Iterator iterator = attributes.keySet().iterator();
/* 113 */     while (iterator.hasNext())
/*     */     {
/* 115 */       QName qname = (QName)iterator.next();
/* 116 */       String value = (String)attributes.get(qname);
/*     */ 
/* 118 */       String prefix = qname.getPrefix();
/* 119 */       if (prefix != null)
/*     */       {
/* 121 */         writer.writeAttribute(prefix, qname.getNamespaceURI(), qname.getLocalPart(), value);
/*     */       }
/*     */       else
/*     */       {
/* 125 */         writer.writeAttribute(qname.getNamespaceURI(), qname.getLocalPart(), value);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String generateNamespace()
/*     */   {
/* 132 */     return "ns" + this.num++;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.deployer.util.PrimitiveAssertionWriter
 * JD-Core Version:    0.6.0
 */