/*     */ package org.jboss.ws.extensions.eventing.mgmt;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ 
/*     */ class EventSource
/*     */   implements Serializable
/*     */ {
/*     */   private State state;
/*  43 */   private long maxExpirationTime = -1L;
/*     */   private String name;
/*     */   private URI nameSpace;
/*     */   private URI managerAddress;
/*  49 */   private List<URI> supportedFilter = new ArrayList();
/*     */   private String[] notificationSchema;
/*     */   private String notificationRootElementNS;
/*     */ 
/*     */   public EventSource(String name, URI nameSpace)
/*     */   {
/*  55 */     this.name = name;
/*  56 */     this.nameSpace = nameSpace;
/*  57 */     this.state = State.CREATED;
/*     */   }
/*     */ 
/*     */   public EventSource(String name, URI nameSpace, String[] schema, String notificationRootElementNS)
/*     */   {
/*  62 */     this.name = name;
/*  63 */     this.nameSpace = nameSpace;
/*  64 */     this.notificationSchema = schema;
/*  65 */     this.notificationRootElementNS = notificationRootElementNS;
/*  66 */     this.state = State.CREATED;
/*     */   }
/*     */ 
/*     */   State getState()
/*     */   {
/*  71 */     return this.state;
/*     */   }
/*     */ 
/*     */   void setState(State state)
/*     */   {
/*  76 */     if (state == State.STARTED)
/*     */     {
/*  78 */       assertConfiguration();
/*     */     }
/*  80 */     this.state = state;
/*     */   }
/*     */ 
/*     */   private void assertConfiguration() {
/*  84 */     if (getManagerAddress() == null)
/*  85 */       throw new IllegalArgumentException("SubscriptionManager address unknown. Unable to start event source.");
/*     */   }
/*     */ 
/*     */   long getMaxExpirationTime()
/*     */   {
/*  90 */     return this.maxExpirationTime;
/*     */   }
/*     */ 
/*     */   void setMaxExpirationTime(long maxExpirationTime)
/*     */   {
/*  95 */     this.maxExpirationTime = maxExpirationTime;
/*     */   }
/*     */ 
/*     */   public List<URI> getSupportedFilterDialects()
/*     */   {
/* 100 */     return this.supportedFilter;
/*     */   }
/*     */ 
/*     */   public String[] getNotificationSchema() {
/* 104 */     return this.notificationSchema;
/*     */   }
/*     */ 
/*     */   public String getName() {
/* 108 */     return this.name;
/*     */   }
/*     */ 
/*     */   public URI getNameSpace() {
/* 112 */     return this.nameSpace;
/*     */   }
/*     */ 
/*     */   public URI getManagerAddress() {
/* 116 */     return this.managerAddress;
/*     */   }
/*     */ 
/*     */   public String getNotificationRootElementNS() {
/* 120 */     return this.notificationRootElementNS;
/*     */   }
/*     */ 
/*     */   public void setManagerAddress(String managerAddress)
/*     */   {
/*     */     try {
/* 126 */       if (managerAddress != null)
/* 127 */         this.managerAddress = new URI(managerAddress);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 131 */       throw new IllegalArgumentException("Illegal subscription manager endpoint address: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 136 */     return "EventSource {nameSpace=" + this.nameSpace + ", state=" + this.state + "}";
/*     */   }
/*     */ 
/*     */   static enum State
/*     */   {
/*  39 */     CREATED, STARTED, STOPPED, DESTROYED;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.mgmt.EventSource
 * JD-Core Version:    0.6.0
 */