/*    */ package org.jboss.ws.extensions.eventing.mgmt;
/*    */ 
/*    */ import java.net.URI;
/*    */ import java.util.List;
/*    */ import java.util.concurrent.ConcurrentMap;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public final class DispatchJob
/*    */   implements Runnable
/*    */ {
/*    */   public Element event;
/*    */   public URI eventSourceNS;
/*    */   public ConcurrentMap<URI, List<Subscription>> mapping;
/*    */ 
/*    */   public DispatchJob(URI eventSourceNS, Element event, ConcurrentMap<URI, List<Subscription>> mapping)
/*    */   {
/* 43 */     this.event = event;
/* 44 */     this.eventSourceNS = eventSourceNS;
/* 45 */     this.mapping = mapping;
/*    */   }
/*    */ 
/*    */   public void run()
/*    */   {
/* 50 */     List subscriptions = (List)this.mapping.get(this.eventSourceNS);
/* 51 */     for (Subscription s : subscriptions)
/*    */     {
/* 53 */       if ((s.accepts(this.event)) && (!s.isExpired()))
/* 54 */         s.notify(this.event);
/*    */     }
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 60 */     return "DispatchJob {source=" + this.eventSourceNS + ", event=" + this.event + "}";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.mgmt.DispatchJob
 * JD-Core Version:    0.6.0
 */