/*     */ package org.jboss.ws.extensions.eventing.jaxws;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.Date;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.jws.WebMethod;
/*     */ import javax.jws.WebParam;
/*     */ import javax.jws.WebResult;
/*     */ import javax.jws.WebService;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import javax.xml.ws.addressing.Action;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.ReferenceParameters;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.annotation.EndpointConfig;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.extensions.eventing.common.EventingEndpointBase;
/*     */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionError;
/*     */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @WebService(name="SubscriptionManager", portName="SubscriptionManagerPort", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", wsdlLocation="/WEB-INF/wsdl/wind.wsdl")
/*     */ @EndpointConfig(configName="Standard WSAddressing Endpoint")
/*     */ public abstract class AbstractSubscriptionManagerEndpoint extends EventingEndpointBase
/*     */   implements SubscriptionManagerEndpoint
/*     */ {
/*  63 */   public static final QName IDQN = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier", "ns1");
/*     */ 
/*     */   @WebMethod(operationName="GetStatusOp")
/*     */   @WebResult(name="GetStatusResponse", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body")
/*     */   @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse")
/*     */   public GetStatusResponse getStatusOp(@WebParam(name="GetStatus", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") GetStatus body)
/*     */   {
/*  73 */     URI identifier = retrieveSubscriptionId();
/*     */ 
/*  75 */     getLogger().debug("GetStatus request for subscriptionID: " + identifier);
/*     */     try
/*     */     {
/*  79 */       Date leaseTime = getSubscriptionManager().getStatus(identifier);
/*  80 */       GetStatusResponse response = new GetStatusResponse();
/*  81 */       response.setExpires(leaseTime);
/*     */ 
/*  83 */       return response;
/*     */     }
/*     */     catch (SubscriptionError e) {
/*     */     }
/*  87 */     throw new SOAPFaultException(buildFaultQName(e.getSubcode()), e.getReason(), null, null);
/*     */   }
/*     */ 
/*     */   @WebMethod(operationName="RenewOp")
/*     */   @WebResult(name="RenewResponse", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body")
/*     */   @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse")
/*     */   public RenewResponse renewOp(@WebParam(name="Renew", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") Renew request)
/*     */   {
/*  99 */     URI identifier = retrieveSubscriptionId();
/*     */ 
/* 101 */     getLogger().debug("Renew request for subscriptionID: " + identifier);
/*     */     try
/*     */     {
/* 105 */       Date newLeaseTime = getSubscriptionManager().renew(identifier, request.getExpires());
/* 106 */       RenewResponse response = new RenewResponse();
/* 107 */       response.setExpires(newLeaseTime);
/*     */ 
/* 109 */       return response;
/*     */     }
/*     */     catch (SubscriptionError e) {
/*     */     }
/* 113 */     throw new SOAPFaultException(buildFaultQName(e.getSubcode()), e.getReason(), null, null);
/*     */   }
/*     */ 
/*     */   @WebMethod(operationName="UnsubscribeOp")
/*     */   @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse")
/*     */   public void unsubscribeOp(@WebParam(name="Unsubscribe", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") Unsubscribe body)
/*     */   {
/* 124 */     URI identifier = retrieveSubscriptionId();
/*     */ 
/* 126 */     getLogger().debug("Unsubscribe request for subscriptionID: " + identifier);
/*     */     try
/*     */     {
/* 130 */       getSubscriptionManager().unsubscribe(identifier);
/*     */     }
/*     */     catch (SubscriptionError e)
/*     */     {
/* 134 */       throw new SOAPFaultException(buildFaultQName(e.getSubcode()), e.getReason(), null, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private URI retrieveSubscriptionId()
/*     */   {
/* 141 */     URI subscriptionId = null;
/* 142 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 143 */     AddressingProperties addrProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
/*     */ 
/* 145 */     if (null == addrProps)
/*     */     {
/* 147 */       throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed: Cannot obtain addressing properties.", null, null);
/*     */     }
/*     */ 
/* 155 */     ReferenceParameters refParams = addrProps.getReferenceParameters();
/*     */     Iterator i$;
/* 156 */     if (refParams != null)
/*     */     {
/* 158 */       for (i$ = refParams.getElements().iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 160 */         if ((obj instanceof Element))
/*     */         {
/* 162 */           Element el = (Element)obj;
/* 163 */           QName qname = DOMUtils.getElementQName(el);
/* 164 */           if (qname.equals(IDQN))
/*     */           {
/*     */             try
/*     */             {
/* 168 */               subscriptionId = new URI(DOMUtils.getTextContent(el));
/*     */             }
/*     */             catch (URISyntaxException e)
/*     */             {
/* 173 */               throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed: Invalid subscription id.", null, null);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 185 */     if (null == subscriptionId)
/*     */     {
/* 187 */       throw new SOAPFaultException(buildFaultQName("InvalidMessage"), "The message is not valid and cannot be processed: Cannot obtain subscription id.", null, null);
/*     */     }
/*     */ 
/* 195 */     return subscriptionId;
/*     */   }
/*     */ 
/*     */   protected abstract Logger getLogger();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.jaxws.AbstractSubscriptionManagerEndpoint
 * JD-Core Version:    0.6.0
 */