/*     */ package org.jboss.ws.extensions.eventing.jaxws;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.List;
/*     */ import javax.jws.WebMethod;
/*     */ import javax.jws.WebParam;
/*     */ import javax.jws.WebResult;
/*     */ import javax.jws.WebService;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import javax.xml.ws.addressing.Action;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.annotation.EndpointConfig;
/*     */ import org.jboss.ws.extensions.eventing.common.EventingEndpointBase;
/*     */ import org.jboss.ws.extensions.eventing.mgmt.Filter;
/*     */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionError;
/*     */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
/*     */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionTicket;
/*     */ 
/*     */ @WebService(name="EventSource", portName="EventSourcePort", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", wsdlLocation="/WEB-INF/wsdl/wind.wsdl")
/*     */ @EndpointConfig(configName="Standard WSAddressing Endpoint")
/*     */ public abstract class AbstractEventSourceEndpoint extends EventingEndpointBase
/*     */   implements EventSourceEndpoint
/*     */ {
/*     */   @WebMethod(operationName="SubscribeOp")
/*     */   @WebResult(name="SubscribeResponse", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body")
/*     */   @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse")
/*     */   public SubscribeResponse subscribeOp(@WebParam(name="Subscribe", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") Subscribe request)
/*     */   {
/*     */     try
/*     */     {
/*  69 */       AddressingProperties inProps = getAddrProperties();
/*  70 */       AttributedURI eventSourceURI = inProps.getTo();
/*  71 */       getLogger().debug("Subscribe request for event source: " + eventSourceURI.getURI());
/*     */ 
/*  73 */       assertSubscriberEndpoints(request);
/*  74 */       EndpointReferenceType notifyTo = request.getDelivery().getNotifyTo();
/*  75 */       EndpointReferenceType endTo = request.getEndTo();
/*     */ 
/*  78 */       Filter filter = null;
/*  79 */       if (request.getFilter() != null) {
/*     */         try
/*     */         {
/*  82 */           filter = new Filter(new URI(request.getFilter().getDialect()), (String)request.getFilter().getContent().get(0));
/*     */         }
/*     */         catch (URISyntaxException e)
/*     */         {
/*  86 */           throw new WSException(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*  91 */       SubscriptionManagerMBean subscriptionManager = getSubscriptionManager();
/*  92 */       SubscriptionTicket ticket = subscriptionManager.subscribe(eventSourceURI.getURI(), notifyTo, endTo, request.getExpires(), filter);
/*     */ 
/* 100 */       SubscribeResponse res = new SubscribeResponse();
/* 101 */       res.setExpires(ticket.getExpires());
/* 102 */       res.setSubscriptionManager(ticket.getSubscriptionManager());
/*     */ 
/* 104 */       return res;
/*     */     }
/*     */     catch (SubscriptionError e)
/*     */     {
/*     */     }
/* 109 */     throw new SOAPFaultException(buildFaultQName(e.getSubcode()), e.getReason(), null, null);
/*     */   }
/*     */ 
/*     */   private void assertSubscriberEndpoints(Subscribe request)
/*     */   {
/* 119 */     if ((null == request.getDelivery().getNotifyTo()) || (null == request.getEndTo()))
/* 120 */       throw new SOAPFaultException(buildFaultQName("InvalidMessage"), "Subcriber endpoint information missing from request", null, null);
/*     */   }
/*     */ 
/*     */   protected abstract Logger getLogger();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.jaxws.AbstractEventSourceEndpoint
 * JD-Core Version:    0.6.0
 */