/*    */ package org.jboss.ws.extensions.eventing.common;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.rpc.soap.SOAPFaultException;
/*    */ import javax.xml.ws.addressing.AddressingBuilder;
/*    */ import javax.xml.ws.addressing.AddressingProperties;
/*    */ import org.jboss.ws.Constants;
/*    */ import org.jboss.ws.core.CommonMessageContext;
/*    */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*    */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerFactory;
/*    */ import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
/*    */ 
/*    */ public abstract class EventingEndpointBase
/*    */ {
/*    */   private AddressingBuilder addrBuilder;
/*    */ 
/*    */   protected static AddressingProperties getAddrProperties()
/*    */   {
/* 55 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 56 */     AddressingProperties inProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
/* 57 */     assertAddrProperties(inProps);
/* 58 */     return inProps;
/*    */   }
/*    */ 
/*    */   protected SubscriptionManagerMBean getSubscriptionManager()
/*    */   {
/* 66 */     SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
/* 67 */     SubscriptionManagerMBean subscriptionManager = factory.getSubscriptionManager();
/* 68 */     return subscriptionManager;
/*    */   }
/*    */ 
/*    */   protected AddressingBuilder getAddrBuilder()
/*    */   {
/* 73 */     if (null == this.addrBuilder)
/* 74 */       this.addrBuilder = AddressingBuilder.getAddressingBuilder();
/* 75 */     return this.addrBuilder;
/*    */   }
/*    */ 
/*    */   protected static void assertAddrProperties(AddressingProperties inProps)
/*    */     throws SOAPFaultException
/*    */   {
/* 85 */     if (null == inProps)
/* 86 */       throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "Addressing headers missing from request", "wse:InvalidMessage", null);
/* 87 */     if (null == inProps.getTo())
/* 88 */       throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "Event source URI missing from request (wsa:To)", "wse:InvalidMessage", null);
/*    */   }
/*    */ 
/*    */   public QName buildFaultQName(String elementName)
/*    */   {
/* 93 */     return new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", elementName, "wse");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.common.EventingEndpointBase
 * JD-Core Version:    0.6.0
 */