/*     */ package org.jboss.ws.extensions.addressing.soap;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFactory;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPHeaderElement;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.addressing.AddressingConstants;
/*     */ import javax.xml.ws.addressing.AddressingException;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import javax.xml.ws.addressing.ReferenceParameters;
/*     */ import javax.xml.ws.addressing.Relationship;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
/*     */ import org.jboss.ws.core.soap.NameImpl;
/*     */ import org.jboss.ws.core.soap.SOAPFactoryImpl;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
/*     */ import org.jboss.ws.extensions.addressing.EndpointReferenceImpl;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ 
/*     */ public class SOAPAddressingPropertiesImpl extends AddressingPropertiesImpl
/*     */   implements SOAPAddressingProperties
/*     */ {
/*  62 */   private static AddressingConstants ADDR = new AddressingConstantsImpl();
/*     */ 
/*  64 */   private NamespaceRegistry nsRegistry = new NamespaceRegistry();
/*     */   private boolean mustunderstand;
/*     */ 
/*     */   private String getRequiredHeaderContent(SOAPHeader soapHeader, QName qname)
/*     */   {
/*  70 */     Element element = DOMUtils.getFirstChildElement(soapHeader, qname);
/*  71 */     if (null == element) throw new AddressingException("Required element " + qname + " is missing");
/*     */ 
/*  73 */     String value = DOMUtils.getTextContent(element);
/*  74 */     if ((null == value) || (value.equals(""))) throw new AddressingException("Required element " + qname + " is missing");
/*     */ 
/*  76 */     return value;
/*     */   }
/*     */ 
/*     */   private String getOptionalHeaderContent(SOAPHeader soapHeader, QName qname)
/*     */   {
/*  81 */     Element element = DOMUtils.getFirstChildElement(soapHeader, qname);
/*  82 */     if (element != null)
/*     */     {
/*  84 */       return DOMUtils.getTextContent(element);
/*     */     }
/*     */ 
/*  87 */     return null;
/*     */   }
/*     */ 
/*     */   public void readHeaders(SOAPMessage message) throws AddressingException
/*     */   {
/*     */     try
/*     */     {
/*  94 */       SOAPHeader soapHeader = message.getSOAPHeader();
/*     */ 
/*  96 */       SOAPAddressingBuilder builder = new SOAPAddressingBuilderImpl();
/*  97 */       AddressingConstants ADDR = builder.newAddressingConstants();
/*  98 */       registerNamespaces(ADDR, soapHeader);
/*     */ 
/* 104 */       String to = getOptionalHeaderContent(soapHeader, ADDR.getToQName());
/* 105 */       if (to != null) {
/* 106 */         setTo(builder.newURI(to));
/*     */       }
/*     */ 
/* 110 */       Element wsaFrom = DOMUtils.getFirstChildElement(soapHeader, ADDR.getFromQName());
/* 111 */       if (wsaFrom != null)
/*     */       {
/* 113 */         EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaFrom);
/* 114 */         setReplyTo(ref);
/*     */       }
/*     */ 
/* 121 */       Element wsaReplyTo = DOMUtils.getFirstChildElement(soapHeader, ADDR.getReplyToQName());
/* 122 */       if (wsaReplyTo != null)
/*     */       {
/* 124 */         EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaReplyTo);
/* 125 */         setReplyTo(ref);
/*     */       }
/*     */ 
/* 131 */       Element wsaFaultTo = DOMUtils.getFirstChildElement(soapHeader, ADDR.getFaultToQName());
/* 132 */       if (wsaFaultTo != null)
/*     */       {
/* 134 */         EndpointReferenceImpl ref = new EndpointReferenceImpl(wsaFaultTo);
/* 135 */         setFaultTo(ref);
/*     */       }
/*     */ 
/* 141 */       String action = getRequiredHeaderContent(soapHeader, ADDR.getActionQName());
/* 142 */       setAction(builder.newURI(action));
/*     */ 
/* 146 */       String messageID = getOptionalHeaderContent(soapHeader, ADDR.getMessageIDQName());
/* 147 */       if (messageID != null) setMessageID(builder.newURI(messageID));
/*     */ 
/* 152 */       Iterator itRelatesTo = DOMUtils.getChildElements(soapHeader, ADDR.getRelatesToQName());
/* 153 */       List relList = new ArrayList();
/* 154 */       while (itRelatesTo.hasNext())
/*     */       {
/* 156 */         Element wsaRelatesTo = (Element)itRelatesTo.next();
/* 157 */         QName type = DOMUtils.getAttributeValueAsQName(wsaRelatesTo, ADDR.getRelationshipTypeName());
/* 158 */         String uri = DOMUtils.getTextContent(wsaRelatesTo);
/* 159 */         Relationship rel = builder.newRelationship(new URI(uri));
/* 160 */         rel.setType(type);
/* 161 */         relList.add(rel);
/*     */       }
/* 163 */       Relationship[] relArr = (Relationship[])(Relationship[])Array.newInstance(Relationship.class, relList.size());
/* 164 */       relList.toArray(relArr);
/* 165 */       setRelatesTo(relArr);
/*     */ 
/* 168 */       QName refQName = new QName(getNamespaceURI(), "IsReferenceParameter");
/* 169 */       ReferenceParameters refParams = getReferenceParameters();
/* 170 */       Iterator it = soapHeader.examineAllHeaderElements();
/* 171 */       while (it.hasNext())
/*     */       {
/* 173 */         SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
/* 174 */         if ("true".equals(DOMUtils.getAttributeValue(headerElement, refQName)))
/*     */         {
/* 176 */           refParams.addElement(headerElement);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 182 */       throw new AddressingException("Cannot read headers", ex);
/*     */     }
/*     */     catch (URISyntaxException ex)
/*     */     {
/* 186 */       throw new AddressingException("Cannot read headers", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void registerNamespaces(AddressingConstants ADDR, SOAPHeader soapHeader)
/*     */   {
/* 193 */     this.nsRegistry.registerURI(ADDR.getNamespaceURI(), ADDR.getNamespacePrefix());
/*     */ 
/* 196 */     NamedNodeMap attribs = soapHeader.getAttributes();
/* 197 */     for (int i = 0; i < attribs.getLength(); i++)
/*     */     {
/* 199 */       Attr attr = (Attr)attribs.item(i);
/* 200 */       String attrName = attr.getName();
/* 201 */       String attrValue = attr.getValue();
/* 202 */       if (!attrName.startsWith("xmlns:"))
/*     */         continue;
/* 204 */       String prefix = attrName.substring(6);
/* 205 */       this.nsRegistry.registerURI(attrValue, prefix);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeHeaders(SOAPMessage message)
/*     */     throws AddressingException
/*     */   {
/*     */     try
/*     */     {
/* 214 */       SOAPFactoryImpl factory = (SOAPFactoryImpl)SOAPFactory.newInstance();
/* 215 */       SOAPHeader soapHeader = message.getSOAPHeader();
/*     */ 
/* 218 */       soapHeader.addNamespaceDeclaration(ADDR.getNamespacePrefix(), ADDR.getNamespaceURI());
/*     */ 
/* 221 */       if (getTo() != null)
/*     */       {
/* 223 */         SOAPElement element = soapHeader.addChildElement(new NameImpl(ADDR.getToQName()));
/* 224 */         element.addTextNode(getTo().getURI().toString());
/*     */       }
/*     */ 
/* 228 */       if (getFrom() != null)
/*     */       {
/* 230 */         EndpointReferenceImpl epr = (EndpointReferenceImpl)getFrom();
/* 231 */         epr.setRootQName(ADDR.getFromQName());
/* 232 */         SOAPElement soapElement = factory.createElement(epr.toElement());
/* 233 */         soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
/* 234 */         soapHeader.addChildElement(soapElement);
/*     */       }
/*     */ 
/* 238 */       if (getReplyTo() != null)
/*     */       {
/* 240 */         EndpointReferenceImpl epr = (EndpointReferenceImpl)getReplyTo();
/* 241 */         epr.setRootQName(ADDR.getReplyToQName());
/* 242 */         SOAPElement soapElement = factory.createElement(epr.toElement());
/* 243 */         soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
/* 244 */         soapHeader.addChildElement(soapElement);
/*     */       }
/*     */ 
/* 248 */       if (getFaultTo() != null)
/*     */       {
/* 250 */         EndpointReferenceImpl epr = (EndpointReferenceImpl)getFaultTo();
/* 251 */         epr.setRootQName(ADDR.getFaultToQName());
/* 252 */         SOAPElement soapElement = factory.createElement(epr.toElement());
/* 253 */         soapElement.removeNamespaceDeclaration(ADDR.getNamespacePrefix());
/* 254 */         soapHeader.addChildElement(soapElement);
/*     */       }
/*     */ 
/* 257 */       appendRequiredHeader(soapHeader, ADDR.getActionQName(), getAction());
/*     */ 
/* 260 */       if (((getReplyTo() != null) || (getFaultTo() != null)) && (null == getMessageID()))
/*     */       {
/* 262 */         throw new AddressingException("Required addressing header missing:" + ADDR.getMessageIDQName());
/*     */       }
/* 264 */       if (getMessageID() != null)
/*     */       {
/* 266 */         SOAPElement wsaMessageId = soapHeader.addChildElement(new NameImpl(ADDR.getMessageIDQName()));
/* 267 */         wsaMessageId.addTextNode(getMessageID().getURI().toString());
/*     */       }
/*     */ 
/* 271 */       if (getRelatesTo() != null)
/*     */       {
/* 273 */         for (Relationship rel : getRelatesTo())
/*     */         {
/* 275 */           SOAPElement wsaRelatesTo = soapHeader.addChildElement(new NameImpl(ADDR.getRelatesToQName()));
/* 276 */           if (rel.getType() != null)
/*     */           {
/* 278 */             wsaRelatesTo.setAttribute(ADDR.getRelationshipTypeName(), getPrefixedName(rel.getType()));
/*     */           }
/* 280 */           wsaRelatesTo.addTextNode(rel.getID().toString());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 285 */       ReferenceParameters refParams = getReferenceParameters();
/* 286 */       if ((refParams.getElements().size() > 0) || (refParams.getAttributes().size() > 0))
/*     */       {
/* 288 */         SOAPElement wsaRefParams = soapHeader.addChildElement(new NameImpl(ADDR.getReferenceParametersQName()));
/* 289 */         appendAttributes(wsaRefParams, refParams.getAttributes());
/* 290 */         appendElements(wsaRefParams, refParams.getElements());
/*     */       }
/*     */ 
/* 293 */       appendElements(soapHeader, getElements());
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 297 */       throw new AddressingException("Cannot read ws-addressing headers", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendRequiredHeader(SOAPHeader soapHeader, QName name, AttributedURI value) throws SOAPException
/*     */   {
/* 303 */     if (null == value) {
/* 304 */       throw new AddressingException("Required addressing property missing: " + name);
/*     */     }
/* 306 */     SOAPElement element = soapHeader.addChildElement(new NameImpl(name));
/* 307 */     element.addTextNode(value.getURI().toString());
/*     */ 
/* 309 */     if (this.mustunderstand)
/*     */     {
/* 312 */       String envNS = soapHeader.getParentElement().getNamespaceURI();
/* 313 */       element.addNamespaceDeclaration("soap", envNS);
/* 314 */       element.addAttribute(new QName(envNS, "mustUnderstand", "soap"), "1");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMu(boolean mu)
/*     */   {
/* 320 */     this.mustunderstand = mu;
/*     */   }
/*     */ 
/*     */   private void appendAttributes(SOAPElement soapElement, Map<QName, String> attributes)
/*     */   {
/* 325 */     for (QName qname : attributes.keySet())
/*     */     {
/* 327 */       String qualname = getPrefixedName(qname);
/* 328 */       String value = (String)attributes.get(qname);
/* 329 */       soapElement.setAttribute(qualname, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendElements(SOAPElement soapElement, List<Object> elements)
/*     */   {
/*     */     try
/*     */     {
/* 337 */       factory = (SOAPFactoryImpl)SOAPFactory.newInstance();
/* 338 */       for (i$ = elements.iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 340 */         if ((obj instanceof Element))
/*     */         {
/* 342 */           SOAPElement child = factory.createElement((Element)obj);
/* 343 */           soapElement.addChildElement(child);
/*     */         }
/* 345 */         else if ((obj instanceof String))
/*     */         {
/* 347 */           Element el = DOMUtils.parse((String)obj);
/* 348 */           SOAPElement child = factory.createElement(el);
/* 349 */           soapElement.addChildElement(child);
/*     */         }
/*     */         else
/*     */         {
/* 353 */           throw new AddressingException("Unsupported element: " + obj.getClass().getName());
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/*     */       SOAPFactoryImpl factory;
/*     */       Iterator i$;
/* 359 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 363 */       throw new AddressingException("Cannot append elements", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getPrefixedName(QName qname)
/*     */   {
/* 369 */     String prefix = qname.getPrefix();
/* 370 */     String localPart = qname.getLocalPart();
/* 371 */     String qualname = (prefix != null) && (prefix.length() > 0) ? prefix + ":" + localPart : localPart;
/* 372 */     return qualname;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl
 * JD-Core Version:    0.6.0
 */