/*     */ package org.jboss.ws.extensions.addressing.jaxws;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.AddressingException;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import javax.xml.ws.handler.soap.SOAPMessageContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.jaxws.handler.GenericSOAPHandler;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl;
/*     */ 
/*     */ public class WSAddressingClientHandler extends GenericSOAPHandler
/*     */ {
/*  55 */   private static Logger log = Logger.getLogger(WSAddressingClientHandler.class);
/*     */   private static AddressingBuilder ADDR_BUILDER;
/*     */   private static AddressingConstantsImpl ADDR_CONSTANTS;
/*  59 */   private static Set<QName> HEADERS = new HashSet();
/*     */ 
/*     */   public Set getHeaders()
/*     */   {
/*  72 */     return Collections.unmodifiableSet(HEADERS);
/*     */   }
/*     */ 
/*     */   protected boolean handleOutbound(MessageContext msgContext)
/*     */   {
/*  77 */     log.debug("handleOutbound");
/*     */ 
/*  79 */     SOAPAddressingProperties addrProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context");
/*  80 */     if (addrProps != null)
/*     */     {
/*  82 */       msgContext.put("javax.xml.ws.addressing.context.outbound", addrProps);
/*  83 */       msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
/*     */     }
/*     */ 
/*  86 */     addrProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
/*  87 */     if (addrProps != null)
/*     */     {
/*  89 */       SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/*  90 */       addrProps.writeHeaders(soapMessage);
/*     */     }
/*     */     else
/*     */     {
/*  95 */       addrProps = (SOAPAddressingPropertiesImpl)ADDR_BUILDER.newAddressingProperties();
/*  96 */       msgContext.put("javax.xml.ws.addressing.context.outbound", addrProps);
/*  97 */       msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
/*     */     }
/*     */ 
/* 100 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean handleInbound(MessageContext msgContext)
/*     */   {
/* 105 */     log.debug("handleInbound");
/*     */     try
/*     */     {
/* 109 */       SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/* 110 */       if (soapMessage.getSOAPPart().getEnvelope() != null)
/*     */       {
/* 112 */         SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
/* 113 */         SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
/* 114 */         addrProps.readHeaders(soapMessage);
/* 115 */         msgContext.put("javax.xml.ws.addressing.context", addrProps);
/* 116 */         msgContext.setScope("javax.xml.ws.addressing.context", MessageContext.Scope.APPLICATION);
/* 117 */         msgContext.put("javax.xml.ws.addressing.context.inbound", addrProps);
/* 118 */         msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 123 */       throw new AddressingException("Cannot handle response", ex);
/*     */     }
/*     */ 
/* 126 */     return true;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  63 */     ADDR_CONSTANTS = new AddressingConstantsImpl();
/*  64 */     ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
/*     */ 
/*  66 */     HEADERS.add(ADDR_CONSTANTS.getActionQName());
/*  67 */     HEADERS.add(ADDR_CONSTANTS.getToQName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.jaxws.WSAddressingClientHandler
 * JD-Core Version:    0.6.0
 */