/*     */ package org.jboss.ws.extensions.addressing.jaxrpc;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.handler.GenericHandler;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import javax.xml.rpc.handler.soap.SOAPMessageContext;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.AddressingException;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl;
/*     */ 
/*     */ public class WSAddressingClientHandler extends GenericHandler
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(WSAddressingClientHandler.class);
/*     */   private static AddressingBuilder ADDR_BUILDER;
/*     */   private static AddressingConstantsImpl ADDR_CONSTANTS;
/*  55 */   private static QName[] HEADERS = new QName[2];
/*     */ 
/*     */   public QName[] getHeaders()
/*     */   {
/*  68 */     return HEADERS;
/*     */   }
/*     */ 
/*     */   public void init(HandlerInfo handlerInfo)
/*     */   {
/*  73 */     super.init(handlerInfo);
/*     */   }
/*     */ 
/*     */   public boolean handleRequest(MessageContext msgContext)
/*     */   {
/*  78 */     log.debug("handleRequest");
/*     */ 
/*  80 */     SOAPAddressingProperties addrProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context");
/*  81 */     if (addrProps != null) {
/*  82 */       msgContext.setProperty("javax.xml.ws.addressing.context.outbound", addrProps);
/*     */     }
/*  84 */     addrProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
/*  85 */     if (addrProps != null)
/*     */     {
/*  87 */       SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/*  88 */       addrProps.writeHeaders(soapMessage);
/*     */     }
/*     */     else
/*     */     {
/*  93 */       addrProps = (SOAPAddressingPropertiesImpl)ADDR_BUILDER.newAddressingProperties();
/*  94 */       msgContext.setProperty("javax.xml.ws.addressing.context.outbound", addrProps);
/*     */     }
/*     */ 
/*  97 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean handleResponse(MessageContext msgContext)
/*     */   {
/* 102 */     log.debug("handleResponse");
/*     */     try
/*     */     {
/* 106 */       SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/* 107 */       if (soapMessage.getSOAPPart().getEnvelope() != null)
/*     */       {
/* 109 */         SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
/* 110 */         SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
/* 111 */         addrProps.readHeaders(soapMessage);
/* 112 */         msgContext.setProperty("javax.xml.ws.addressing.context", addrProps);
/* 113 */         msgContext.setProperty("javax.xml.ws.addressing.context.inbound", addrProps);
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 118 */       throw new AddressingException("Cannot handle response", ex);
/*     */     }
/*     */ 
/* 121 */     return true;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  59 */     ADDR_CONSTANTS = new AddressingConstantsImpl();
/*  60 */     ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
/*     */ 
/*  62 */     HEADERS[0] = ADDR_CONSTANTS.getActionQName();
/*  63 */     HEADERS[1] = ADDR_CONSTANTS.getToQName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.jaxrpc.WSAddressingClientHandler
 * JD-Core Version:    0.6.0
 */