/*     */ package org.jboss.ws.extensions.addressing;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.StringWriter;
/*     */ import java.net.URI;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.addressing.AddressingConstants;
/*     */ import javax.xml.ws.addressing.AddressingException;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import javax.xml.ws.addressing.EndpointReference;
/*     */ import javax.xml.ws.addressing.Metadata;
/*     */ import javax.xml.ws.addressing.ReferenceParameters;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EndpointReferenceImpl extends AttributeElementExtensibleImpl
/*     */   implements EndpointReference
/*     */ {
/*  56 */   private static AddressingConstants ADDR = new AddressingConstantsImpl();
/*     */ 
/*  59 */   private QName rootQName = new QName(ADDR.getNamespaceURI(), "EndpointReference", ADDR.getNamespacePrefix());
/*     */ 
/*  61 */   private AttributedURIImpl address = new AttributedURIImpl(ADDR.getAnonymousURI());
/*     */ 
/*  63 */   private ReferenceParametersImpl refParams = new ReferenceParametersImpl();
/*     */ 
/*  65 */   private MetadataImpl metadata = new MetadataImpl();
/*     */ 
/*     */   public EndpointReferenceImpl(URI uri)
/*     */   {
/*  69 */     this.address = new AttributedURIImpl(uri);
/*     */   }
/*     */ 
/*     */   public EndpointReferenceImpl(Element elRoot)
/*     */   {
/*  74 */     initFromElement(elRoot);
/*     */   }
/*     */ 
/*     */   public QName getRootQName()
/*     */   {
/*  79 */     return this.rootQName;
/*     */   }
/*     */ 
/*     */   public void setRootQName(QName rootElementName)
/*     */   {
/*  84 */     this.rootQName = rootElementName;
/*     */   }
/*     */ 
/*     */   public AttributedURI getAddress()
/*     */   {
/*  89 */     return this.address;
/*     */   }
/*     */ 
/*     */   public ReferenceParameters getReferenceParameters()
/*     */   {
/*  94 */     return this.refParams;
/*     */   }
/*     */ 
/*     */   public Metadata getMetadata()
/*     */   {
/*  99 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   private void initFromElement(Element elRoot)
/*     */   {
/* 104 */     if (elRoot == null) {
/* 105 */       throw new IllegalArgumentException("Cannot initialize from null element");
/*     */     }
/*     */     try
/*     */     {
/* 109 */       Map attributes = DOMUtils.getAttributes(elRoot);
/* 110 */       for (QName attqname : attributes.keySet())
/*     */       {
/* 112 */         String value = (String)attributes.get(attqname);
/* 113 */         addAttribute(attqname, value);
/*     */       }
/*     */ 
/* 116 */       Iterator it = DOMUtils.getChildElements(elRoot);
/* 117 */       while (it.hasNext())
/*     */       {
/* 119 */         Element el = (Element)it.next();
/* 120 */         QName qname = DOMUtils.getElementQName(el);
/*     */ 
/* 123 */         if (qname.equals(ADDR.getAddressQName()))
/*     */         {
/* 125 */           this.address = new AttributedURIImpl(DOMUtils.getTextContent(el));
/*     */ 
/* 127 */           attributes = DOMUtils.getAttributes(el);
/* 128 */           for (QName attqname : attributes.keySet())
/*     */           {
/* 130 */             String value = (String)attributes.get(attqname);
/* 131 */             this.address.addAttribute(attqname, value);
/*     */           }
/*     */ 
/*     */         }
/* 135 */         else if (qname.equals(ADDR.getReferenceParametersQName()))
/*     */         {
/* 137 */           attributes = DOMUtils.getAttributes(el);
/* 138 */           for (QName attqname : attributes.keySet())
/*     */           {
/* 140 */             String value = (String)attributes.get(attqname);
/* 141 */             this.refParams.addAttribute(attqname, value);
/*     */           }
/* 143 */           Iterator itel = DOMUtils.getChildElements(el);
/* 144 */           while (itel.hasNext())
/*     */           {
/* 146 */             Element child = (Element)itel.next();
/* 147 */             this.refParams.addElement(child);
/*     */           }
/*     */ 
/*     */         }
/* 151 */         else if (qname.equals(ADDR.getMetadataQName()))
/*     */         {
/* 153 */           attributes = DOMUtils.getAttributes(el);
/* 154 */           for (QName attqname : attributes.keySet())
/*     */           {
/* 156 */             String value = (String)attributes.get(attqname);
/* 157 */             this.metadata.addAttribute(attqname, value);
/*     */           }
/* 159 */           Iterator itel = DOMUtils.getChildElements(el);
/* 160 */           while (itel.hasNext())
/*     */           {
/* 162 */             Element child = (Element)itel.next();
/* 163 */             this.metadata.addElement(child);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 168 */           addElement(el);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 174 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 178 */       throw new AddressingException("Cannot init EPR from element", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Element toElement()
/*     */   {
/* 184 */     String xmlString = toXMLString(false);
/*     */     try
/*     */     {
/* 187 */       return DOMUtils.parse(xmlString);
/*     */     }
/*     */     catch (IOException ex) {
/*     */     }
/* 191 */     throw new WSException("Cannot parse: " + xmlString, ex);
/*     */   }
/*     */ 
/*     */   public String toXMLString(boolean pretty)
/*     */   {
/* 197 */     if (pretty)
/*     */     {
/* 199 */       Element epRef = toElement();
/* 200 */       return DOMWriter.printNode(epRef, true);
/*     */     }
/*     */ 
/* 203 */     SOAPAddressingBuilder builder = new SOAPAddressingBuilderImpl();
/* 204 */     AddressingConstants ADDR = builder.newAddressingConstants();
/*     */ 
/* 206 */     String rootname = getPrefixedName(this.rootQName);
/* 207 */     StringBuilder xmlBuffer = new StringBuilder("<" + rootname);
/* 208 */     appendAttributes(xmlBuffer, getAttributes());
/* 209 */     xmlBuffer.append(">");
/*     */ 
/* 212 */     String wsaURI = ADDR.getNamespaceURI();
/* 213 */     String wsaPrefix = ADDR.getNamespacePrefix();
/* 214 */     String wsaDeclaration = " xmlns:" + wsaPrefix + "='" + wsaURI + "'";
/* 215 */     if (xmlBuffer.indexOf(wsaDeclaration) < 0)
/*     */     {
/* 217 */       xmlBuffer.insert(rootname.length() + 1, wsaDeclaration);
/*     */     }
/*     */ 
/* 221 */     xmlBuffer.append("<" + getPrefixedName(ADDR.getAddressQName()));
/* 222 */     appendAttributes(xmlBuffer, this.address.getAttributes());
/* 223 */     xmlBuffer.append(">");
/* 224 */     xmlBuffer.append(this.address.getURI() + "</" + getPrefixedName(ADDR.getAddressQName()) + ">");
/*     */ 
/* 227 */     if ((this.refParams.getElements().size() > 0) || (this.refParams.getAttributes().size() > 0))
/*     */     {
/* 229 */       xmlBuffer.append("<" + getPrefixedName(ADDR.getReferenceParametersQName()));
/* 230 */       appendAttributes(xmlBuffer, this.refParams.getAttributes());
/* 231 */       xmlBuffer.append(">");
/* 232 */       appendElements(xmlBuffer, this.refParams.getElements());
/* 233 */       xmlBuffer.append("</" + getPrefixedName(ADDR.getReferenceParametersQName()) + ">");
/*     */     }
/*     */ 
/* 237 */     if ((this.metadata.getElements().size() > 0) || (this.metadata.getAttributes().size() > 0))
/*     */     {
/* 239 */       xmlBuffer.append("<" + getPrefixedName(ADDR.getMetadataQName()));
/* 240 */       appendAttributes(xmlBuffer, this.metadata.getAttributes());
/* 241 */       xmlBuffer.append(">");
/* 242 */       appendElements(xmlBuffer, this.metadata.getElements());
/* 243 */       xmlBuffer.append("</" + getPrefixedName(ADDR.getMetadataQName()) + ">");
/*     */     }
/*     */ 
/* 247 */     appendElements(xmlBuffer, getElements());
/*     */ 
/* 249 */     xmlBuffer.append("</" + rootname + ">");
/*     */ 
/* 251 */     String xmlString = xmlBuffer.toString();
/* 252 */     return xmlString;
/*     */   }
/*     */ 
/*     */   private void appendAttributes(StringBuilder xmlBuffer, Map<QName, String> attributes)
/*     */   {
/* 257 */     for (QName qname : attributes.keySet())
/*     */     {
/* 259 */       String qualname = getPrefixedName(qname);
/* 260 */       String value = (String)attributes.get(qname);
/* 261 */       xmlBuffer.append(" " + qualname + "='" + value + "'");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendElements(StringBuilder xmlBuffer, List<Object> elements)
/*     */   {
/* 267 */     for (Iterator i$ = elements.iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 269 */       if ((obj instanceof Element))
/*     */       {
/* 271 */         StringWriter strwr = new StringWriter();
/* 272 */         DOMWriter domWriter = new DOMWriter(strwr).setCompleteNamespaces(false);
/* 273 */         domWriter.print((Element)obj);
/* 274 */         String xmlFragment = strwr.toString();
/* 275 */         xmlBuffer.append(xmlFragment);
/*     */       }
/* 277 */       else if ((obj instanceof String))
/*     */       {
/* 279 */         xmlBuffer.append(obj);
/*     */       }
/*     */       else
/*     */       {
/* 283 */         throw new AddressingException("Unsupported element: " + obj.getClass().getName());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getPrefixedName(QName qname)
/*     */   {
/* 290 */     String prefix = qname.getPrefix();
/* 291 */     String localPart = qname.getLocalPart();
/* 292 */     String qualname = (prefix != null) && (prefix.length() > 0) ? prefix + ":" + localPart : localPart;
/* 293 */     return qualname;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 298 */     return toXMLString(true);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.EndpointReferenceImpl
 * JD-Core Version:    0.6.0
 */