/*     */ package org.jboss.ws.extensions.addressing;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.AddressingConstants;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.AddressingType;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import javax.xml.ws.addressing.EndpointReference;
/*     */ import javax.xml.ws.addressing.ReferenceParameters;
/*     */ import javax.xml.ws.addressing.Relationship;
/*     */ 
/*     */ public class AddressingPropertiesImpl extends ElementExtensibleImpl
/*     */   implements AddressingProperties
/*     */ {
/*  62 */   private static AddressingConstants ADDR = new AddressingConstantsImpl();
/*     */   private AttributedURI to;
/*     */   private AttributedURI action;
/*     */   private AttributedURI messageId;
/*     */   private Relationship[] relatesTo;
/*     */   private EndpointReference replyTo;
/*     */   private EndpointReference faultTo;
/*     */   private EndpointReference from;
/*  79 */   private ReferenceParameters refParams = new ReferenceParametersImpl();
/*     */ 
/*  81 */   private Map<QName, AddressingType> addrTypes = new HashMap();
/*     */ 
/*  83 */   private boolean initialized = false;
/*     */ 
/*     */   public AttributedURI getTo()
/*     */   {
/*  87 */     return this.to;
/*     */   }
/*     */ 
/*     */   public void setTo(AttributedURI to)
/*     */   {
/*  92 */     this.to = to;
/*     */   }
/*     */ 
/*     */   public AttributedURI getAction()
/*     */   {
/*  97 */     return this.action;
/*     */   }
/*     */ 
/*     */   public void setAction(AttributedURI action)
/*     */   {
/* 102 */     this.action = action;
/*     */   }
/*     */ 
/*     */   public AttributedURI getMessageID()
/*     */   {
/* 107 */     return this.messageId;
/*     */   }
/*     */ 
/*     */   public void setMessageID(AttributedURI iri)
/*     */   {
/* 112 */     this.messageId = iri;
/*     */   }
/*     */ 
/*     */   public Relationship[] getRelatesTo()
/*     */   {
/* 117 */     return this.relatesTo;
/*     */   }
/*     */ 
/*     */   public void setRelatesTo(Relationship[] relatesTo)
/*     */   {
/* 122 */     this.relatesTo = relatesTo;
/*     */   }
/*     */ 
/*     */   public EndpointReference getReplyTo()
/*     */   {
/* 127 */     return this.replyTo;
/*     */   }
/*     */ 
/*     */   public void setReplyTo(EndpointReference replyTo)
/*     */   {
/* 132 */     this.replyTo = replyTo;
/*     */   }
/*     */ 
/*     */   public EndpointReference getFaultTo()
/*     */   {
/* 137 */     return this.faultTo;
/*     */   }
/*     */ 
/*     */   public void setFaultTo(EndpointReference faultTo)
/*     */   {
/* 142 */     this.faultTo = faultTo;
/*     */   }
/*     */ 
/*     */   public EndpointReference getFrom()
/*     */   {
/* 147 */     return this.from;
/*     */   }
/*     */ 
/*     */   public void setFrom(EndpointReference from)
/*     */   {
/* 152 */     this.from = from;
/*     */   }
/*     */ 
/*     */   public ReferenceParameters getReferenceParameters()
/*     */   {
/* 157 */     return this.refParams;
/*     */   }
/*     */ 
/*     */   public void initializeAsDestination(EndpointReference epr)
/*     */   {
/* 171 */     if (this.initialized) return;
/*     */ 
/* 173 */     if (epr == null) {
/* 174 */       throw new IllegalArgumentException("Invalid null endpoint reference");
/*     */     }
/* 176 */     this.to = epr.getAddress();
/*     */ 
/* 178 */     ReferenceParameters srcParams = epr.getReferenceParameters();
/* 179 */     for (Iterator i$ = srcParams.getElements().iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 181 */       SOAPElement soapElement = (SOAPElement)obj;
/* 182 */       soapElement.setAttributeNS(getNamespaceURI(), "wsa:IsReferenceParameter", "true");
/* 183 */       addElement(soapElement);
/*     */     }
/*     */ 
/* 186 */     this.initialized = true;
/*     */   }
/*     */ 
/*     */   public void initializeAsReply(AddressingProperties props, boolean isFault)
/*     */   {
/* 202 */     if (this.initialized) return;
/*     */ 
/* 204 */     EndpointReference epr = isFault ? props.getFaultTo() : null;
/* 205 */     if (epr == null)
/*     */     {
/* 207 */       epr = props.getReplyTo();
/*     */     }
/* 209 */     this.to = (epr != null ? epr.getAddress() : new AttributedURIImpl(ADDR.getAnonymousURI()));
/*     */     Iterator i$;
/* 211 */     if (epr != null)
/*     */     {
/* 213 */       ReferenceParameters srcParams = epr.getReferenceParameters();
/* 214 */       for (i$ = srcParams.getElements().iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 216 */         SOAPElement soapElement = (SOAPElement)obj;
/* 217 */         soapElement.setAttributeNS(getNamespaceURI(), "wsa:IsReferenceParameter", "true");
/* 218 */         addElement(soapElement);
/*     */       }
/*     */     }
/* 221 */     if (props.getMessageID() != null)
/*     */     {
/* 223 */       AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
/* 224 */       Relationship rel = builder.newRelationship(props.getMessageID().getURI());
/* 225 */       this.relatesTo = new Relationship[] { rel };
/*     */     }
/*     */ 
/* 228 */     this.initialized = true;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 235 */     return this.addrTypes.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 240 */     return this.addrTypes.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object arg0)
/*     */   {
/* 245 */     return this.addrTypes.containsKey(arg0);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object arg0)
/*     */   {
/* 250 */     return this.addrTypes.containsValue(arg0);
/*     */   }
/*     */ 
/*     */   public AddressingType get(Object arg0)
/*     */   {
/* 255 */     return (AddressingType)this.addrTypes.get(arg0);
/*     */   }
/*     */ 
/*     */   public AddressingType put(QName arg0, AddressingType arg1)
/*     */   {
/* 260 */     return (AddressingType)this.addrTypes.put(arg0, arg1);
/*     */   }
/*     */ 
/*     */   public AddressingType remove(Object arg0)
/*     */   {
/* 265 */     return (AddressingType)this.addrTypes.remove(arg0);
/*     */   }
/*     */ 
/*     */   public void putAll(Map<? extends QName, ? extends AddressingType> arg0)
/*     */   {
/* 270 */     this.addrTypes.putAll(arg0);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 275 */     this.addrTypes.clear();
/*     */   }
/*     */ 
/*     */   public Set<QName> keySet()
/*     */   {
/* 280 */     return this.addrTypes.keySet();
/*     */   }
/*     */ 
/*     */   public Collection<AddressingType> values()
/*     */   {
/* 285 */     return this.addrTypes.values();
/*     */   }
/*     */ 
/*     */   public Set<Map.Entry<QName, AddressingType>> entrySet()
/*     */   {
/* 290 */     return this.addrTypes.entrySet();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.AddressingPropertiesImpl
 * JD-Core Version:    0.6.0
 */