/*     */ package org.jboss.ws.extensions.addressing;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import javax.xml.rpc.Stub;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.AddressingConstants;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import org.jboss.ws.core.utils.UUIDGenerator;
/*     */ 
/*     */ public class AddressingClientUtil
/*     */ {
/*  24 */   private static AddressingBuilder BUILDER = AddressingBuilder.getAddressingBuilder();
/*  25 */   private static AddressingConstants CONSTANTS = BUILDER.newAddressingConstants();
/*     */ 
/*     */   public static AddressingProperties createRequestProperties()
/*     */   {
/*  31 */     AddressingProperties addrProps = BUILDER.newAddressingProperties();
/*  32 */     addrProps.setMessageID(BUILDER.newURI(generateMessageID()));
/*  33 */     return addrProps;
/*     */   }
/*     */ 
/*     */   public static AddressingProperties createDefaultProps(String wsaAction, String wsaTo)
/*     */   {
/*     */     try
/*     */     {
/*  43 */       AddressingProperties addrProps = createRequestProperties();
/*  44 */       addrProps.setMessageID(BUILDER.newURI(generateMessageID()));
/*  45 */       addrProps.setAction(BUILDER.newURI(wsaAction));
/*  46 */       addrProps.setTo(BUILDER.newURI(wsaTo));
/*  47 */       return addrProps;
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/*  51 */     throw new IllegalArgumentException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public static AddressingProperties createAnonymousProps(String wsaAction, String wsaTo)
/*     */   {
/*     */     try
/*     */     {
/*  63 */       AddressingProperties addrProps = createDefaultProps(wsaAction, wsaTo);
/*  64 */       addrProps.setReplyTo(BUILDER.newEndpointReference(new URI(CONSTANTS.getAnonymousURI())));
/*  65 */       return addrProps;
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/*  69 */     throw new IllegalArgumentException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public static AddressingProperties createOneWayProps(String wsaAction, String wsaTo)
/*     */   {
/*     */     try
/*     */     {
/*  81 */       AddressingProperties addrProps = createDefaultProps(wsaAction, wsaTo);
/*  82 */       addrProps.setReplyTo(BUILDER.newEndpointReference(new URI(CONSTANTS.getNoneURI())));
/*  83 */       return addrProps;
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/*  87 */     throw new IllegalArgumentException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public static void setTargetAddress(Stub stub, String url)
/*     */   {
/*  96 */     stub._setProperty("javax.xml.rpc.service.endpoint.address", url);
/*     */   }
/*     */ 
/*     */   public static URI generateMessageID()
/*     */   {
/* 104 */     URI messageId = null;
/*     */     try
/*     */     {
/* 107 */       messageId = new URI("urn:uuid:" + UUIDGenerator.generateRandomUUIDString());
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/*     */     }
/*     */ 
/* 113 */     return messageId;
/*     */   }
/*     */ 
/*     */   public static AttributedURI createMessageID()
/*     */   {
/* 118 */     return BUILDER.newURI(generateMessageID());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.AddressingClientUtil
 * JD-Core Version:    0.6.0
 */