/*    */ package org.jboss.ws.extensions.addressing;
/*    */ 
/*    */ import java.net.URI;
/*    */ import java.net.URISyntaxException;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.ws.addressing.AddressingBuilder;
/*    */ import javax.xml.ws.addressing.AddressingConstants;
/*    */ import javax.xml.ws.addressing.AddressingProperties;
/*    */ import javax.xml.ws.addressing.AttributedQName;
/*    */ import javax.xml.ws.addressing.AttributedURI;
/*    */ import javax.xml.ws.addressing.EndpointReference;
/*    */ import javax.xml.ws.addressing.Relationship;
/*    */ 
/*    */ public class AddressingBuilderImpl extends AddressingBuilder
/*    */ {
/*    */   public AttributedURI newURI(URI uri)
/*    */   {
/* 48 */     return new AttributedURIImpl(uri);
/*    */   }
/*    */ 
/*    */   public AttributedURI newURI(String uri) throws URISyntaxException
/*    */   {
/* 53 */     return newURI(new URI(uri));
/*    */   }
/*    */ 
/*    */   public AttributedQName newQName(QName name)
/*    */   {
/* 58 */     return new AttributedQNameImpl(name);
/*    */   }
/*    */ 
/*    */   public Relationship newRelationship(URI uri)
/*    */   {
/* 63 */     return new RelationshipImpl(uri);
/*    */   }
/*    */ 
/*    */   public EndpointReference newEndpointReference(URI uri)
/*    */   {
/* 68 */     return new EndpointReferenceImpl(uri);
/*    */   }
/*    */ 
/*    */   public AddressingProperties newAddressingProperties()
/*    */   {
/* 73 */     return new AddressingPropertiesImpl();
/*    */   }
/*    */ 
/*    */   public AddressingConstants newAddressingConstants()
/*    */   {
/* 78 */     return new AddressingConstantsImpl();
/*    */   }
/*    */ 
/*    */   public String getNamespaceURI()
/*    */   {
/* 83 */     return new AddressingTypeImpl().getNamespaceURI();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.AddressingBuilderImpl
 * JD-Core Version:    0.6.0
 */