/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class XMLPredefinedEntityReferenceResolver
/*     */ {
/*  34 */   private static HashMap<String, Character> entities = new HashMap();
/*     */ 
/*     */   private static int resolveCharRef(String source, int pos, StringBuilder builder)
/*     */   {
/*  47 */     int radix = 10;
/*  48 */     pos += 2; if (source.charAt(pos) == 'x')
/*     */     {
/*  50 */       pos++;
/*  51 */       radix = 16;
/*     */     }
/*     */ 
/*  54 */     int end = source.indexOf(';', pos);
/*  55 */     if (end == -1) {
/*  56 */       throw new IllegalArgumentException("Invalid character reference");
/*     */     }
/*  58 */     int c = Integer.parseInt(source.substring(pos, end), radix);
/*  59 */     builder.append((char)c);
/*     */ 
/*  61 */     return end + 1;
/*     */   }
/*     */ 
/*     */   private static int resolveEntityRef(String source, int pos, StringBuilder builder)
/*     */   {
/*  66 */     pos++; int end = source.indexOf(';', pos);
/*  67 */     if (end == -1) {
/*  68 */       throw new IllegalArgumentException("Invalid entity reference");
/*     */     }
/*  70 */     String entity = source.substring(pos, end);
/*  71 */     Character c = (Character)entities.get(entity);
/*  72 */     if (c == null) {
/*  73 */       throw new IllegalArgumentException("Invalid entity: " + entity);
/*     */     }
/*  75 */     builder.append(c.charValue());
/*     */ 
/*  77 */     return end + 1;
/*     */   }
/*     */ 
/*     */   public static String resolve(String normalized)
/*     */   {
/*  88 */     StringBuilder builder = new StringBuilder();
/*  89 */     int end = normalized.length();
/*  90 */     int pos = normalized.indexOf('&');
/*  91 */     int last = 0;
/*     */ 
/*  94 */     if (pos == -1) {
/*  95 */       return normalized;
/*     */     }
/*  97 */     while (pos != -1)
/*     */     {
/*  99 */       String sub = normalized.subSequence(last, pos).toString();
/* 100 */       builder.append(sub);
/*     */ 
/* 102 */       int peek = pos + 1;
/* 103 */       if (peek == end) {
/* 104 */         throw new IllegalArgumentException("Invalid entity reference");
/*     */       }
/* 106 */       if (normalized.charAt(peek) == '#')
/* 107 */         pos = resolveCharRef(normalized, pos, builder);
/*     */       else {
/* 109 */         pos = resolveEntityRef(normalized, pos, builder);
/*     */       }
/* 111 */       last = pos;
/* 112 */       pos = normalized.indexOf('&', pos);
/*     */     }
/*     */ 
/* 115 */     if (last < end)
/*     */     {
/* 117 */       String sub = normalized.subSequence(last, end).toString();
/* 118 */       builder.append(sub);
/*     */     }
/*     */ 
/* 121 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  38 */     entities.put("quot", Character.valueOf('"'));
/*  39 */     entities.put("amp", Character.valueOf('&'));
/*  40 */     entities.put("lt", Character.valueOf('<'));
/*  41 */     entities.put("gt", Character.valueOf('>'));
/*  42 */     entities.put("apos", Character.valueOf('\''));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.XMLPredefinedEntityReferenceResolver
 * JD-Core Version:    0.6.0
 */