/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import java.security.SecureRandom;
/*     */ 
/*     */ public class UUIDGenerator
/*     */ {
/*     */   private static SecureRandom rand;
/*     */ 
/*     */   private static String bytesToHex(byte[] buffer, int offset, int length)
/*     */   {
/*  42 */     long value = 0L;
/*  43 */     int i = 0; for (int countDown = 8 * length; i < length; i++)
/*     */     {
/*  45 */       countDown -= 8; value |= (buffer[(offset + i)] & 0xFF) << countDown;
/*     */     }
/*     */ 
/*  48 */     return Long.toHexString(value);
/*     */   }
/*     */ 
/*     */   public static byte[] generateRandomUUIDBytes()
/*     */   {
/*  58 */     if (rand == null) {
/*  59 */       rand = new SecureRandom();
/*     */     }
/*  61 */     byte[] buffer = new byte[16];
/*  62 */     rand.nextBytes(buffer);
/*     */ 
/*  65 */     buffer[6] = (byte)(buffer[6] & 0xF | 0x40);
/*     */ 
/*  67 */     buffer[8] = (byte)(buffer[8] & 0x3F | 0x80);
/*     */ 
/*  69 */     return buffer;
/*     */   }
/*     */ 
/*     */   public static String generateRandomUUIDString()
/*     */   {
/*  81 */     return convertToString(generateRandomUUIDBytes());
/*     */   }
/*     */ 
/*     */   public static String convertToString(byte[] uuid)
/*     */   {
/* 110 */     if (uuid.length != 16) {
/* 111 */       throw new IllegalArgumentException("A UUID must be 16 bytes!");
/*     */     }
/* 113 */     String string = bytesToHex(uuid, 0, 4) + "-" + bytesToHex(uuid, 4, 2) + "-" + bytesToHex(uuid, 6, 2) + "-" + bytesToHex(uuid, 8, 2) + "-" + bytesToHex(uuid, 10, 6);
/*     */ 
/* 119 */     return string;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.UUIDGenerator
 * JD-Core Version:    0.6.0
 */